/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptChangeUtil {
    private static final Logger LOG = Logger.getInstance((String)TypeScriptChangeUtil.class.getName());

    private TypeScriptChangeUtil() {
    }

    @NotNull
    public static TypeScriptType createTypeFromText(Project project, @NotNull String text) {
        TypeScriptType type;
        if (text == null) {
            TypeScriptChangeUtil.$$$reportNull$$$0(0);
        }
        if ((type = TypeScriptChangeUtil.tryCreateTypeFromText(project, text)) == null) {
            LOG.error(text + " wasn't parsed as TypeScript type", new Attachment[]{new Attachment("text.txt", text)});
        }
        TypeScriptType typeScriptType = type;
        if (typeScriptType == null) {
            TypeScriptChangeUtil.$$$reportNull$$$0(1);
        }
        return typeScriptType;
    }

    public static PsiElement createClassMemberFromText(Project project, @NotNull String text) {
        if (text == null) {
            TypeScriptChangeUtil.$$$reportNull$$$0(2);
        }
        return TypeScriptChangeUtil.createClassMemberFromText(project, text, null);
    }

    public static PsiElement createClassMemberFromText(Project project, @NotNull String text, @Nullable DialectOptionHolder holder) {
        if (text == null) {
            TypeScriptChangeUtil.$$$reportNull$$$0(3);
        }
        JSLanguageDialect dialect = holder == null || !holder.isTSX ? JavaScriptSupportLoader.TYPESCRIPT : JavaScriptSupportLoader.TYPESCRIPT_JSX;
        return JSChangeUtil.createClassMemberFromText(project, text, dialect).getPsi();
    }

    @Nullable
    private static TypeScriptType tryCreateTypeFromText(Project project, @NotNull String text) {
        ASTNode node;
        if (text == null) {
            TypeScriptChangeUtil.$$$reportNull$$$0(4);
        }
        if ((node = JSChangeUtil.createStatementFromText(project, text = "var a:" + text, JavaScriptSupportLoader.TYPESCRIPT)) == null) {
            return null;
        }
        JSVarStatement varStatement = (JSVarStatement)node.getPsi();
        JSVariable variable = varStatement.getVariables()[0];
        return (TypeScriptType)variable.getTypeElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/psi/TypeScriptChangeUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/psi/TypeScriptChangeUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTypeFromText";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createClassMemberFromText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateTypeFromText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

