/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings;

import com.intellij.application.options.editor.AutoImportOptionsProvider;
import com.intellij.ide.DataManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class JSImportOptionsProvider
implements AutoImportOptionsProvider {
    private JBCheckBox myAddTypeScriptImports;
    private JBCheckBox myAddES6Imports;
    private JPanel myPanel = new JPanel((LayoutManager)new GridLayoutManager(4, 1));

    public JSImportOptionsProvider() {
        this.myPanel.setBorder(IdeBorderFactory.createTitledBorder((String)JSBundle.message((String)"es6.auto.import.options.title", (Object[])new Object[0])));
        this.myAddES6Imports = new JBCheckBox(JSBundle.message((String)"es6.auto.import.options.completion.add.imports", (Object[])new Object[0]));
        this.myAddTypeScriptImports = new JBCheckBox(JSBundle.message((String)"typescript.auto.import.options.completion.add.imports", (Object[])new Object[0]));
        this.myPanel.add((Component)this.myAddES6Imports, this.createConstraints(0));
        this.myPanel.add((Component)JSImportOptionsProvider.createLinkComponent("JavaScript"), this.createConstraints(1));
        this.myPanel.add((Component)this.myAddTypeScriptImports, this.createConstraints(2));
        this.myPanel.add((Component)JSImportOptionsProvider.createLinkComponent("TypeScript"), this.createConstraints(3));
    }

    @NotNull
    private static HyperlinkLabel createLinkComponent(@NotNull String name) {
        if (name == null) {
            JSImportOptionsProvider.$$$reportNull$$$0(0);
        }
        HyperlinkLabel label = new HyperlinkLabel();
        label.setHyperlinkText("Find more configuration options in ", "Code Style", "");
        label.addHyperlinkListener(e -> {
            Settings settings;
            DataContext context;
            if (name == null) {
                JSImportOptionsProvider.$$$reportNull$$$0(3);
            }
            if ((context = (DataContext)DataManager.getInstance().getDataContextFromFocus().getResult()) != null && (settings = (Settings)Settings.KEY.getData(context)) != null) {
                Configurable configurable = settings.find("preferences.sourceCode." + name);
                settings.select(configurable);
            }
        });
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)label);
        HyperlinkLabel hyperlinkLabel = label;
        if (hyperlinkLabel == null) {
            JSImportOptionsProvider.$$$reportNull$$$0(1);
        }
        return hyperlinkLabel;
    }

    @NotNull
    public GridConstraints createConstraints(int row) {
        GridConstraints constraints = new GridConstraints();
        constraints.setRow(row);
        constraints.setAnchor(9);
        GridConstraints gridConstraints = constraints;
        if (gridConstraints == null) {
            JSImportOptionsProvider.$$$reportNull$$$0(2);
        }
        return gridConstraints;
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        return settings.isShowTypeScriptAutoImport() != this.myAddTypeScriptImports.isSelected() || settings.isShowJavaScriptAutoImport() != this.myAddES6Imports.isSelected();
    }

    public void apply() throws ConfigurationException {
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        settings.setShowTypeScriptAutoImport(this.myAddTypeScriptImports.isSelected());
        settings.setShowJavaScriptAutoImport(this.myAddES6Imports.isSelected());
    }

    public void reset() {
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        this.myAddTypeScriptImports.setSelected(settings.isShowTypeScriptAutoImport());
        this.myAddES6Imports.setSelected(settings.isShowJavaScriptAutoImport());
    }

    public void disposeUIResources() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/settings/JSImportOptionsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/settings/JSImportOptionsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createLinkComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstraints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLinkComponent";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createLinkComponent$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

