/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig.checkers;

import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptConfigIncludeBase;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptConfigPatternInclude
extends TypeScriptConfigIncludeBase {
    @Nullable
    private final Pattern myIncludeDirectoriesRegPattern;
    @Nullable
    private final Pattern myIncludeFilesRegPattern;
    @NotNull
    private final Collection<String> myPatterns;
    private final Collection<VirtualFile> myFiles;

    public TypeScriptConfigPatternInclude(@NotNull TypeScriptConfig config2) {
        if (config2 == null) {
            TypeScriptConfigPatternInclude.$$$reportNull$$$0(0);
        }
        super(config2);
        this.myPatterns = config2.getIncludePatterns();
        this.myIncludeDirectoriesRegPattern = TypeScriptConfigPatternInclude.computeIncludeDirectoriesRegPattern(this.myPatterns, this.myConfigDirectory);
        this.myIncludeFilesRegPattern = TypeScriptConfigPatternInclude.computeIncludeFilesRegPattern(this.myPatterns, this.myConfigDirectory);
        this.myFiles = config2.getFileList();
    }

    @Nullable
    private static Pattern computeIncludeFilesRegPattern(@NotNull Collection<String> includedPatterns, @NotNull VirtualFile configDirectory) {
        if (includedPatterns == null) {
            TypeScriptConfigPatternInclude.$$$reportNull$$$0(1);
        }
        if (configDirectory == null) {
            TypeScriptConfigPatternInclude.$$$reportNull$$$0(2);
        }
        if (includedPatterns.isEmpty()) {
            return null;
        }
        String wildcard = TypeScriptConfigUtil.getRegularExpressionForGlobPattern(includedPatterns, configDirectory, TypeScriptConfigUtil.WildCardType.FILES);
        return TypeScriptConfigPatternInclude.createPattern(wildcard, configDirectory);
    }

    @Nullable
    private static Pattern computeIncludeDirectoriesRegPattern(@NotNull Collection<String> includedPatterns, @NotNull VirtualFile configDirectory) {
        if (includedPatterns == null) {
            TypeScriptConfigPatternInclude.$$$reportNull$$$0(3);
        }
        if (configDirectory == null) {
            TypeScriptConfigPatternInclude.$$$reportNull$$$0(4);
        }
        if (includedPatterns.isEmpty()) {
            return null;
        }
        String wildcard = TypeScriptConfigUtil.getRegularExpressionForGlobPattern(includedPatterns, configDirectory, TypeScriptConfigUtil.WildCardType.DIRECTORIES);
        return TypeScriptConfigPatternInclude.createPattern(wildcard, configDirectory);
    }

    @Override
    public boolean accept(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptConfigPatternInclude.$$$reportNull$$$0(5);
        }
        return this.isIncludedFile(file, true) || this.myFiles.contains(file) || this.isIncludeTypesFile(file);
    }

    public boolean isIncludedFile(@NotNull VirtualFile file, boolean checkExclude) {
        Pattern filePattern;
        if (file == null) {
            TypeScriptConfigPatternInclude.$$$reportNull$$$0(6);
        }
        String filePath = file.getPath();
        VirtualFile parent = file.getParent();
        if (parent == null) {
            return false;
        }
        boolean skipCheckExclude = !checkExclude;
        String directoryPath = parent.getCanonicalPath();
        Pattern directoriesPattern = this.myIncludeDirectoriesRegPattern;
        return directoriesPattern != null ? directoryPath != null && TypeScriptConfigPatternInclude.checkPattern(directoryPath, directoriesPattern) && ((filePattern = this.myIncludeFilesRegPattern) != null ? TypeScriptConfigPatternInclude.checkPattern(filePath, filePattern) && (skipCheckExclude || !this.isExcludedFile(file)) : skipCheckExclude || !this.isExcludedFile(file)) : (filePattern = this.myIncludeFilesRegPattern) != null && TypeScriptConfigPatternInclude.checkPattern(filePath, filePattern) && (skipCheckExclude || !this.isExcludedFile(file));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeScriptConfigPatternInclude include = (TypeScriptConfigPatternInclude)o;
        if (!this.myPatterns.equals(include.myPatterns)) {
            return false;
        }
        return this.myFiles.equals(include.myFiles);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myPatterns.hashCode();
        result = 31 * result + this.myFiles.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedPatterns";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDirectory";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/tsconfig/checkers/TypeScriptConfigPatternInclude";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "computeIncludeFilesRegPattern";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "computeIncludeDirectoriesRegPattern";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isIncludedFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

