/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCacheService;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptFunctionSignatureChecker
extends JSFunctionSignatureChecker {
    public TypeScriptFunctionSignatureChecker(JSTypeChecker<Annotation> typeChecker) {
        super(typeChecker);
    }

    @Override
    protected void registerProblem(JSCallExpression callExpression, String message, LocalQuickFix ... fixes) {
        PsiElement place = ValidateTypesUtil.getPlaceForSignatureProblem(callExpression, callExpression.getArgumentList());
        ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR;
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression && !TypeScriptUtil.resolveIsStrict((JSReferenceExpression)methodExpression)) {
            highlightType = ProblemHighlightType.WEAK_WARNING;
        }
        this.myTypeChecker.registerProblem(place, message, highlightType, fixes);
    }

    @Override
    protected void canBeCalledWithArguments(@Nullable JSType type, @NotNull JSCallExpression node, @NotNull LocalQuickFix[] quickFixes) {
        if (node == null) {
            TypeScriptFunctionSignatureChecker.$$$reportNull$$$0(0);
        }
        if (quickFixes == null) {
            TypeScriptFunctionSignatureChecker.$$$reportNull$$$0(1);
        }
        type = JSTypeUtils.getValuableType(type);
        boolean isNewExpression = node instanceof JSNewExpression;
        if (type == null) {
            return;
        }
        List functionTypes = JSTypeUtils.getFunctionType(type, isNewExpression).collect(Collectors.toList());
        if (functionTypes.size() == 1) {
            super.canBeCalledWithArguments((JSType)functionTypes.get(0), node, quickFixes);
            return;
        }
        if (functionTypes.isEmpty()) {
            this.registerProblem(node, JSBundle.message((String)"javascript.argument.types.mismatch", (Object[])new Object[0]), new LocalQuickFix[0]);
            return;
        }
        List<JSType> arguments = TypeScriptGenericTypesEvaluator.getArgumentTypesForSignatureChecking(node);
        ProcessingContext processingContext = JSTypeComparingCacheService.getProcessingContextWithCache((PsiElement)node);
        processingContext.put(JSGenericParameterImpl.CALL_ENV_KEY, (Object)true);
        for (JSType functionType : functionTypes) {
            if (!JSTypeUtils.canBeCalledWithArguments(functionType, arguments, isNewExpression, processingContext)) continue;
            return;
        }
        List functionsWithSameArgumentsCount = functionTypes.stream().filter(el -> el instanceof JSFunctionTypeImpl && ((JSFunctionTypeImpl)((Object)el)).getParameters().size() == arguments.size()).collect(Collectors.toList());
        if (functionsWithSameArgumentsCount.size() == 1) {
            super.canBeCalledWithArguments((JSType)functionsWithSameArgumentsCount.get(0), node, quickFixes);
        } else {
            this.registerProblem(node, JSBundle.message((String)"javascript.argument.types.mismatch", (Object[])new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Override
    protected void checkCallArgumentType(JSParameterItem p, JSExpression exp, JSCallExpression node, PsiElement resolveResult) {
        Ref ref = Ref.create();
        JSType type = this.addGenericTypesFromCall(p.getType(), node, resolveResult, arg_0 -> ((Ref)ref).set(arg_0));
        if (ref.get() != null && type != null) {
            this.myTypeChecker.registerProblem((PsiElement)exp, JSBundle.message((String)((String)ref.get()), (Object[])new Object[0]), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)exp), new LocalQuickFix[0]);
        }
        this.myTypeChecker.checkExpressionIsAssignableToType(exp, type, "javascript.argument.type.mismatch", (PsiElement)(p instanceof JSParameter ? (JSParameter)p : null), JSTypeComparingCacheService.getProcessingContextWithCache((PsiElement)exp));
    }

    @Override
    @Nullable
    @Contract(value="!null, _, _, _ -> !null")
    protected JSType addGenericTypesFromCall(@Nullable JSType type, JSCallExpression callExpression, PsiElement resolveResult, JSGenericTypesEvaluator.GenericErrorReporter reporter) {
        if (JSTypeUtils.hasGenericParameter(type)) {
            type = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(type, callExpression.getMethodExpression(), resolveResult, reporter);
            JSTypeSubstitutor genericArguments = TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(resolveResult, (PsiElement)callExpression, null);
            if (genericArguments != null && !genericArguments.isEmpty()) {
                return JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)genericArguments, true, reporter);
            }
        }
        return type;
    }

    @Override
    protected boolean obtainNextMatchedParams(int[] matchedParams, JSParameterItem[] parameters) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "node";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "quickFixes";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/typescript/validation/TypeScriptFunctionSignatureChecker";
        objectArray[2] = "canBeCalledWithArguments";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

