/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.utils;

import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.utils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryParenthesesChecker {
    private UnnecessaryParenthesesChecker() {
    }

    public static boolean shouldRemove(@NotNull JSParenthesizedExpression expression) {
        int childPrecedence;
        PsiElement expressionParent;
        if (expression == null) {
            UnnecessaryParenthesesChecker.$$$reportNull$$$0(0);
        }
        if (!((expressionParent = expression.getParent()) instanceof JSElement)) {
            return false;
        }
        JSElement parent = (JSElement)expressionParent;
        JSExpression body = expression.getInnerExpression();
        if (!(parent instanceof JSExpression)) {
            JSDefinitionExpression definitionExpression;
            JSAssignmentExpression assignmentExpression;
            if (body instanceof JSCallExpression && ((JSCallExpression)body).getMethodExpression() instanceof JSFunctionExpression) {
                return false;
            }
            JSAssignmentExpression jSAssignmentExpression = assignmentExpression = body instanceof JSAssignmentExpression ? (JSAssignmentExpression)body : null;
            return assignmentExpression == null || (definitionExpression = assignmentExpression.getDefinitionExpression()) == null || PsiTreeUtil.getChildOfType((PsiElement)definitionExpression, JSObjectLiteralExpression.class) == null;
        }
        if (body instanceof JSParenthesizedExpression) {
            return true;
        }
        int parentPrecedence = ParenthesesUtils.getPrecendence((JSExpression)parent);
        if (parentPrecedence > (childPrecedence = ParenthesesUtils.getPrecendence(body))) {
            return !(body instanceof JSFunctionExpression);
        }
        if (parentPrecedence == childPrecedence) {
            if (parent instanceof JSBinaryExpression && body instanceof JSBinaryExpression) {
                IElementType parentOperator = ((JSBinaryExpression)parent).getOperationSign();
                IElementType childOperator = ((JSBinaryExpression)body).getOperationSign();
                JSBinaryExpression binaryExpression = (JSBinaryExpression)parent;
                JSExpression lhs = binaryExpression.getLOperand();
                return lhs != null && lhs.equals(expression) && parentOperator.equals(childOperator);
            }
            return false;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/utils/UnnecessaryParenthesesChecker", "shouldRemove"));
    }
}

