/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.guice.GuiceBundle;
import com.intellij.guice.constants.GuiceAnnotations;
import com.intellij.guice.inspections.BaseInspection;
import com.intellij.guice.inspections.BaseInspectionVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class BindingAnnotationWithoutInjectInspection
extends BaseInspection {
    private static Collection<String> INJECT_OR_PROVIDES = ContainerUtil.immutableList((Object[])new String[]{"com.google.inject.Inject", "javax.inject.Inject", "com.google.inject.Provides"});

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = GuiceBundle.message("binding.annotation.without.inject.problem.descriptor", new Object[0]);
        if (string == null) {
            BindingAnnotationWithoutInjectInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    public static boolean isBindingAnnotation(PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
        if (referenceElement == null) {
            return false;
        }
        PsiElement element = referenceElement.resolve();
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass annotationClass = (PsiClass)element;
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)annotationClass, (String)"com.google.inject.BindingAnnotation", (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/BindingAnnotationWithoutInjectInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            if (!BindingAnnotationWithoutInjectInspection.isBindingAnnotation(annotation)) {
                return;
            }
            PsiVariable boundVariable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiVariable.class);
            if (boundVariable == null) {
                return;
            }
            if (boundVariable instanceof PsiField) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)boundVariable, GuiceAnnotations.INJECTS, (boolean)true)) {
                    this.registerError((PsiElement)annotation, new Object[0]);
                }
            } else if (boundVariable instanceof PsiParameter) {
                PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)boundVariable, PsiMethod.class);
                if (containingMethod == null) {
                    return;
                }
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)containingMethod, (Collection)INJECT_OR_PROVIDES) && !Visitor.isAssisted(annotation, containingMethod)) {
                    this.registerError((PsiElement)annotation, new Object[0]);
                }
            }
        }

        private static boolean isAssisted(@NotNull PsiAnnotation annotation, @NotNull PsiMethod method) {
            if (annotation == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (method == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (!"com.google.inject.assistedinject.Assisted".equals(annotation.getQualifiedName())) {
                return false;
            }
            if (method.isConstructor() && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"com.google.inject.assistedinject.AssistedInject", (boolean)true)) {
                return true;
            }
            PsiClass containingClass = method.getContainingClass();
            return containingClass != null && containingClass.isInterface();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "annotation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "method";
                    break;
                }
            }
            objectArray[1] = "com/intellij/guice/inspections/BindingAnnotationWithoutInjectInspection$Visitor";
            objectArray[2] = "isAssisted";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

