/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.TaskExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessWaitFor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseInputStreamReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseOSProcessHandler
extends ProcessHandler
implements TaskExecutor {
    private static final Logger LOG = Logger.getInstance(BaseOSProcessHandler.class);
    private static final BaseOutputReader.Options ADAPTIVE_NON_BLOCKING = new BaseOutputReader.Options(){

        @Override
        public BaseDataReader.SleepingPolicy policy() {
            return new BaseDataReader.AdaptiveSleepingPolicy();
        }
    };
    protected final Process myProcess;
    protected final String myCommandLine;
    protected final Charset myCharset;
    protected final String myPresentableName;
    protected final ProcessWaitFor myWaitFor;

    public BaseOSProcessHandler(@NotNull Process process, String commandLine, @Nullable Charset charset) {
        if (process == null) {
            BaseOSProcessHandler.$$$reportNull$$$0(0);
        }
        this.myProcess = process;
        this.myCommandLine = commandLine;
        this.myCharset = charset;
        if (StringUtil.isEmpty(commandLine)) {
            LOG.warn(new IllegalArgumentException("Must specify non-empty 'commandLine' parameter"));
        }
        this.myPresentableName = CommandLineUtil.extractPresentableName(StringUtil.notNullize(commandLine));
        this.myWaitFor = new ProcessWaitFor(process, this, this.myPresentableName);
    }

    @NotNull
    protected Future<?> executeOnPooledThread(@NotNull Runnable task) {
        if (task == null) {
            BaseOSProcessHandler.$$$reportNull$$$0(1);
        }
        Future<?> future = ProcessIOExecutorService.INSTANCE.submit(task);
        if (future == null) {
            BaseOSProcessHandler.$$$reportNull$$$0(2);
        }
        return future;
    }

    @Override
    @NotNull
    public Future<?> executeTask(@NotNull Runnable task) {
        if (task == null) {
            BaseOSProcessHandler.$$$reportNull$$$0(3);
        }
        Future<?> future = this.executeOnPooledThread(task);
        if (future == null) {
            BaseOSProcessHandler.$$$reportNull$$$0(4);
        }
        return future;
    }

    @NotNull
    public Process getProcess() {
        Process process = this.myProcess;
        if (process == null) {
            BaseOSProcessHandler.$$$reportNull$$$0(5);
        }
        return process;
    }

    protected boolean useAdaptiveSleepingPolicyWhenReadingOutput() {
        return false;
    }

    protected boolean useNonBlockingRead() {
        return !Registry.is("output.reader.blocking.mode", false);
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        if (!this.useNonBlockingRead()) {
            BaseOutputReader.Options options = BaseOutputReader.Options.BLOCKING;
            if (options == null) {
                BaseOSProcessHandler.$$$reportNull$$$0(6);
            }
            return options;
        }
        if (this.useAdaptiveSleepingPolicyWhenReadingOutput()) {
            BaseOutputReader.Options options = ADAPTIVE_NON_BLOCKING;
            if (options == null) {
                BaseOSProcessHandler.$$$reportNull$$$0(7);
            }
            return options;
        }
        BaseOutputReader.Options options = BaseOutputReader.Options.NON_BLOCKING;
        if (options == null) {
            BaseOSProcessHandler.$$$reportNull$$$0(8);
        }
        return options;
    }

    protected boolean processHasSeparateErrorStream() {
        return true;
    }

    @Override
    public void startNotify() {
        if (this.myCommandLine != null) {
            this.notifyTextAvailable(this.myCommandLine + '\n', ProcessOutputTypes.SYSTEM);
        }
        this.addProcessListener(new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    BaseOutputReader.Options options = BaseOSProcessHandler.this.readerOptions();
                    final BaseDataReader stdOutReader = BaseOSProcessHandler.this.createOutputDataReader(options.policy());
                    final BaseDataReader stdErrReader = BaseOSProcessHandler.this.processHasSeparateErrorStream() ? BaseOSProcessHandler.this.createErrorDataReader(options.policy()) : null;
                    BaseOSProcessHandler.this.myWaitFor.setTerminationCallback(new Consumer<Integer>(){

                        @Override
                        public void consume(Integer exitCode) {
                            try {
                                if (stdErrReader != null) {
                                    stdErrReader.stop();
                                }
                                stdOutReader.stop();
                                try {
                                    if (stdErrReader != null) {
                                        stdErrReader.waitFor();
                                    }
                                    stdOutReader.waitFor();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            finally {
                                BaseOSProcessHandler.this.onOSProcessTerminated(exitCode);
                            }
                        }
                    });
                }
                finally {
                    BaseOSProcessHandler.this.removeProcessListener(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/process/BaseOSProcessHandler$2", "startNotified"));
            }
        });
        super.startNotify();
    }

    protected BaseDataReader createErrorDataReader(BaseDataReader.SleepingPolicy policy) {
        return this.createErrorDataReader();
    }

    protected BaseDataReader createOutputDataReader(BaseDataReader.SleepingPolicy policy) {
        return this.createOutputDataReader();
    }

    @NotNull
    protected BaseDataReader createErrorDataReader() {
        SimpleOutputReader simpleOutputReader = new SimpleOutputReader(this.createProcessErrReader(), ProcessOutputTypes.STDERR, this.readerOptions(), "error stream of " + this.myPresentableName);
        if (simpleOutputReader == null) {
            BaseOSProcessHandler.$$$reportNull$$$0(9);
        }
        return simpleOutputReader;
    }

    @NotNull
    protected BaseDataReader createOutputDataReader() {
        SimpleOutputReader simpleOutputReader = new SimpleOutputReader(this.createProcessOutReader(), ProcessOutputTypes.STDOUT, this.readerOptions(), "output stream of " + this.myPresentableName);
        if (simpleOutputReader == null) {
            BaseOSProcessHandler.$$$reportNull$$$0(10);
        }
        return simpleOutputReader;
    }

    protected void onOSProcessTerminated(int exitCode) {
        this.notifyProcessTerminated(exitCode);
    }

    @NotNull
    protected Reader createProcessOutReader() {
        Reader reader = this.createInputStreamReader(this.myProcess.getInputStream());
        if (reader == null) {
            BaseOSProcessHandler.$$$reportNull$$$0(11);
        }
        return reader;
    }

    @NotNull
    protected Reader createProcessErrReader() {
        Reader reader = this.createInputStreamReader(this.myProcess.getErrorStream());
        if (reader == null) {
            BaseOSProcessHandler.$$$reportNull$$$0(12);
        }
        return reader;
    }

    @NotNull
    private Reader createInputStreamReader(@NotNull InputStream streamToRead) {
        Charset charset;
        if (streamToRead == null) {
            BaseOSProcessHandler.$$$reportNull$$$0(13);
        }
        if ((charset = this.getCharset()) == null) {
            charset = Charset.defaultCharset();
        }
        BaseInputStreamReader baseInputStreamReader = new BaseInputStreamReader(streamToRead, charset);
        if (baseInputStreamReader == null) {
            BaseOSProcessHandler.$$$reportNull$$$0(14);
        }
        return baseInputStreamReader;
    }

    @Override
    protected void destroyProcessImpl() {
        try {
            this.closeStreams();
        }
        finally {
            this.doDestroyProcess();
        }
    }

    protected void doDestroyProcess() {
        this.getProcess().destroy();
    }

    @Override
    protected void detachProcessImpl() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BaseOSProcessHandler.this.closeStreams();
                BaseOSProcessHandler.this.myWaitFor.detach();
                BaseOSProcessHandler.this.notifyProcessDetached();
            }
        };
        this.executeOnPooledThread(runnable);
    }

    protected void closeStreams() {
        try {
            this.myProcess.getOutputStream().close();
        }
        catch (IOException e) {
            LOG.warn(e);
        }
    }

    @Override
    public boolean detachIsDefault() {
        return false;
    }

    @Override
    public OutputStream getProcessInput() {
        return this.myProcess.getOutputStream();
    }

    public String getCommandLine() {
        return this.myCommandLine;
    }

    @Nullable
    public Charset getCharset() {
        return this.myCharset;
    }

    public String toString() {
        return this.myCommandLine;
    }

    @Override
    public boolean waitFor() {
        boolean result = super.waitFor();
        try {
            this.myWaitFor.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public boolean waitFor(long timeoutInMilliseconds) {
        boolean result = super.waitFor(timeoutInMilliseconds);
        try {
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return result &= this.myWaitFor.waitFor(timeoutInMilliseconds, TimeUnit.MILLISECONDS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/BaseOSProcessHandler";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamToRead";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/BaseOSProcessHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "executeOnPooledThread";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "executeTask";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcess";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readerOptions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorDataReader";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createOutputDataReader";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessOutReader";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessErrReader";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createInputStreamReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "executeOnPooledThread";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createInputStreamReader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SimpleOutputReader
    extends BaseOutputReader {
        private final Key myProcessOutputType;

        private SimpleOutputReader(Reader reader, Key outputType, @NotNull BaseOutputReader.Options options, String presentableName) {
            if (presentableName == null) {
                SimpleOutputReader.$$$reportNull$$$0(0);
            }
            super(reader, options);
            this.myProcessOutputType = outputType;
            this.start(presentableName);
        }

        @Override
        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                SimpleOutputReader.$$$reportNull$$$0(1);
            }
            Future<?> future = BaseOSProcessHandler.this.executeOnPooledThread(runnable);
            if (future == null) {
                SimpleOutputReader.$$$reportNull$$$0(2);
            }
            return future;
        }

        @Override
        protected void onTextAvailable(@NotNull String text) {
            if (text == null) {
                SimpleOutputReader.$$$reportNull$$$0(3);
            }
            BaseOSProcessHandler.this.notifyTextAvailable(text, this.myProcessOutputType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/process/BaseOSProcessHandler$SimpleOutputReader";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/process/BaseOSProcessHandler$SimpleOutputReader";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeOnPooledThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "executeOnPooledThread";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onTextAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ExecutorServiceHolder {
        public static Future<?> submit(@NotNull Runnable task) {
            if (task == null) {
                ExecutorServiceHolder.$$$reportNull$$$0(0);
            }
            LOG.warn("Deprecated method. Please use com.intellij.execution.process.BaseOSProcessHandler.executeTask() instead", new Throwable());
            return AppExecutorUtil.getAppExecutorService().submit(task);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/execution/process/BaseOSProcessHandler$ExecutorServiceHolder", "submit"));
        }
    }
}

