/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.io.JarUtil");

    public static boolean containsClass(@NotNull String jarPath, @NotNull String className) {
        if (jarPath == null) {
            JarUtil.$$$reportNull$$$0(0);
        }
        if (className == null) {
            JarUtil.$$$reportNull$$$0(1);
        }
        return JarUtil.containsClass(new File(jarPath), className);
    }

    public static boolean containsClass(@NotNull File file, String className) {
        if (file == null) {
            JarUtil.$$$reportNull$$$0(2);
        }
        String entryPath = className.replace('.', '/') + ".class";
        return JarUtil.containsEntry(file, entryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsEntry(File file, String entryPath) {
        if (file.canRead()) {
            boolean bl;
            JarFile jarFile = new JarFile(file);
            try {
                bl = jarFile.getEntry(entryPath) != null;
            }
            catch (Throwable throwable) {
                try {
                    jarFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            jarFile.close();
            return bl;
        }
        return false;
    }

    @Nullable
    public static String getJarAttribute(@NotNull File file, @NotNull Attributes.Name attribute) {
        if (file == null) {
            JarUtil.$$$reportNull$$$0(3);
        }
        if (attribute == null) {
            JarUtil.$$$reportNull$$$0(4);
        }
        return JarUtil.getJarAttributeImpl(file, null, attribute);
    }

    @Nullable
    public static String getJarAttribute(@NotNull File file, @NotNull String entryName, @NotNull Attributes.Name attribute) {
        if (file == null) {
            JarUtil.$$$reportNull$$$0(5);
        }
        if (entryName == null) {
            JarUtil.$$$reportNull$$$0(6);
        }
        if (attribute == null) {
            JarUtil.$$$reportNull$$$0(7);
        }
        return JarUtil.getJarAttributeImpl(file, entryName, attribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getJarAttributeImpl(@NotNull File file, @Nullable String entryName, @NotNull Attributes.Name attribute) {
        if (file == null) {
            JarUtil.$$$reportNull$$$0(8);
        }
        if (attribute == null) {
            JarUtil.$$$reportNull$$$0(9);
        }
        if (!file.canRead()) return null;
        try {
            JarFile jarFile = new JarFile(file);
            try {
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) return null;
                Attributes attributes = entryName != null ? manifest.getAttributes(entryName) : manifest.getMainAttributes();
                String string = attributes.getValue(attribute);
                return string;
            }
            finally {
                jarFile.close();
            }
        }
        catch (IOException e) {
            LOG.debug(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Properties loadProperties(@NotNull File file, @NotNull String entryName) {
        if (file == null) {
            JarUtil.$$$reportNull$$$0(10);
        }
        if (entryName == null) {
            JarUtil.$$$reportNull$$$0(11);
        }
        if (!file.canRead()) return null;
        try {
            ZipFile zipFile = new ZipFile(file);
            try {
                ZipEntry entry = zipFile.getEntry(entryName);
                if (entry == null) return null;
                Properties properties = new Properties();
                properties.load(zipFile.getInputStream(entry));
                Properties properties2 = properties;
                return properties2;
            }
            finally {
                zipFile.close();
            }
        }
        catch (IOException e) {
            LOG.debug(e);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/io/JarUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "containsClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getJarAttribute";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getJarAttributeImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "loadProperties";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

