/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.data.commons.inspections.SpringDataRepositoriesInspection;
import com.intellij.spring.data.commons.projection.SpringDataProjectionUtil;
import com.intellij.spring.data.commons.util.parser.PartTree;
import com.intellij.spring.data.utils.SpringDataBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDataRepositoryMethodReturnTypeInspection
extends SpringDataRepositoriesInspection {
    @Override
    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, @NotNull PsiClass repositoryClass, @NotNull PsiMethod psiMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        PsiTypeElement identifier;
        PsiClass domainType;
        if (holder == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(0);
        }
        if (repositoryClass == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(1);
        }
        if (psiMethod == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(2);
        }
        if (module == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(3);
        }
        if (typePair == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(4);
        }
        if ((domainType = (PsiClass)typePair.first) == null) {
            return;
        }
        if (!SpringDataRepositoryMethodReturnTypeInspection.isAssignableReturnType(domainType, repositoryClass, psiMethod) && (identifier = psiMethod.getReturnTypeElement()) != null) {
            holder.registerProblem((PsiElement)identifier, SpringDataBundle.message("incorrect.method.return.type", domainType.getName()), new LocalQuickFix[0]);
        }
    }

    public static boolean isAssignableReturnType(@NotNull PsiClass domainClass, @NotNull PsiClass repositoryClass, @NotNull PsiMethod psiMethod) {
        String name;
        PartTree partTree;
        PartTree.Subject subject;
        PsiType returnType;
        if (domainClass == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(5);
        }
        if (repositoryClass == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(6);
        }
        if (psiMethod == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(7);
        }
        if ((returnType = psiMethod.getReturnType()) instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)returnType) != null) {
            return true;
        }
        PsiClassType type = PsiTypesUtil.getClassType((PsiClass)domainClass);
        if (returnType == null) {
            return false;
        }
        if (SpringDataRepositoryMethodReturnTypeInspection.isAssignableTypeOrProjectionType(type, returnType, repositoryClass)) {
            return true;
        }
        PsiType genericType = SpringDataRepositoryMethodReturnTypeInspection.substituteGeoResultsTypeParameter(returnType);
        genericType = genericType != null ? genericType : PsiUtil.extractIterableTypeParameter((PsiType)returnType, (boolean)false);
        PsiType psiType = genericType = genericType != null ? genericType : SpringDataRepositoryMethodReturnTypeInspection.getSubstitutedTypeParameters(returnType);
        if (genericType != null) {
            if (SpringDataRepositoryMethodReturnTypeInspection.isAssignableTypeOrProjectionType(type, genericType, repositoryClass)) {
                return true;
            }
            PsiType iterableTypeParameter = PsiUtil.extractIterableTypeParameter((PsiType)genericType, (boolean)false);
            if (iterableTypeParameter != null && SpringDataRepositoryMethodReturnTypeInspection.isAssignableTypeOrProjectionType(type, iterableTypeParameter, repositoryClass)) {
                return true;
            }
        }
        if ((subject = (partTree = new PartTree(name = psiMethod.getName(), domainClass)).getSubject()).isDelete().booleanValue() || subject.isCountProjection()) {
            return returnType.isAssignableFrom((PsiType)PsiType.LONG);
        }
        return false;
    }

    public static boolean isAssignableTypeOrProjectionType(@NotNull PsiClassType domainType, @NotNull PsiType methodReturnType, @NotNull PsiClass repositoryClass) {
        if (domainType == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(8);
        }
        if (methodReturnType == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(9);
        }
        if (repositoryClass == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(10);
        }
        if (methodReturnType.isAssignableFrom((PsiType)domainType)) {
            return true;
        }
        if (methodReturnType instanceof PsiClassType) {
            PsiClass projectionClass = ((PsiClassType)methodReturnType).resolve();
            PsiClass domainClass = domainType.resolve();
            if (projectionClass != null && domainClass != null) {
                if (projectionClass instanceof PsiTypeParameter) {
                    return true;
                }
                if (!projectionClass.isInterface()) {
                    return false;
                }
                if (InheritanceUtil.isInheritor((PsiClass)projectionClass, (String)"java.lang.Iterable")) {
                    return false;
                }
                if (SpringDataProjectionUtil.isExplicitProjectionType(projectionClass, domainClass, repositoryClass)) {
                    return true;
                }
                if (SpringDataProjectionUtil.hasProjectionMethods(projectionClass, domainClass)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static PsiType substituteGeoResultsTypeParameter(PsiType returnType) {
        return SpringDataRepositoryMethodReturnTypeInspection.getSubstitutedTypeParameters(returnType, "org.springframework.data.geo.GeoResults");
    }

    @Nullable
    public static PsiType getSubstitutedTypeParameters(@Nullable PsiType returnType) {
        return SpringDataRepositoryMethodReturnTypeInspection.getSubstitutedTypeParameters(returnType, "java.util.Optional", "java.util.stream.Stream", "com.google.common.base.Optional", "com.google.common.util.concurrent.ListenableFuture", "java.util.concurrent.Future", "java.util.concurrent.CompletableFuture", "org.springframework.util.concurrent.ListenableFuture", "org.springframework.data.geo.GeoResult", "org.springframework.data.geo.GeoPage", "rx.Observable", "rx.Single", "reactor.core.publisher.Mono", "reactor.core.publisher.Flux");
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringDataRepositoryMethodReturnTypeInspection" == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(11);
        }
        return "SpringDataRepositoryMethodReturnTypeInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryClass";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePair";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReturnType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodReturnTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodReturnTypeInspection";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkRepositoryMethod";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableReturnType";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableTypeOrProjectionType";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

