/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.util.parser;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.spring.data.commons.util.parser.domain.PropertyPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class Part {
    private static final Pattern IGNORE_CASE = Pattern.compile("Ignor(ing|e)Case");
    private final PropertyPath propertyPath;
    private final Type type;
    private IgnoreCaseType ignoreCase;
    private String mySource;

    public Part(String source, PsiClass clazz) {
        this(source, clazz, false);
    }

    public Part(@NotNull String source, @NotNull PsiClass psiClass, boolean alwaysIgnoreCase) {
        if (source == null) {
            Part.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            Part.$$$reportNull$$$0(1);
        }
        this.ignoreCase = IgnoreCaseType.NEVER;
        this.mySource = source;
        String partToUse = this.detectAndSetIgnoreCase(source);
        if (alwaysIgnoreCase && this.ignoreCase != IgnoreCaseType.ALWAYS) {
            this.ignoreCase = IgnoreCaseType.WHEN_POSSIBLE;
        }
        this.type = Type.fromProperty(partToUse);
        this.propertyPath = PropertyPath.from(this.type.extractProperty(partToUse), (PsiType)JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(psiClass, PsiSubstitutor.EMPTY));
    }

    private String detectAndSetIgnoreCase(String part) {
        Matcher matcher = IGNORE_CASE.matcher(part);
        String result = part;
        if (matcher.find()) {
            this.ignoreCase = IgnoreCaseType.ALWAYS;
            result = part.substring(0, matcher.start()) + part.substring(matcher.end(), part.length());
        }
        return result;
    }

    public boolean getParameterRequired() {
        return this.getNumberOfArguments() > 0;
    }

    public int getNumberOfArguments() {
        return this.type.getNumberOfArguments();
    }

    public PropertyPath getProperty() {
        return this.propertyPath;
    }

    public Type getType() {
        return this.type;
    }

    public IgnoreCaseType shouldIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        Part that = (Part)obj;
        return this.propertyPath.equals(that.propertyPath) && this.type.equals((Object)that.type);
    }

    public int hashCode() {
        int result = 37;
        result += 17 * this.propertyPath.hashCode();
        return result += 17 * this.type.hashCode();
    }

    public String toString() {
        return "PART ('" + this.mySource + "'," + this.type.name() + ")";
    }

    public String getSource() {
        return this.mySource;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "source";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "psiClass";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/data/commons/util/parser/Part";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum IgnoreCaseType {
        NEVER,
        ALWAYS,
        WHEN_POSSIBLE;

    }

    public static enum Type {
        BETWEEN(2, "IsBetween", "Between"),
        IS_NOT_NULL(0, "IsNotNull", "NotNull"),
        IS_NULL(0, "IsNull", "Null"),
        LESS_THAN("IsLessThan", "LessThan"),
        LESS_THAN_EQUAL("IsLessThanEqual", "LessThanEqual"),
        GREATER_THAN("IsGreaterThan", "GreaterThan"),
        GREATER_THAN_EQUAL("IsGreaterThanEqual", "GreaterThanEqual"),
        BEFORE("IsBefore", "Before"),
        AFTER("IsAfter", "After"),
        NOT_LIKE("IsNotLike", "NotLike"),
        LIKE("IsLike", "Like"),
        STARTING_WITH("IsStartingWith", "StartingWith", "StartsWith"),
        ENDING_WITH("IsEndingWith", "EndingWith", "EndsWith"),
        NOT_CONTAINING("IsNotContaining", "NotContaining", "NotContains"),
        CONTAINING("IsContaining", "Containing", "Contains"),
        NOT_IN("IsNotIn", "NotIn"),
        IN("IsIn", "In"),
        NEAR("IsNear", "Near"),
        WITHIN("IsWithin", "Within"),
        REGEX("MatchesRegex", "Matches", "Regex"),
        EXISTS(0, "Exists"),
        TRUE(0, "IsTrue", "True"),
        FALSE(0, "IsFalse", "False"),
        NEGATING_SIMPLE_PROPERTY("IsNot", "Not"),
        SIMPLE_PROPERTY("Is", "Equals");

        private static final List<Type> ALL;
        public static final Collection<String> ALL_KEYWORDS;
        private final List<String> keywords;
        private final int numberOfArguments;

        private Type(int numberOfArguments, String ... keywords) {
            this.numberOfArguments = numberOfArguments;
            this.keywords = Arrays.asList(keywords);
        }

        private Type(String ... keywords) {
            this(1, keywords);
        }

        public static Type fromProperty(String rawProperty) {
            for (Type type : ALL) {
                if (!type.supports(rawProperty)) continue;
                return type;
            }
            return SIMPLE_PROPERTY;
        }

        public Collection<String> getKeywords() {
            return Collections.unmodifiableList(this.keywords);
        }

        protected boolean supports(String property) {
            if (this.keywords == null) {
                return true;
            }
            for (String keyword : this.keywords) {
                if (!property.endsWith(keyword)) continue;
                return true;
            }
            return false;
        }

        public int getNumberOfArguments() {
            return this.numberOfArguments;
        }

        public String extractProperty(String part) {
            String candidate = StringUtil.decapitalize((String)part);
            for (String keyword : this.keywords) {
                if (!candidate.endsWith(keyword)) continue;
                return candidate.substring(0, candidate.length() - keyword.length());
            }
            return candidate;
        }

        public String toString() {
            return String.format("%s (%s): %s", this.name(), this.getNumberOfArguments(), this.getKeywords());
        }

        static {
            ALL = Arrays.asList(IS_NOT_NULL, IS_NULL, BETWEEN, LESS_THAN, LESS_THAN_EQUAL, GREATER_THAN, GREATER_THAN_EQUAL, BEFORE, AFTER, NOT_LIKE, LIKE, STARTING_WITH, ENDING_WITH, NOT_CONTAINING, CONTAINING, NOT_IN, IN, NEAR, WITHIN, REGEX, EXISTS, TRUE, FALSE, NEGATING_SIMPLE_PROPERTY, SIMPLE_PROPERTY);
            ArrayList<String> allKeywords = new ArrayList<String>();
            for (Type type : ALL) {
                allKeywords.addAll(type.keywords);
            }
            ALL_KEYWORDS = Collections.unmodifiableList(allKeywords);
        }
    }
}

