/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework;

import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.AbstractMochaTddElement;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructure;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructureBuilder;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddSuite;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineSpecStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineSuiteStructure;
import com.intellij.javascript.testFramework.qunit.DefaultQUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitTestMethodStructure;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.index.JSIndexContent;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.VoidDataExternalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestFileByTestNameIndex
extends FileBasedIndexExtension<String, Void> {
    private static final String QUNIT_PREFIX = "Q\u0000";
    private static final String JASMINE_PREFIX = "J\u0000";
    private static final String TDD_PREFIX = "T\u0000";
    private static final char DELIMITER_CHAR = '\u0000';
    private static final String DELIMITER = String.valueOf('\u0000');
    private static final ID<String, Void> INDEX_ID = ID.create((String)"js.test.names");

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = INDEX_ID;
        if (iD == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = new DataIndexer<String, Void, FileContent>(){

            @NotNull
            public Map<String, Void> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(inputData.getPsiFile() instanceof JSFile)) {
                    Map<String, Void> map = Collections.emptyMap();
                    if (map == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map;
                }
                JSIndexContent content = JSIndexContent.indexFile((FileContent)inputData);
                JasmineFileStructure jasmineFileStructure = (JasmineFileStructure)JsTestFileByTestNameIndex.getStructure(content, JasmineFileStructureBuilder.getInstance());
                QUnitFileStructure qunitFileStructure = (QUnitFileStructure)JsTestFileByTestNameIndex.getStructure(content, QUnitFileStructureBuilder.getInstance());
                MochaTddFileStructure ttdFileStructure = (MochaTddFileStructure)JsTestFileByTestNameIndex.getStructure(content, MochaTddFileStructureBuilder.getInstance());
                if (jasmineFileStructure.isEmpty() && qunitFileStructure.isEmpty() && ttdFileStructure.isEmpty()) {
                    Map<String, Void> map = Collections.emptyMap();
                    if (map == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return map;
                }
                HashMap testNames = new HashMap();
                for (JasmineSuiteStructure suiteStructure : jasmineFileStructure.getSuites()) {
                    JsTestFileByTestNameIndex.addJasmineDescendantSuites((Map)testNames, suiteStructure, "J");
                }
                for (JasmineSpecStructure spec : jasmineFileStructure.getSpecs()) {
                    testNames.put(JsTestFileByTestNameIndex.JASMINE_PREFIX + spec.getName(), null);
                }
                DefaultQUnitModuleStructure defaultQUnitModuleStructure = qunitFileStructure.getDefaultModuleStructure();
                for (QUnitTestMethodStructure testMethodStructure : defaultQUnitModuleStructure.getTestMethodStructures()) {
                    testNames.put(JsTestFileByTestNameIndex.createQUnitKeyForTest(testMethodStructure), null);
                }
                for (QUnitModuleStructure moduleStructure : qunitFileStructure.getNonDefaultModuleStructures()) {
                    testNames.put(JsTestFileByTestNameIndex.createQUnitKeyForModule(moduleStructure), null);
                    for (QUnitTestMethodStructure testMethodStructure : moduleStructure.getTestMethodStructures()) {
                        testNames.put(JsTestFileByTestNameIndex.createQUnitKeyForTest(testMethodStructure), null);
                    }
                }
                for (MochaTddSuite suite : ttdFileStructure.getTopLevelSuites()) {
                    JsTestFileByTestNameIndex.addMochaTddNames(suite, (Map)testNames, JsTestFileByTestNameIndex.TDD_PREFIX + suite.getName());
                }
                HashMap hashMap = testNames;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(3);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    private static void addMochaTddNames(@NotNull AbstractMochaTddElement element, @NotNull Map<String, Void> names, @NotNull String prefix) {
        if (element == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(2);
        }
        if (names == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(3);
        }
        if (prefix == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(4);
        }
        names.put(prefix, null);
        if (element instanceof MochaTddSuite) {
            for (AbstractMochaTddElement child : ((MochaTddSuite)element).getChildren()) {
                JsTestFileByTestNameIndex.addMochaTddNames(child, names, prefix + '\u0000' + child.getName());
            }
        }
    }

    @NotNull
    private static <T extends AbstractTestFileStructure> T getStructure(@NotNull JSIndexContent content, @NotNull AbstractTestFileStructureBuilder<T> structureBuilder) {
        if (content == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(5);
        }
        if (structureBuilder == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(6);
        }
        AbstractTestFileStructure abstractTestFileStructure = (AbstractTestFileStructure)ObjectUtils.assertNotNull((Object)content.getAdditionalData(structureBuilder.KEY));
        if (abstractTestFileStructure == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(7);
        }
        return (T)abstractTestFileStructure;
    }

    @NotNull
    public static String createJasmineKey(@NotNull List<String> suiteNames) {
        if (suiteNames == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(8);
        }
        String string = JASMINE_PREFIX + StringUtil.join(suiteNames, (String)DELIMITER);
        if (string == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String createQUnitKey(@NotNull String moduleName, @Nullable String testName) {
        if (moduleName == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(10);
        }
        if (testName != null) {
            String string = QUNIT_PREFIX + moduleName + DELIMITER + testName;
            if (string == null) {
                JsTestFileByTestNameIndex.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = QUNIT_PREFIX + moduleName;
        if (string == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static String createQUnitKeyForModule(@NotNull QUnitModuleStructure moduleStructure) {
        if (moduleStructure == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(13);
        }
        String string = JsTestFileByTestNameIndex.createQUnitKey(moduleStructure.getName(), null);
        if (string == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static String createQUnitKeyForTest(@NotNull QUnitTestMethodStructure testMethodStructure) {
        if (testMethodStructure == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(15);
        }
        String string = JsTestFileByTestNameIndex.createQUnitKey(testMethodStructure.getModuleStructure().getName(), testMethodStructure.getName());
        if (string == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static String createQUnitKeyForTestFromDefaultModule(@NotNull String testMethodName) {
        if (testMethodName == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(17);
        }
        String string = JsTestFileByTestNameIndex.createQUnitKey("Default Module", testMethodName);
        if (string == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    public static JsTestFqn toFqn(@NotNull String indexKey) {
        if (indexKey == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(19);
        }
        JSTestFileType type = null;
        if (indexKey.startsWith(JASMINE_PREFIX)) {
            type = JSTestFileType.JASMINE;
        } else if (indexKey.startsWith(QUNIT_PREFIX)) {
            type = JSTestFileType.QUNIT;
        }
        if (type == null) {
            return null;
        }
        int ind = 2;
        ArrayList names = ContainerUtil.newArrayListWithCapacity((int)3);
        while (ind < indexKey.length()) {
            int delimiterInd = indexKey.indexOf(0, ind);
            if (delimiterInd == -1) {
                names.add(indexKey.substring(ind));
                break;
            }
            names.add(indexKey.substring(ind, delimiterInd));
            ind = delimiterInd + 1;
        }
        return new JsTestFqn(type, names);
    }

    private static void addJasmineDescendantSuites(@NotNull Map<String, Void> testNames, @NotNull JasmineSuiteStructure suite, @NotNull String prefix) {
        if (testNames == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(20);
        }
        if (suite == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(21);
        }
        if (prefix == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(22);
        }
        String nextPrefix = prefix + DELIMITER + suite.getName();
        testNames.put(nextPrefix, null);
        for (JasmineSuiteStructure childSuite : suite.getSuites()) {
            JsTestFileByTestNameIndex.addJasmineDescendantSuites(testNames, childSuite, nextPrefix);
        }
        for (JasmineSpecStructure spec : suite.getSpecs()) {
            testNames.put(nextPrefix + DELIMITER + spec.getName(), null);
        }
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(23);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Void> getValueExternalizer() {
        VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
        if (voidDataExternalizer == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(24);
        }
        return voidDataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.FileTypeSpecificInputFilter fileTypeSpecificInputFilter = new FileBasedIndex.FileTypeSpecificInputFilter(){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!file.isValid()) {
                    return false;
                }
                if (!file.isInLocalFileSystem()) {
                    return false;
                }
                if (file.getLength() > 0x100000L) {
                    return false;
                }
                return !JSLibraryUtil.isProbableLibraryFile((VirtualFile)file);
            }

            public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
                if (fileTypeSink == null) {
                    2.$$$reportNull$$$0(1);
                }
                List fileTypes = JavaScriptFileType.getFileTypesCompilableToJavaScript();
                for (FileType type : fileTypes) {
                    fileTypeSink.consume((Object)type);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileTypeSink";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptInput";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerFileTypesUsedForIndexing";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (fileTypeSpecificInputFilter == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(25);
        }
        return fileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 19;
    }

    @NotNull
    public static List<VirtualFile> findJsTestFilesByNameInScope(@NotNull String suiteKey, @NotNull GlobalSearchScope scope) {
        if (suiteKey == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(26);
        }
        if (scope == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(27);
        }
        List<VirtualFile> list = JsTestFileByTestNameIndex.findFilesByKey(suiteKey, scope, null);
        if (list == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    public static List<VirtualFile> findJsTestFilesByNameInScope(@NotNull String suiteKey, @NotNull GlobalSearchScope scope, @Nullable VirtualFile executedFile) {
        if (suiteKey == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(29);
        }
        if (scope == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(30);
        }
        List<VirtualFile> list = JsTestFileByTestNameIndex.findFilesByKey(suiteKey, scope, executedFile);
        if (list == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    public static List<VirtualFile> findFilesByKey(@NotNull String indexKey, @NotNull GlobalSearchScope scope) {
        if (indexKey == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(32);
        }
        if (scope == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(33);
        }
        List<VirtualFile> list = JsTestFileByTestNameIndex.findFilesByKey(indexKey, scope, null);
        if (list == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(34);
        }
        return list;
    }

    @Nullable
    private static String createIndexKey(@NotNull JsTestFqn testFqn) {
        if (testFqn == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(35);
        }
        if (testFqn.getType() == JSTestFileType.JASMINE) {
            return JASMINE_PREFIX + StringUtil.join(testFqn.getNames(), (String)DELIMITER);
        }
        if (testFqn.getType() == JSTestFileType.TDD) {
            return TDD_PREFIX + StringUtil.join(testFqn.getNames(), (String)DELIMITER);
        }
        return null;
    }

    @NotNull
    public static List<VirtualFile> findFilesByKey(@NotNull String suiteKey, @NotNull GlobalSearchScope scope, @Nullable VirtualFile executedFile) {
        Collection files;
        Project project;
        if (suiteKey == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(36);
        }
        if (scope == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(37);
        }
        if ((project = scope.getProject()) != null) {
            if (project.isDisposed()) {
                List<VirtualFile> list = Collections.emptyList();
                if (list == null) {
                    JsTestFileByTestNameIndex.$$$reportNull$$$0(38);
                }
                return list;
            }
            if (DumbService.isDumb((Project)project)) {
                List<VirtualFile> list = Collections.emptyList();
                if (list == null) {
                    JsTestFileByTestNameIndex.$$$reportNull$$$0(39);
                }
                return list;
            }
        }
        if ((files = FileBasedIndex.getInstance().getContainingFiles(INDEX_ID, (Object)suiteKey, scope)).isEmpty()) {
            List list = ContainerUtil.createMaybeSingletonList((Object)executedFile);
            if (list == null) {
                JsTestFileByTestNameIndex.$$$reportNull$$$0(40);
            }
            return list;
        }
        List<VirtualFile> sortedResult = JsTestFileByTestNameIndex.lowerJsFileTypesRelevance(ContainerUtil.newArrayList((Iterable)files));
        if (executedFile != null) {
            JsTestFileByTestNameIndex.liftExecutedFileAmongSameExtFiles(sortedResult, executedFile);
        }
        List<VirtualFile> list = sortedResult;
        if (list == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(41);
        }
        return list;
    }

    @NotNull
    public static List<VirtualFile> findFiles(@NotNull JsTestFqn testFqn, @NotNull GlobalSearchScope scope, @Nullable VirtualFile executedFile) {
        String key;
        if (testFqn == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(42);
        }
        if (scope == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(43);
        }
        if ((key = JsTestFileByTestNameIndex.createIndexKey(testFqn)) == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                JsTestFileByTestNameIndex.$$$reportNull$$$0(44);
            }
            return list;
        }
        List<VirtualFile> list = JsTestFileByTestNameIndex.findFilesByKey(key, scope, executedFile);
        if (list == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(45);
        }
        return list;
    }

    private static void liftExecutedFileAmongSameExtFiles(@NotNull List<VirtualFile> result, @NotNull VirtualFile executedFile) {
        String executedFileExtension;
        int executedFileInd;
        if (result == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(46);
        }
        if (executedFile == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(47);
        }
        if ((executedFileInd = result.indexOf(executedFile)) >= 0 && (executedFileExtension = executedFile.getExtension()) != null) {
            int sameExtInd = -1;
            for (int i = 0; i < result.size(); ++i) {
                VirtualFile file = result.get(i);
                if (!executedFileExtension.equals(file.getExtension())) continue;
                sameExtInd = i;
                break;
            }
            if (sameExtInd >= 0 && sameExtInd != executedFileInd) {
                Collections.swap(result, sameExtInd, executedFileInd);
            }
        }
    }

    @NotNull
    private static List<VirtualFile> lowerJsFileTypesRelevance(@NotNull List<VirtualFile> files) {
        if (files == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(48);
        }
        if (files.size() <= 1) {
            List<VirtualFile> list = files;
            if (list == null) {
                JsTestFileByTestNameIndex.$$$reportNull$$$0(49);
            }
            return list;
        }
        Collections.sort(files, (file1, file2) -> {
            boolean js2;
            String ext1 = StringUtil.notNullize((String)file1.getExtension()).toLowerCase(Locale.ENGLISH);
            String ext2 = StringUtil.notNullize((String)file2.getExtension()).toLowerCase(Locale.ENGLISH);
            boolean js1 = ext1.equals("js");
            if (js1 != (js2 = ext2.equals("js"))) {
                return js1 ? 1 : -1;
            }
            return file1.getPath().compareToIgnoreCase(file2.getPath());
        });
        List<VirtualFile> list = files;
        if (list == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(50);
        }
        return list;
    }

    @NotNull
    public static Collection<String> getAllKeys(@NotNull Project project) {
        if (project == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(51);
        }
        Collection collection = FileBasedIndex.getInstance().getAllKeys(INDEX_ID, project);
        if (collection == null) {
            JsTestFileByTestNameIndex.$$$reportNull$$$0(52);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 51: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 51: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 4: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structureBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteNames";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleStructure";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMethodStructure";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMethodName";
                break;
            }
            case 19: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNames";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 26: 
            case 29: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteKey";
                break;
            }
            case 27: 
            case 30: 
            case 33: 
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 35: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFqn";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executedFile";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructure";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createJasmineKey";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createQUnitKey";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createQUnitKeyForModule";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createQUnitKeyForTest";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createQUnitKeyForTestFromDefaultModule";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 28: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "findJsTestFilesByNameInScope";
                break;
            }
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesByKey";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "findFiles";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "lowerJsFileTypesRelevance";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addMochaTddNames";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStructure";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createJasmineKey";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createQUnitKey";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createQUnitKeyForModule";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createQUnitKeyForTest";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createQUnitKeyForTestFromDefaultModule";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "toFqn";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addJasmineDescendantSuites";
                break;
            }
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findJsTestFilesByNameInScope";
                break;
            }
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findFilesByKey";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createIndexKey";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findFiles";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "liftExecutedFileAmongSameExtFiles";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lowerJsFileTypesRelevance";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getAllKeys";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 51: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

