/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.build;

import com.intellij.compiler.impl.BuildTargetScopeProvider;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.make.report.CompileReportSource;
import com.intellij.gwt.packaging.GwtCompilerOutputElementType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;

public class GwtBuildTargetScopeProvider
extends BuildTargetScopeProvider {
    private static final Key<CompileReportSource> COMPILE_REPORT_SOURCE_KEY = Key.create((String)"GWT_COMPILE_REPORT_SOURCE");

    public static Set<GwtFacet> getFacetsToBuild(Project project, CompileScope compileScope) {
        Set artifacts = ArtifactCompileScope.getArtifactsToBuild((Project)project, (CompileScope)compileScope, (boolean)false);
        return GwtBuildTargetScopeProvider.getFacetsIncludedInArtifacts(artifacts, project);
    }

    @Nullable
    public static CompileReportSource getCompileReportSource(CompileScope scope) {
        return (CompileReportSource)scope.getUserData(COMPILE_REPORT_SOURCE_KEY);
    }

    public static void setGenerateCompileReportOption(@NotNull CompileScope scope, @NotNull CompileReportSource source) {
        if (scope == null) {
            GwtBuildTargetScopeProvider.$$$reportNull$$$0(0);
        }
        if (source == null) {
            GwtBuildTargetScopeProvider.$$$reportNull$$$0(1);
        }
        scope.putUserData(COMPILE_REPORT_SOURCE_KEY, (Object)source);
    }

    private static Set<GwtFacet> getFacetsIncludedInArtifacts(Collection<? extends Artifact> artifacts, Project project) {
        HashSet<GwtFacet> facets = new HashSet<GwtFacet>();
        ReadAction.run(() -> {
            for (Artifact artifact : artifacts) {
                PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)project).getResolvingContext();
                ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)GwtCompilerOutputElementType.getInstance(), element -> {
                    ContainerUtil.addIfNotNull((Collection)facets, (Object)((Object)element.getFacet()));
                    return true;
                }, (PackagingElementResolvingContext)context, (boolean)true);
            }
        });
        return facets;
    }

    @NotNull
    public List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> getBuildTargetScopes(@NotNull CompileScope baseScope, @NotNull CompilerFilter filter, @NotNull Project project, boolean forceBuild) {
        Set facets;
        if (baseScope == null) {
            GwtBuildTargetScopeProvider.$$$reportNull$$$0(2);
        }
        if (filter == null) {
            GwtBuildTargetScopeProvider.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GwtBuildTargetScopeProvider.$$$reportNull$$$0(4);
        }
        if (!(facets = (Set)ReadAction.compute(() -> {
            if (project == null) {
                GwtBuildTargetScopeProvider.$$$reportNull$$$0(7);
            }
            if (baseScope == null) {
                GwtBuildTargetScopeProvider.$$$reportNull$$$0(8);
            }
            Set<GwtFacet> gwtFacets = GwtBuildTargetScopeProvider.getFacetsToBuild(project, baseScope);
            CompileReportSource reportSource = GwtBuildTargetScopeProvider.getCompileReportSource(baseScope);
            if (reportSource != null) {
                gwtFacets.add(reportSource.getFacet());
            }
            return gwtFacets;
        })).isEmpty()) {
            ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes = new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
            CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.Builder gwtScope = CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.newBuilder().setTypeId("gwt").setForceBuild(ArtifactCompileScope.isArtifactRebuildForced((CompileScope)baseScope));
            CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.Builder modulesScope = CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.newBuilder().setTypeId(JavaModuleBuildTargetType.PRODUCTION.getTypeId()).setForceBuild(forceBuild);
            for (GwtFacet facet : facets) {
                String moduleName = facet.getModule().getName();
                gwtScope.addTargetId(moduleName);
                modulesScope.addTargetId(moduleName);
            }
            scopes.add(gwtScope.build());
            scopes.add(modulesScope.build());
            ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> arrayList = scopes;
            if (arrayList == null) {
                GwtBuildTargetScopeProvider.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list = Collections.emptyList();
        if (list == null) {
            GwtBuildTargetScopeProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/build/GwtBuildTargetScopeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/build/GwtBuildTargetScopeProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTargetScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setGenerateCompileReportOption";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBuildTargetScopes";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getBuildTargetScopes$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

