/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.i18n;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.i18n.GwtI18nManager;
import com.intellij.gwt.i18n.GwtI18nUtil;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.lang.properties.PropertiesFileProcessor;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.I18nizedTextGenerator;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.lang.properties.psi.ResourceBundleManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtResourceBundleManager
extends ResourceBundleManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.i18n.GwtResourceBundleManager");
    private final PsiManager myPsiManager;
    private final GwtI18nManager myI18nManager;
    private final GwtModulesManager myGwtModulesManager;

    public GwtResourceBundleManager(Project project, PsiManager psiManager, GwtI18nManager gwtI18nManager, GwtModulesManager gwtModulesManager) {
        super(project);
        this.myPsiManager = psiManager;
        this.myI18nManager = gwtI18nManager;
        this.myGwtModulesManager = gwtModulesManager;
    }

    @Nullable
    public PsiClass getResourceBundle() {
        return null;
    }

    @NonNls
    public String getTemplateName() {
        return null;
    }

    @NonNls
    public String getConcatenationTemplateName() {
        return null;
    }

    public boolean isActive(PsiFile context) throws ResourceBundleManager.ResourceBundleNotFoundException {
        return this.myGwtModulesManager.isUnderGwtModule(context.getVirtualFile());
    }

    public boolean canShowJavaCodeInfo() {
        return false;
    }

    public String suggestPropertyKey(@NotNull String value) {
        if (value == null) {
            GwtResourceBundleManager.$$$reportNull$$$0(0);
        }
        return GwtI18nUtil.suggestPropertyKey(value, PsiNameHelper.getInstance((Project)this.myProject), LanguageLevel.HIGHEST);
    }

    public List<String> suggestPropertiesFiles() {
        final ArrayList<String> paths = new ArrayList<String>();
        PropertiesReferenceManager.getInstance((Project)this.myProject).processAllPropertiesFiles(new PropertiesFileProcessor(){

            public boolean process(String baseName, PropertiesFile propertiesFile) {
                if (GwtResourceBundleManager.this.myI18nManager.getPropertiesInterface(propertiesFile) != null) {
                    paths.add(FileUtil.toSystemDependentName((String)propertiesFile.getVirtualFile().getPath()));
                }
                return true;
            }
        });
        return paths;
    }

    private void addMethod(PsiClass anInterface, String key, PsiExpression[] parameters) throws IncorrectOperationException {
        if (parameters.length == 0 && this.containsMethod(anInterface, key)) {
            return;
        }
        PsiFile psiFile = anInterface.getContainingFile();
        FileModificationService.getInstance().prepareFileForWrite(psiFile);
        VirtualFile virtualFile = psiFile.getVirtualFile();
        LOG.assertTrue(virtualFile != null);
        GwtFacet gwtFacet = GwtFacet.findFacetBySourceFile(this.myProject, psiFile.getVirtualFile());
        GwtVersion gwtVersion = GwtFacet.getGwtVersion(gwtFacet);
        PsiMethod method = GwtI18nUtil.addMethod(anInterface, key, gwtVersion);
        CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)method);
        if (parameters.length > 0) {
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)method);
            CreateFromUsageUtils.setupMethodParameters((PsiMethod)method, (TemplateBuilder)builder, (PsiElement)parameters[0], (PsiSubstitutor)PsiSubstitutor.EMPTY, (PsiExpression[])parameters);
            method = (PsiMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)method);
            OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, virtualFile, method.getTextRange().getStartOffset());
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
            LOG.assertTrue(document != null);
            RangeMarker methodRange = document.createRangeMarker(method.getTextRange());
            Editor editor = FileEditorManager.getInstance((Project)this.myProject).openTextEditor(descriptor, true);
            Template template = builder.buildTemplate();
            editor.getCaretModel().moveToOffset(methodRange.getStartOffset());
            editor.getDocument().deleteString(methodRange.getStartOffset(), methodRange.getEndOffset());
            ApplicationManager.getApplication().invokeLater(() -> TemplateManager.getInstance((Project)this.myProject).startTemplate(editor, template));
        }
    }

    private boolean containsMethod(PsiClass anInterface, String key) {
        PsiMethod[] methods;
        PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)this.myProject);
        String methodName = GwtI18nUtil.convertPropertyName2MethodName(key, nameHelper, PsiUtil.getLanguageLevel((PsiElement)anInterface));
        for (PsiMethod method : methods = anInterface.findMethodsByName(methodName, true)) {
            if (method.getParameterList().getParametersCount() != 0) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public PropertyCreationHandler getPropertyCreationHandler() {
        return new GwtPropertyCreationHandler();
    }

    @Nullable
    public I18nizedTextGenerator getI18nizedTextGenerator() {
        return new GwtI18nizedTextGenerator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/gwt/i18n/GwtResourceBundleManager", "suggestPropertyKey"));
    }

    private class GwtPropertyCreationHandler
    implements PropertyCreationHandler {
        private GwtPropertyCreationHandler() {
        }

        public void createProperty(Project project, Collection<PropertiesFile> propertiesFiles, String key, String value, PsiExpression[] parameters) throws IncorrectOperationException {
            JavaI18nUtil.DEFAULT_PROPERTY_CREATION_HANDLER.createProperty(project, propertiesFiles, key, value, parameters);
            Iterator<PropertiesFile> iterator = propertiesFiles.iterator();
            if (iterator.hasNext()) {
                PropertiesFile propertiesFile = iterator.next();
                PsiClass anInterface = GwtResourceBundleManager.this.myI18nManager.getPropertiesInterface(propertiesFile);
                if (anInterface != null) {
                    GwtResourceBundleManager.this.addMethod(anInterface, key, parameters);
                }
            }
        }
    }

    private class GwtI18nizedTextGenerator
    extends I18nizedTextGenerator {
        @NonNls
        private static final String GET_LOCALIZABLE_INSTANCE_TEMPLATE = "(({0}) com.google.gwt.core.client.GWT.create({0}.class))";

        private GwtI18nizedTextGenerator() {
        }

        public String getI18nizedText(String propertyKey, @Nullable PropertiesFile propertiesFile, PsiLiteralExpression context) {
            return this.getI18nizedConcatenationText(propertyKey, "", propertiesFile, context);
        }

        private String getI18nizedText(@Nullable @NonNls String qualifier, String propertyKey, PsiLiteralExpression context, String parameters) {
            if (qualifier == null) {
                qualifier = "constants";
            }
            String methodName = GwtI18nUtil.convertPropertyName2MethodName(propertyKey, PsiNameHelper.getInstance((Project)GwtResourceBundleManager.this.myPsiManager.getProject()), PsiUtil.getLanguageLevel((PsiElement)context));
            return qualifier + "." + methodName + "(" + parameters + ")";
        }

        private String getLocalizableInstance(@NotNull PsiClass anInterface, @NotNull PsiLiteralExpression context) {
            PsiClassType type;
            Set expressions;
            Iterator iterator;
            if (anInterface == null) {
                GwtI18nizedTextGenerator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                GwtI18nizedTextGenerator.$$$reportNull$$$0(1);
            }
            if ((iterator = (expressions = JavaI18nUtil.suggestExpressionOfType((PsiClassType)(type = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory().createType(anInterface)), (PsiLiteralExpression)context)).iterator()).hasNext()) {
                return (String)iterator.next();
            }
            return MessageFormat.format(GET_LOCALIZABLE_INSTANCE_TEMPLATE, anInterface.getQualifiedName());
        }

        public String getI18nizedConcatenationText(String propertyKey, String parametersString, @Nullable PropertiesFile propertiesFile, PsiLiteralExpression context) {
            PsiClass anInterface;
            String qualifier = null;
            if (propertiesFile != null && (anInterface = GwtResourceBundleManager.this.myI18nManager.getPropertiesInterface(propertiesFile)) != null) {
                qualifier = this.getLocalizableInstance(anInterface, context);
            }
            return this.getI18nizedText(qualifier, propertyKey, context, parametersString);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anInterface";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/gwt/i18n/GwtResourceBundleManager$GwtI18nizedTextGenerator";
            objectArray[2] = "getLocalizableInstance";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

