/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.gwt.uiBinder.mapping.UiBinderMappingService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtUiBinderErrorsInspection
extends BaseGwtInspection {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass uiBinderInheritor, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiReferenceList extendsList;
        if (uiBinderInheritor == null) {
            GwtUiBinderErrorsInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            GwtUiBinderErrorsInspection.$$$reportNull$$$0(1);
        }
        if (!uiBinderInheritor.isInterface() || !InheritanceUtil.isInheritor((PsiClass)uiBinderInheritor, (boolean)true, (String)"com.google.gwt.uibinder.client.UiBinder")) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)uiBinderInheritor);
        if (module == null) {
            return null;
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        XmlFile uiXmlFile = UiBinderMappingService.getInstance(module).getUiXmlFile(uiBinderInheritor);
        if (uiXmlFile == null) {
            PsiIdentifier nameIdentifier = uiBinderInheritor.getNameIdentifier();
            if (nameIdentifier != null) {
                PsiElement nameElement = nameIdentifier.getNavigationElement();
                String message = GwtBundle.message("problem.description.ui.xml.not.found", new Object[0]);
                problems.add(manager.createProblemDescriptor(nameElement, message, isOnTheFly, null, ProblemHighlightType.GENERIC_ERROR));
            }
        } else if (uiBinderInheritor.getTypeParameters().length == 0 && (extendsList = uiBinderInheritor.getExtendsList()) != null) {
            PsiTypeElement typeElement;
            PsiClass psiClass;
            PsiTypeElement[] uiBinderTypeParameterElements;
            PsiJavaCodeReferenceElement uiBinderReferenceElement = null;
            for (PsiJavaCodeReferenceElement referenceElement : extendsList.getReferenceElements()) {
                if (!"com.google.gwt.uibinder.client.UiBinder".equals(referenceElement.getQualifiedName())) continue;
                uiBinderReferenceElement = referenceElement;
                break;
            }
            if (uiBinderReferenceElement == null) {
                return null;
            }
            PsiReferenceParameterList uiBinderParameterList = uiBinderReferenceElement.getParameterList();
            if (uiBinderParameterList != null && (uiBinderTypeParameterElements = uiBinderParameterList.getTypeParameterElements()).length == 2 && (psiClass = PsiTypesUtil.getPsiClass((PsiType)(typeElement = uiBinderTypeParameterElements[0]).getType())) != null) {
                XmlTag uiXmlRootTag = uiXmlFile.getRootTag();
                if (uiXmlRootTag == null) {
                    String message = GwtBundle.message("problem.description.ui.xml.root.not.found", new Object[0]);
                    problems.add(manager.createProblemDescriptor((PsiElement)typeElement, message, isOnTheFly, null, ProblemHighlightType.GENERIC_ERROR));
                } else {
                    String message;
                    XmlTag[] uiXmlFileRootSubtags = uiXmlRootTag.getSubTags();
                    SmartList widgetTags = new SmartList();
                    for (XmlTag uiXmlFileRootSubtag : uiXmlFileRootSubtags) {
                        if ("urn:ui:com.google.gwt.uibinder".equals(uiXmlFileRootSubtag.getNamespace())) continue;
                        widgetTags.add(uiXmlFileRootSubtag);
                    }
                    if (widgetTags.isEmpty()) {
                        message = GwtBundle.message("problem.description.ui.xml.root.not.found", new Object[0]);
                        problems.add(manager.createProblemDescriptor((PsiElement)typeElement, message, isOnTheFly, null, ProblemHighlightType.GENERIC_ERROR));
                    } else if (widgetTags.size() == 1) {
                        GlobalSearchScope scope;
                        XmlTag widgetTag = (XmlTag)ContainerUtil.getFirstItem((List)widgetTags);
                        String componentClassName = UiBinderUtil.getComponentClassName(widgetTag);
                        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)uiBinderInheritor.getProject());
                        PsiClass resolvedComponentClass = psiFacade.findClass(componentClassName, scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
                        if (resolvedComponentClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)resolvedComponentClass, (PsiClass)psiClass, (boolean)true)) {
                            String message2 = GwtBundle.message("problem.description.inconsistent.element.type", widgetTag.getName(), resolvedComponentClass.getQualifiedName());
                            problems.add(manager.createProblemDescriptor((PsiElement)typeElement, message2, isOnTheFly, null, ProblemHighlightType.GENERIC_ERROR));
                        }
                    } else {
                        message = GwtBundle.message("problem.description.ui.xml.root.ambiguity", new Object[0]);
                        problems.add(manager.createProblemDescriptor((PsiElement)typeElement, message, isOnTheFly, null, ProblemHighlightType.GENERIC_ERROR));
                    }
                }
            }
        }
        return problems.isEmpty() ? ProblemDescriptor.EMPTY_ARRAY : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("GWT UiBinder Errors" == null) {
            GwtUiBinderErrorsInspection.$$$reportNull$$$0(2);
        }
        return "GWT UiBinder Errors";
    }

    @NotNull
    public String getShortName() {
        if ("GwtUiBinderErrors" == null) {
            GwtUiBinderErrorsInspection.$$$reportNull$$$0(3);
        }
        return "GwtUiBinderErrors";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiBinderInheritor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/inspections/GwtUiBinderErrorsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/inspections/GwtUiBinderErrorsInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

