/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections.eventListeners;

import com.intellij.gwt.inspections.eventListeners.DeprecatedEventListenersRegistry;
import com.intellij.gwt.inspections.eventListeners.DeprecatedListener;
import com.intellij.gwt.inspections.eventListeners.ListenerUsageInfo;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiVariable;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeprecatedListenerUsages {
    private List<ListenerUsageInfo> myUsages = new ArrayList<ListenerUsageInfo>();
    private Map<PsiVariable, ListenerUsageInfo> myVariable2Usage = new THashMap();
    private DeprecatedEventListenersRegistry myRegistry;
    private Set<PsiMethod> myMethodsWhichParametersAreUsed = new THashSet();

    public DeprecatedListenerUsages() {
        this.myRegistry = DeprecatedEventListenersRegistry.getInstance();
    }

    public Set<PsiMethod> getMethodsWhichParametersAreUsed() {
        return this.myMethodsWhichParametersAreUsed;
    }

    @Nullable
    public ListenerUsageInfo findOrRegisterDeclaration(@NotNull PsiVariable variable) {
        PsiModifierList modifierList;
        if (variable == null) {
            DeprecatedListenerUsages.$$$reportNull$$$0(0);
        }
        if (variable instanceof PsiField ? (modifierList = variable.getModifierList()) == null || !modifierList.hasModifierProperty("private") : !(variable instanceof PsiLocalVariable)) {
            return null;
        }
        ListenerUsageInfo usage = this.myVariable2Usage.get(variable);
        if (usage == null) {
            DeprecatedListener info = this.getListenerInfo(variable);
            if (info == null) {
                return null;
            }
            usage = new ListenerUsageInfo(info, variable.getTypeElement());
            this.myUsages.add(usage);
            this.myVariable2Usage.put(variable, usage);
        }
        return usage;
    }

    @Nullable
    private DeprecatedListener getListenerInfo(PsiVariable variable) {
        DeprecatedListener info;
        PsiClassType type = (PsiClassType)variable.getType();
        PsiClass psiClass = type.resolve();
        if (psiClass == null) {
            return null;
        }
        String qualifiedName = psiClass.getQualifiedName();
        DeprecatedListener listener = this.myRegistry.findByListenerClass(qualifiedName);
        if (listener != null) {
            return listener;
        }
        PsiClass containingClass = psiClass.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList == null || !modifierList.hasModifierProperty("private")) {
            return null;
        }
        PsiClass superClass = psiClass.getSuperClass();
        if (superClass != null && (info = this.myRegistry.findByListenerClass(superClass.getQualifiedName())) != null) {
            return info;
        }
        for (PsiClass anInterface : psiClass.getInterfaces()) {
            DeprecatedListener info2 = this.myRegistry.findByListenerClass(anInterface.getQualifiedName());
            if (info2 == null) continue;
            return info2;
        }
        return null;
    }

    public void registerAssignment(PsiVariable variable, @Nullable PsiExpression variableReference, PsiExpression value) {
        boolean processed;
        ListenerUsageInfo usageInfo = this.findOrRegisterDeclaration(variable);
        if (usageInfo != null && (processed = this.processNewListenerExpression(usageInfo.getListener(), value, usageInfo)) && variableReference != null) {
            usageInfo.registerProcessedReference(variableReference);
        }
    }

    public void registerReference(PsiVariable variable, PsiJavaCodeReferenceElement reference) {
        ListenerUsageInfo usageInfo = this.findOrRegisterDeclaration(variable);
        if (usageInfo != null) {
            usageInfo.registerReference(reference);
        }
    }

    public void registerAddOrRemoveListenerCall(@NotNull DeprecatedListener listener, @NotNull PsiMethodCallExpression expression, boolean add) {
        ListenerUsageInfo usage;
        PsiExpression[] expressions;
        if (listener == null) {
            DeprecatedListenerUsages.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            DeprecatedListenerUsages.$$$reportNull$$$0(2);
        }
        if ((expressions = expression.getArgumentList().getExpressions()).length != 1) {
            return;
        }
        PsiExpression argument = expressions[0];
        ListenerUsageInfo usageInfo = this.getInfoByReference(argument);
        if (usageInfo != null && usageInfo.getListener().equals(listener)) {
            usageInfo.registerProcessedReference(argument);
            usageInfo.setListenerAddedOrRemoved(add, expression);
        } else if (add && this.processNewListenerExpression(listener, argument, usage = new ListenerUsageInfo(listener, null))) {
            usage.setListenerAddedOrRemoved(true, expression);
            this.myUsages.add(usage);
        }
    }

    public void registerNewExpressionWithListenerAsParameter(DeprecatedListener listener, PsiExpression argument) {
        ListenerUsageInfo usageInfo = this.getInfoByReference(argument);
        if (usageInfo != null && usageInfo.getListener().equals(listener)) {
            usageInfo.registerProcessedReference(argument);
        } else {
            ListenerUsageInfo usage = new ListenerUsageInfo(listener, null);
            if (this.processNewListenerExpression(listener, argument, usage)) {
                this.myUsages.add(usage);
            }
        }
    }

    private boolean processNewListenerExpression(DeprecatedListener listener, PsiExpression expression, ListenerUsageInfo usage) {
        if (expression instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression;
            PsiExpressionList argumentsList = newExpression.getArgumentList();
            if (argumentsList == null) {
                return false;
            }
            PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
            if (anonymousClass != null) {
                PsiClass psiClass;
                if (argumentsList.getExpressions().length == 0 && (psiClass = anonymousClass.getBaseClassType().resolve()) != null && listener.equals(this.myRegistry.findByListenerClass(psiClass.getQualifiedName()))) {
                    usage.setCreatedAsAnonymous(newExpression, anonymousClass);
                    return true;
                }
            } else {
                PsiElement resolved;
                PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
                if (classReference != null && (resolved = classReference.resolve()) instanceof PsiClass) {
                    PsiClass psiClass = (PsiClass)resolved;
                    PsiReferenceList implementsList = psiClass.getImplementsList();
                    PsiReferenceList extendsList = psiClass.getExtendsList();
                    PsiModifierList modifierList = psiClass.getModifierList();
                    if (modifierList != null && modifierList.hasModifierProperty("private")) {
                        return this.processReferenceToImplementedListener(listener, usage, psiClass, extendsList, true) || this.processReferenceToImplementedListener(listener, usage, psiClass, implementsList, false);
                    }
                }
            }
        }
        return false;
    }

    private boolean processReferenceToImplementedListener(DeprecatedListener listener, ListenerUsageInfo usage, PsiClass psiClass, PsiReferenceList referenceList, boolean inExtendsList) {
        if (referenceList != null) {
            for (PsiJavaCodeReferenceElement interfaceReference : referenceList.getReferenceElements()) {
                DeprecatedListener info = this.myRegistry.findByListenerClass(interfaceReference.getQualifiedName());
                if (!listener.equals(info)) continue;
                usage.setCreatedAsInner(interfaceReference, psiClass, inExtendsList);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private ListenerUsageInfo getInfoByReference(PsiExpression argument) {
        PsiElement element;
        if (argument instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)argument).resolve()) instanceof PsiVariable) {
            return this.findOrRegisterDeclaration((PsiVariable)element);
        }
        return null;
    }

    public ListenerUsageInfo[] getUsages() {
        return this.myUsages.toArray(new ListenerUsageInfo[this.myUsages.size()]);
    }

    public void registerParameterReference(@NotNull PsiMethod method) {
        if (method == null) {
            DeprecatedListenerUsages.$$$reportNull$$$0(3);
        }
        this.myMethodsWhichParametersAreUsed.add(method);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/gwt/inspections/eventListeners/DeprecatedListenerUsages";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findOrRegisterDeclaration";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerAddOrRemoveListenerCall";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerParameterReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

