/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PrefixBasedPropertyReference;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlTagBase;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class PropertiesReferenceProvider
extends PsiReferenceProvider {
    private final boolean myDefaultSoft;

    public PropertiesReferenceProvider() {
        this(false);
    }

    public PropertiesReferenceProvider(boolean defaultSoft) {
        this.myDefaultSoft = defaultSoft;
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        if (target == null) {
            PropertiesReferenceProvider.$$$reportNull$$$0(0);
        }
        return target instanceof IProperty;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            PropertiesReferenceProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PropertiesReferenceProvider.$$$reportNull$$$0(2);
        }
        Object value = null;
        String bundleName = null;
        boolean propertyRefWithPrefix = false;
        boolean soft = this.myDefaultSoft;
        if (element instanceof PsiLiteralExpression && !(element.getParent() instanceof PsiExpression)) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            value = literalExpression.getValue();
            HashMap<String, Object> annotationParams = new HashMap<String, Object>();
            annotationParams.put("resourceBundle", null);
            if (JavaI18nUtil.mustBePropertyKey((PsiExpression)literalExpression, annotationParams)) {
                soft = false;
                Object resourceBundleName = annotationParams.get("resourceBundle");
                if (resourceBundleName instanceof PsiExpression) {
                    PsiExpression expr = (PsiExpression)resourceBundleName;
                    Object bundleValue = JavaPsiFacade.getInstance((Project)expr.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)expr);
                    bundleName = bundleValue == null ? null : bundleValue.toString();
                }
            }
        } else if (element instanceof XmlAttributeValue && PropertiesReferenceProvider.isNonDynamicAttribute(element)) {
            XmlTag parent;
            if (element.getTextLength() < 2) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    PropertiesReferenceProvider.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            value = ((XmlAttributeValue)element).getValue();
            XmlAttribute attribute = (XmlAttribute)element.getParent();
            if ("key".equals(attribute.getName()) && "message".equals((parent = attribute.getParent()).getLocalName()) && Arrays.binarySearch(XmlUtil.JSTL_FORMAT_URIS, parent.getNamespace()) >= 0) {
                propertyRefWithPrefix = true;
            }
        }
        if (value instanceof String) {
            String text = (String)value;
            PrefixBasedPropertyReference reference = propertyRefWithPrefix ? new PrefixBasedPropertyReference(text, element, null, soft) : new PropertyReference(text, element, bundleName, soft);
            PsiReference[] psiReferenceArray = new PsiReference[]{reference};
            if (psiReferenceArray == null) {
                PropertiesReferenceProvider.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            PropertiesReferenceProvider.$$$reportNull$$$0(5);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    static boolean isNonDynamicAttribute(PsiElement element) {
        return PsiTreeUtil.getChildOfAnyType((PsiElement)element, (Class[])new Class[]{OuterLanguageElement.class, JspXmlTagBase.class}) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/PropertiesReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/PropertiesReferenceProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsTarget";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

