/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleIndex;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

public class JavaModuleIndexImpl
extends JavaModuleIndex {
    public static final String SOURCE_SUFFIX = ":S";
    public static final String TEST_SUFFIX = ":T";
    private static final String INDEX_PATH = "jigsaw/module-info.map";
    private static final String NULL_PATH = "-";
    private static final String MODULE_INFO_FILE = "module-info.java";
    private final Map<String, File> myMapping;
    private final JpsCompilerExcludes myExcludes;

    private JavaModuleIndexImpl(JpsCompilerExcludes excludes) {
        this.myMapping = ContainerUtil.newHashMap();
        this.myExcludes = excludes;
    }

    private JavaModuleIndexImpl(Map<String, File> mapping) {
        this.myMapping = Collections.unmodifiableMap(mapping);
        this.myExcludes = null;
    }

    @Nullable
    public File getModuleInfoFile(@NotNull JpsModule module, boolean forTests) {
        if (module == null) {
            JavaModuleIndexImpl.$$$reportNull$$$0(0);
        }
        String key = module.getName() + (forTests ? TEST_SUFFIX : SOURCE_SUFFIX);
        if (this.myExcludes == null || this.myMapping.containsKey(key)) {
            return this.myMapping.get(key);
        }
        File file = this.findModuleInfoFile(module, forTests ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE);
        this.myMapping.put(key, file);
        return file;
    }

    private File findModuleInfoFile(JpsModule module, JavaSourceRootType rootType) {
        for (JpsModuleSourceRoot root : module.getSourceRoots()) {
            File file;
            if (!rootType.equals(root.getRootType()) || !(file = new File(JpsPathUtil.urlToOsPath((String)root.getUrl()), MODULE_INFO_FILE)).isFile() || this.myExcludes.isExcluded(file)) continue;
            return file;
        }
        return null;
    }

    public static void store(@NotNull File storageRoot, @NotNull Map<String, String> mapping) throws IOException {
        if (storageRoot == null) {
            JavaModuleIndexImpl.$$$reportNull$$$0(1);
        }
        if (mapping == null) {
            JavaModuleIndexImpl.$$$reportNull$$$0(2);
        }
        Properties p = new Properties();
        Iterator<String> iterator = mapping.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String path = mapping.get(key = iterator.next());
            p.setProperty(key, path != null ? FileUtil.toSystemDependentName((String)path) : NULL_PATH);
        }
        File index = new File(storageRoot, INDEX_PATH);
        FileUtil.createParentDirs((File)index);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(index), CharsetToolkit.UTF8_CHARSET);){
            p.store(writer, null);
        }
    }

    public static JavaModuleIndex load(@NotNull File storageRoot, @NotNull JpsCompilerExcludes excludes) {
        Object object;
        File index;
        if (storageRoot == null) {
            JavaModuleIndexImpl.$$$reportNull$$$0(3);
        }
        if (excludes == null) {
            JavaModuleIndexImpl.$$$reportNull$$$0(4);
        }
        if (!(index = new File(storageRoot, INDEX_PATH)).exists()) {
            return new JavaModuleIndexImpl(excludes);
        }
        Properties p = new Properties();
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(index), CharsetToolkit.UTF8_CHARSET);
            object = null;
            try {
                p.load(reader);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((Reader)reader).close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read module index file: " + index, e);
        }
        HashMap mapping = ContainerUtil.newHashMap();
        object = p.stringPropertyNames().iterator();
        while (object.hasNext()) {
            String key;
            String path = p.getProperty(key = (String)object.next());
            mapping.put(key, NULL_PATH.equals(path) ? null : new File(path));
        }
        return new JavaModuleIndexImpl(mapping);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/model/java/impl/JavaModuleIndexImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleInfoFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "store";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "load";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

