/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.junit.TestClassFilter;
import com.intellij.execution.junit.TestPackage;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.SearchForTestsTask;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class TestsPattern
extends TestPackage {
    public TestsPattern(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(configuration, environment);
    }

    @Override
    protected TestClassFilter getClassFilter(JUnitConfiguration.Data data) throws CantRunException {
        return TestClassFilter.create(this.getSourceScope(), ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule(), data.getPatternPresentation());
    }

    @Override
    protected String getPackageName(JUnitConfiguration.Data data) throws CantRunException {
        return "";
    }

    @Override
    public SearchForTestsTask createSearchingForTestsTask() {
        final JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        Project project = this.getConfiguration().getProject();
        final LinkedHashSet<String> classNames = new LinkedHashSet<String>();
        for (String className : data.getPatterns()) {
            PsiClass psiClass = this.getTestClass(project, className);
            if (psiClass == null || !JUnitUtil.isTestClass((PsiClass)psiClass)) continue;
            classNames.add(className);
        }
        if (classNames.size() == data.getPatterns().size()) {
            return new SearchForTestsTask(project, this.myServerSocket){

                protected void search() throws ExecutionException {
                }

                protected void onFound() throws ExecutionException {
                    Function nameFunction = StringUtil.isEmpty((String)data.METHOD_NAME) ? FunctionUtil.id() : className -> className;
                    TestsPattern.this.addClassesListToJavaParameters(classNames, nameFunction, "", false, TestsPattern.this.getJavaParameters());
                }
            };
        }
        return super.createSearchingForTestsTask();
    }

    @Override
    protected boolean acceptClassName(String className) {
        String pattern = this.getConfiguration().getPersistentData().getPatternPresentation();
        return TestClassFilter.getClassNamePredicate(pattern).test(className);
    }

    private PsiClass getTestClass(Project project, String className) {
        SourceScope sourceScope = this.getSourceScope();
        GlobalSearchScope searchScope = sourceScope != null ? sourceScope.getGlobalSearchScope() : GlobalSearchScope.allScope((Project)project);
        return JavaExecutionUtil.findMainClass((Project)project, (String)(className.contains(",") ? StringUtil.getPackageName((String)className, (char)',') : className), (GlobalSearchScope)searchScope);
    }

    @Override
    protected boolean configureByModule(Module module) {
        return module != null;
    }

    @Override
    public String suggestActionName() {
        return null;
    }

    @Override
    @Nullable
    public RefactoringElementListener getListener(PsiElement element, JUnitConfiguration configuration) {
        RefactoringElementListenerComposite composite = new RefactoringElementListenerComposite();
        JUnitConfiguration.Data data = configuration.getPersistentData();
        final Set<String> patterns = data.getPatterns();
        for (String pattern : patterns) {
            RefactoringElementListener listeners;
            final PsiClass testClass = this.getTestClass(configuration.getProject(), pattern.trim());
            if (testClass == null || !testClass.equals(element) || (listeners = RefactoringListeners.getListeners((PsiClass)testClass, (RefactoringListeners.Accessor)new RefactoringListeners.Accessor<PsiClass>(){
                private String myOldName;
                {
                    this.myOldName = testClass.getQualifiedName();
                }

                public void setName(String qualifiedName) {
                    LinkedHashSet<String> replaced = new LinkedHashSet<String>();
                    for (String currentPattern : patterns) {
                        if (this.myOldName.equals(currentPattern)) {
                            replaced.add(qualifiedName);
                            this.myOldName = qualifiedName;
                            continue;
                        }
                        replaced.add(currentPattern);
                    }
                    patterns.clear();
                    patterns.addAll(replaced);
                }

                public PsiClass getPsiElement() {
                    return testClass;
                }

                public void setPsiElement(PsiClass psiElement) {
                    if (psiElement == testClass) {
                        this.setName(psiElement.getQualifiedName());
                    }
                }
            })) == null) continue;
            composite.addListener(listeners);
        }
        return composite;
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
        return false;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        Set<String> patterns = data.getPatterns();
        if (patterns.isEmpty()) {
            throw new RuntimeConfigurationWarning("No pattern selected");
        }
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)this.getConfiguration().getProject());
        for (String pattern : patterns) {
            String className;
            String string = className = pattern.contains(",") ? StringUtil.getPackageName((String)pattern, (char)',') : pattern;
            PsiClass psiClass = JavaExecutionUtil.findMainClass((Project)this.getConfiguration().getProject(), (String)className, (GlobalSearchScope)searchScope);
            if (psiClass == null || JUnitUtil.isTestClass((PsiClass)psiClass)) continue;
            throw new RuntimeConfigurationWarning("Class " + className + " not a test");
        }
    }
}

