/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.frameworks.LibrariesDownloadAssistant;
import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.libraries.FacetLibrariesValidator;
import com.intellij.facet.ui.libraries.FacetLibrariesValidatorDescription;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.seam.resources.SeamBundle;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeamFeaturesEditor
extends FacetEditorTab {
    private JComboBox myVersionComboBox;
    private JPanel myMainPanel;
    private final FacetLibrariesValidator myValidator;

    public SeamFeaturesEditor(FacetEditorContext editorContext, FacetLibrariesValidator validator) {
        this.myValidator = validator;
        this.$$$setupUI$$$();
        this.myVersionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Artifact version = SeamFeaturesEditor.this.getSelectedVersion();
                if (version != null) {
                    SeamFeaturesEditor.this.myValidator.setDescription(new FacetLibrariesValidatorDescription("seam-" + version.getVersion()));
                    SeamFeaturesEditor.this.myValidator.setRequiredLibraries(SeamFeaturesEditor.this.getRequiredLibraries());
                }
            }
        });
        Module module = editorContext.getModule();
        String version = JarVersionDetectionUtil.detectJarVersion((String)"org.jboss.seam.annotations.Name", (Module)module);
        if (version != null) {
            this.myVersionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{version}));
            this.myVersionComboBox.getModel().setSelectedItem(version);
            this.myVersionComboBox.setEnabled(false);
            return;
        }
        Artifact[] versions = LibrariesDownloadAssistant.getVersions((String)"seam", (URL[])new URL[]{SeamFeaturesEditor.class.getResource("/resources/libraries/seam.xml")});
        this.myVersionComboBox.setModel(new DefaultComboBoxModel<Artifact>(versions));
        if (versions.length > 0) {
            this.myVersionComboBox.getModel().setSelectedItem(versions[versions.length - 1]);
        }
    }

    @Nullable
    private Artifact getSelectedVersion() {
        Object version = this.myVersionComboBox.getModel().getSelectedItem();
        return version instanceof Artifact ? (Artifact)version : null;
    }

    @Nullable
    private LibraryInfo[] getRequiredLibraries() {
        Artifact version = this.getSelectedVersion();
        return version == null ? null : LibrariesDownloadAssistant.getLibraryInfos((Artifact)version);
    }

    public void onFacetInitialized(@NotNull Facet facet) {
        if (facet == null) {
            SeamFeaturesEditor.$$$reportNull$$$0(0);
        }
        this.myValidator.onFacetInitialized(facet);
    }

    @Nls
    public String getDisplayName() {
        return SeamBundle.message("facet.editor.name", new Object[0]);
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            SeamFeaturesEditor.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    public boolean isModified() {
        return this.myValidator.isLibrariesAdded();
    }

    public void apply() {
    }

    public void reset() {
    }

    public void disposeUIResources() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/seam/facet/SeamFeaturesEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/seam/facet/SeamFeaturesEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onFacetInitialized";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("resources/messages/SeamBundle").getString("facet.editor.combobox.version.name"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVersionComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

