/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.highlighting.jam;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.seam.highlighting.jam.SeamJamModelInspectionBase;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.SeamJamFactory;
import com.intellij.seam.model.jam.SeamJamUnwrap;
import com.intellij.seam.model.jam.bijection.SeamJamInjection;
import com.intellij.seam.model.jam.bijection.SeamJamOutjection;
import com.intellij.seam.model.jam.dataModel.SeamJamDataModel;
import com.intellij.seam.model.jam.dataModel.SeamJamDataModelSelection;
import com.intellij.seam.model.jam.dataModel.SeamJamDataModelSelectionIndex;
import com.intellij.seam.model.jam.lifecycle.SeamJamCreate;
import com.intellij.seam.model.jam.lifecycle.SeamJamDestroy;
import com.intellij.seam.resources.SeamInspectionBundle;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeamAnnotationIncorrectSignatureInspection
extends SeamJamModelInspectionBase {
    @NonNls
    private static final String ORG_JBOSS_SEAM_COMPONENT_CLASS = "org.jboss.seam.Component";

    @Override
    protected void checkSeamJamComponent(SeamJamComponent seamJamComponent, ProblemsHolder holder) {
        SeamAnnotationIncorrectSignatureInspection.checkClassModifiers(holder, seamJamComponent);
        SeamAnnotationIncorrectSignatureInspection.checkChildrenSignatures(holder, seamJamComponent);
    }

    private static void checkChildrenSignatures(ProblemsHolder holder, SeamJamComponent seamJamComponent) {
        SeamAnnotationIncorrectSignatureInspection.checkInjectionSignature(seamJamComponent.getInjections(), holder);
        SeamAnnotationIncorrectSignatureInspection.checkOutjectionSignature(seamJamComponent.getOutjections(), holder);
        SeamAnnotationIncorrectSignatureInspection.checkDataModelSignature(seamJamComponent.getDataModels(), holder);
        SeamAnnotationIncorrectSignatureInspection.checkDataModelSelectionSignature(seamJamComponent.getDataModelSelections(), holder);
        SeamAnnotationIncorrectSignatureInspection.checkDataModelSelectionIndexSignature(seamJamComponent.getDataModelSelectionIndexes(), holder);
        SeamAnnotationIncorrectSignatureInspection.checkFactorySignature(seamJamComponent.getFactories(), holder);
        SeamAnnotationIncorrectSignatureInspection.checkUnwrapSignature(seamJamComponent.getUnwraps(), holder);
        SeamAnnotationIncorrectSignatureInspection.checkCreateSignature(seamJamComponent.getCreates(), holder);
        SeamAnnotationIncorrectSignatureInspection.checkDestroySignature(seamJamComponent.getDestroys(), holder);
    }

    private static void checkClassModifiers(ProblemsHolder holder, SeamJamComponent jamComponent) {
        PsiClass psiClass = jamComponent.getPsiElement();
        if (psiClass != null) {
            if (psiClass.isInterface()) {
                holder.registerProblem((PsiElement)jamComponent.getIdentifyingAnnotation(), SeamInspectionBundle.message("jam.component.name.annotation.on.interface", new Object[0]), new LocalQuickFix[0]);
            } else {
                if (SeamAnnotationIncorrectSignatureInspection.isAbstract(psiClass)) {
                    holder.registerProblem((PsiElement)jamComponent.getIdentifyingAnnotation(), SeamInspectionBundle.message("jam.component.name.annotation.on.abstract.class", new Object[0]), new LocalQuickFix[0]);
                }
                if (!SeamAnnotationIncorrectSignatureInspection.hasEmptyConstructor(psiClass)) {
                    holder.registerProblem((PsiElement)jamComponent.getIdentifyingAnnotation(), SeamInspectionBundle.message("jam.component.name.annotation.no.emptyt.constructor", new Object[0]), new LocalQuickFix[0]);
                }
            }
        }
    }

    private static void checkInjectionSignature(List<SeamJamInjection> injections, ProblemsHolder holder) {
        for (SeamJamInjection injection : injections) {
            Object member = injection.getPsiElement();
            if (!(member instanceof PsiMethod)) continue;
            SeamAnnotationIncorrectSignatureInspection.checkSetterMethodSignature(holder, injection.getIdentifyingAnnotation(), (PsiMethod)member);
        }
    }

    private static void checkOutjectionSignature(List<SeamJamOutjection> outjections, ProblemsHolder holder) {
        for (SeamJamOutjection outjection : outjections) {
            Object element = outjection.getPsiElement();
            if (!(element instanceof PsiMethod)) continue;
            SeamAnnotationIncorrectSignatureInspection.checkGetterMethodSignature(holder, outjection.getIdentifyingAnnotation(), (PsiMethod)element);
        }
    }

    private static void checkDataModelSignature(List<? extends SeamJamDataModel> dataModels, ProblemsHolder holder) {
        for (SeamJamDataModel seamJamDataModel : dataModels) {
            SeamAnnotationIncorrectSignatureInspection.checkDataModelType(holder, seamJamDataModel);
            if (!(seamJamDataModel instanceof SeamJamDataModel.Method)) continue;
            SeamJamDataModel.Method model = (SeamJamDataModel.Method)seamJamDataModel;
            SeamAnnotationIncorrectSignatureInspection.checkGetterMethodSignature(holder, model.getIdentifyingAnnotation(), (PsiMethod)model.getPsiElement());
        }
    }

    private static void checkDataModelSelectionSignature(List<? extends SeamJamDataModelSelection> dataModelSelections, ProblemsHolder holder) {
        for (SeamJamDataModelSelection seamJamDataModelSelection : dataModelSelections) {
            if (!(seamJamDataModelSelection instanceof SeamJamDataModelSelection.Method)) continue;
            SeamJamDataModelSelection.Method model = (SeamJamDataModelSelection.Method)seamJamDataModelSelection;
            SeamAnnotationIncorrectSignatureInspection.checkSetterMethodSignature(holder, model.getIdentifyingAnnotation(), (PsiMethod)model.getPsiElement());
        }
    }

    private static void checkDataModelSelectionIndexSignature(List<? extends SeamJamDataModelSelectionIndex> dataModelSelectionIndexes, ProblemsHolder holder) {
        for (SeamJamDataModelSelectionIndex seamJamDataModelSelectionIndex : dataModelSelectionIndexes) {
            if (!(seamJamDataModelSelectionIndex instanceof SeamJamDataModelSelectionIndex.Method)) continue;
            SeamJamDataModelSelectionIndex.Method model = (SeamJamDataModelSelectionIndex.Method)seamJamDataModelSelectionIndex;
            SeamAnnotationIncorrectSignatureInspection.checkSetterMethodSignature(holder, model.getIdentifyingAnnotation(), (PsiMethod)model.getPsiElement());
        }
    }

    private static void checkDataModelType(ProblemsHolder holder, SeamJamDataModel dataModel) {
        String[] dataModelTypes = new String[]{"java.util.List", "java.util.Set", "java.util.Map"};
        PsiType type = dataModel.getType();
        if (type == null) {
            return;
        }
        if (type instanceof PsiArrayType) {
            return;
        }
        if (!SeamAnnotationIncorrectSignatureInspection.isAssignableFromAny(dataModel.getPsiManager().getProject(), type, dataModelTypes)) {
            holder.registerProblem((PsiElement)dataModel.getIdentifyingAnnotation(), SeamInspectionBundle.message("jam.component.data.model.incorrect.type", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkHasNoParameters(ProblemsHolder holder, PsiAnnotation annotation, PsiMethod psiMethod) {
        PsiParameterList parameterList = psiMethod.getParameterList();
        int parameterCount = parameterList.getParametersCount();
        if (parameterCount > 0) {
            holder.registerProblem((PsiElement)annotation, SeamInspectionBundle.message("method.must.have.no.parameters", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkUnwrapSignature(List<? extends SeamJamUnwrap> unwraps, ProblemsHolder holder) {
        for (SeamJamUnwrap seamJamUnwrap : unwraps) {
            PsiMethod psiMethod = seamJamUnwrap.getPsiElement();
            SeamAnnotationIncorrectSignatureInspection.checkMethodIsNotStatic((PsiElement)seamJamUnwrap.getIdentifyingAnnotation(), holder, psiMethod);
            SeamAnnotationIncorrectSignatureInspection.checkMethodHasReturnType(seamJamUnwrap.getIdentifyingAnnotation(), holder, psiMethod);
            SeamAnnotationIncorrectSignatureInspection.checkHasNoParametersOrSingleComponentParam(holder, seamJamUnwrap.getIdentifyingAnnotation(), psiMethod);
        }
    }

    private static void checkFactorySignature(Collection<SeamJamFactory> factories, ProblemsHolder holder) {
        for (SeamJamFactory factoryComponent : factories) {
            PsiMethod psiMethod = factoryComponent.getPsiElement();
            assert (psiMethod != null);
            SeamAnnotationIncorrectSignatureInspection.checkMethodIsPublic((PsiElement)factoryComponent.getIdentifyingAnnotation(), holder, psiMethod);
            SeamAnnotationIncorrectSignatureInspection.checkHasNoParametersOrSingleComponentParam(holder, factoryComponent.getIdentifyingAnnotation(), psiMethod);
            if (SeamAnnotationIncorrectSignatureInspection.hasFactoryExplicitVariableName(factoryComponent, holder) || SeamAnnotationIncorrectSignatureInspection.isJavaStyleName(psiMethod)) continue;
            holder.registerProblem((PsiElement)factoryComponent.getIdentifyingAnnotation(), SeamInspectionBundle.message("method.factory.signature.and.explicit.variable.declaration", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static boolean isJavaStyleName(PsiMethod method) {
        if (method == null) {
            return false;
        }
        String[] prefixes = new String[]{"get", "is"};
        String methodName = method.getName();
        for (String prefix : prefixes) {
            if (!methodName.startsWith(prefix) || methodName.length() <= prefix.length() || !Character.isUpperCase(methodName.charAt(prefix.length()))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasFactoryExplicitVariableName(SeamJamFactory factoryComponent, ProblemsHolder holder) {
        return SeamAnnotationIncorrectSignatureInspection.getFactoryExplicitVariableName(factoryComponent) != null;
    }

    @Nullable
    private static String getFactoryExplicitVariableName(SeamJamFactory factoryComponent) {
        PsiAnnotation annotation = factoryComponent.getIdentifyingAnnotation();
        if (annotation != null) {
            return (String)JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)annotation.findDeclaredAttributeValue("value"), String.class);
        }
        return null;
    }

    private static void checkDestroySignature(List<? extends SeamJamDestroy> destroys, ProblemsHolder holder) {
        for (SeamJamDestroy seamJamDestroy : destroys) {
            PsiMethod psiMethod = seamJamDestroy.getPsiElement();
            SeamAnnotationIncorrectSignatureInspection.checkMethodIsNotStatic((PsiElement)seamJamDestroy.getIdentifyingAnnotation(), holder, psiMethod);
            SeamAnnotationIncorrectSignatureInspection.checkHasNoParameters(holder, seamJamDestroy.getIdentifyingAnnotation(), psiMethod);
            SeamAnnotationIncorrectSignatureInspection.checkMethodHasVoidReturnType(seamJamDestroy.getIdentifyingAnnotation(), holder, psiMethod);
        }
    }

    private static void checkCreateSignature(List<SeamJamCreate> creates, ProblemsHolder holder) {
        for (SeamJamCreate seamJamCreate : creates) {
            PsiMethod psiMethod = seamJamCreate.getPsiElement();
            PsiAnnotation annotation = seamJamCreate.getIdentifyingAnnotation();
            SeamAnnotationIncorrectSignatureInspection.checkMethodIsNotStatic((PsiElement)annotation, holder, psiMethod);
            SeamAnnotationIncorrectSignatureInspection.checkHasNoParametersOrSingleComponentParam(holder, annotation, psiMethod);
        }
    }

    private static boolean isAssignableFromAny(Project project, PsiType type, String ... clazzNames) {
        for (String clazzName : clazzNames) {
            if (!SeamAnnotationIncorrectSignatureInspection.isAssignableFrom(project, clazzName, type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignableFrom(Project project, String clazzName, PsiType type) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass clazz = psiFacade.findClass(clazzName, GlobalSearchScope.allScope((Project)project));
        if (clazz == null) {
            return false;
        }
        PsiClassType classType = psiFacade.getElementFactory().createType(clazz);
        return classType.isAssignableFrom(type);
    }

    private static void checkHasNoParametersOrSingleComponentParam(ProblemsHolder holder, PsiAnnotation psiAnnotation, PsiMethod psiMethod) {
        PsiParameterList parameterList = psiMethod.getParameterList();
        int parameterCount = parameterList.getParametersCount();
        if (!(parameterCount == 0 || parameterCount == 1 && SeamAnnotationIncorrectSignatureInspection.isAssignableFrom(psiMethod.getProject(), ORG_JBOSS_SEAM_COMPONENT_CLASS, parameterList.getParameters()[0].getType()))) {
            holder.registerProblem((PsiElement)psiAnnotation, SeamInspectionBundle.message("method.must.have.no.parameters.or.component.type", new Object[0]), new LocalQuickFix[0]);
        }
    }

    public static void checkGetterMethodSignature(ProblemsHolder holder, PsiAnnotation psiAnnotation, PsiMethod method) {
        if (!PropertyUtil.isSimplePropertyGetter((PsiMethod)method)) {
            holder.registerProblem((PsiElement)psiAnnotation, SeamInspectionBundle.message("method.is.not.getter", new Object[0]), new LocalQuickFix[0]);
        }
        SeamAnnotationIncorrectSignatureInspection.checkMethodIsNotStatic((PsiElement)psiAnnotation, holder, method);
    }

    public static void checkSetterMethodSignature(ProblemsHolder holder, PsiAnnotation psiAnnotation, PsiMethod method) {
        if (!PropertyUtil.isSimplePropertySetter((PsiMethod)method)) {
            holder.registerProblem((PsiElement)psiAnnotation, SeamInspectionBundle.message("method.is.not.setter", new Object[0]), new LocalQuickFix[0]);
        }
        SeamAnnotationIncorrectSignatureInspection.checkMethodIsNotStatic((PsiElement)psiAnnotation, holder, method);
    }

    public static void checkMethodHasReturnType(PsiAnnotation psiAnnotation, ProblemsHolder holder, PsiMethod method) {
        PsiType returnType = method.getReturnType();
        if (returnType == null || PsiType.VOID.equals((Object)returnType)) {
            holder.registerProblem((PsiElement)psiAnnotation, SeamInspectionBundle.message("method.must.have.return.type", new Object[0]), new LocalQuickFix[0]);
        }
    }

    public static void checkMethodHasVoidReturnType(PsiAnnotation psiAnnotation, ProblemsHolder holder, PsiMethod method) {
        PsiType returnType = method.getReturnType();
        if (returnType == null || !PsiType.VOID.equals((Object)returnType)) {
            holder.registerProblem((PsiElement)psiAnnotation, SeamInspectionBundle.message("method.must.have.void.return.type", new Object[0]), new LocalQuickFix[0]);
        }
    }

    public static void checkMethodIsPublic(PsiElement psiElement, ProblemsHolder holder, PsiMethod method) {
        if (!method.hasModifierProperty("public")) {
            holder.registerProblem(psiElement, SeamInspectionBundle.message("method.must.be.public", new Object[0]), new LocalQuickFix[0]);
        }
    }

    public static void checkMethodIsNotStatic(PsiElement psiElement, ProblemsHolder holder, PsiMethod method) {
        if (method.hasModifierProperty("static")) {
            holder.registerProblem(psiElement, SeamInspectionBundle.message("method.static.modifier.is.not.allowed", new Object[0]), new LocalQuickFix[0]);
        }
    }

    public static boolean hasEmptyConstructor(PsiClass psiClass) {
        PsiMethod[] methods = psiClass.getConstructors();
        if (methods.length == 0) {
            return true;
        }
        for (PsiMethod method : methods) {
            if (method.getParameterList().getParametersCount() != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isAbstract(PsiClass psiClass) {
        PsiModifierList modifierList = psiClass.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty("abstract");
    }

    @NotNull
    public String getDisplayName() {
        String string = SeamInspectionBundle.message("jam.annotation.incorrect.signature.inspection.name", new Object[0]);
        if (string == null) {
            SeamAnnotationIncorrectSignatureInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SeamAnnotationIncorrectSignatureInspection" == null) {
            SeamAnnotationIncorrectSignatureInspection.$$$reportNull$$$0(1);
        }
        return "SeamAnnotationIncorrectSignatureInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            SeamAnnotationIncorrectSignatureInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/seam/highlighting/jam/SeamAnnotationIncorrectSignatureInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

