/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.converters;

import com.intellij.codeInsight.lookup.LookupValueFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.seam.model.xml.components.SeamDomComponent;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeamPropertyNameConverter
extends Converter<BeanProperty>
implements CustomReferenceConverter<BeanProperty> {
    public BeanProperty fromString(@Nullable @NonNls String s, ConvertContext context) {
        PsiMethod method;
        if (s == null) {
            return null;
        }
        PsiClass psiClass = SeamPropertyNameConverter.getComponentClass(context);
        if (psiClass != null && (method = (PsiMethod)PropertyUtil.getAllProperties((PsiClass)psiClass, (boolean)true, (boolean)false).get(s)) != null) {
            return BeanProperty.createBeanProperty((PsiMethod)method);
        }
        return null;
    }

    @Nullable
    private static PsiClass getComponentClass(ConvertContext context) {
        PsiType psiType;
        SeamDomComponent component = SeamPropertyNameConverter.getSeamDomComponent(context);
        if (component != null && (psiType = component.getComponentType()) instanceof PsiClassType) {
            return ((PsiClassType)psiType).resolve();
        }
        return null;
    }

    @Nullable
    private static SeamDomComponent getSeamDomComponent(ConvertContext context) {
        return (SeamDomComponent)context.getInvocationElement().getParentOfType(SeamDomComponent.class, false);
    }

    public String toString(@Nullable BeanProperty beanProperty, ConvertContext context) {
        return beanProperty == null ? null : PropertyUtil.getPropertyNameBySetter((PsiMethod)beanProperty.getMethod());
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<BeanProperty> genericDomValue, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray = new PsiReference[]{new MyPsiReferenceBase(element, genericDomValue, SeamPropertyNameConverter.getUndefinedProperties(SeamPropertyNameConverter.getSeamDomComponent(context), SeamPropertyNameConverter.getComponentClass(context)))};
        if (psiReferenceArray == null) {
            SeamPropertyNameConverter.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    private static List<BeanProperty> getUndefinedProperties(@Nullable SeamDomComponent seamDomComponent, @Nullable PsiClass componentClass) {
        ArrayList<BeanProperty> properties = new ArrayList<BeanProperty>();
        if (seamDomComponent != null && componentClass != null) {
            List alreadyDefinedProperties = ContainerUtil.mapNotNull(seamDomComponent.getProperties(), seamProperty -> seamProperty.getPropertyName());
            Map map = PropertyUtil.getAllProperties((PsiClass)componentClass, (boolean)true, (boolean)false);
            for (String propertyName : map.keySet()) {
                if (alreadyDefinedProperties.contains(propertyName)) continue;
                properties.add(BeanProperty.createBeanProperty((PsiMethod)((PsiMethod)map.get(propertyName))));
            }
        }
        return properties;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/converters/SeamPropertyNameConverter", "createReferences"));
    }

    private static class MyPsiReferenceBase
    extends PsiReferenceBase<PsiElement> {
        private final GenericDomValue<BeanProperty> myGenericDomValue;
        private final List<BeanProperty> myUndefinedProperties;

        public MyPsiReferenceBase(PsiElement element, GenericDomValue<BeanProperty> genericDomValue, List<BeanProperty> undefinedProperties) {
            super(element);
            this.myGenericDomValue = genericDomValue;
            this.myUndefinedProperties = undefinedProperties;
        }

        public PsiElement resolve() {
            BeanProperty value = (BeanProperty)this.myGenericDomValue.getValue();
            return value == null ? null : value.getMethod();
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            String name = PropertyUtil.getPropertyName((String)newElementName);
            return super.handleElementRename(name == null ? newElementName : name);
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            String propertyName;
            if (element == null) {
                MyPsiReferenceBase.$$$reportNull$$$0(0);
            }
            if (element instanceof PsiMethod && (propertyName = PropertyUtil.getPropertyName((PsiMember)((PsiMember)element))) != null) {
                return super.handleElementRename(propertyName);
            }
            return this.getElement();
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = ContainerUtil.map2Array(this.myUndefinedProperties, beanProperty -> LookupValueFactory.createLookupValueWithHint((String)beanProperty.getName(), (Icon)beanProperty.getIcon(0), (String)beanProperty.getPropertyType().getPresentableText()));
            if (objectArray == null) {
                MyPsiReferenceBase.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/seam/model/converters/SeamPropertyNameConverter$MyPsiReferenceBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/seam/model/converters/SeamPropertyNameConverter$MyPsiReferenceBase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

