/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.TreeFileChooser;
import com.intellij.ide.util.TreeFileChooserFactory;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.LastSelectedPropertiesFileStore;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.lang.properties.references.I18nizeQuickFixModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class I18nizeQuickFixDialog
extends DialogWrapper
implements I18nizeQuickFixModel {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.i18n.I18nizeQuickFixDialog");
    private static final Pattern PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private JTextField myValue;
    private JComboBox myKey;
    private final TextFieldWithHistory myPropertiesFile;
    protected JPanel myPanel;
    private JCheckBox myUseResourceBundle;
    protected final Project myProject;
    protected final PsiFile myContext;
    private JPanel myPropertiesFilePanel;
    protected JPanel myExtensibilityPanel;
    protected final String myDefaultPropertyValue;
    protected final DialogCustomization myCustomization;

    public I18nizeQuickFixDialog(@NotNull Project project, @NotNull PsiFile context, String defaultPropertyValue, DialogCustomization customization) {
        if (project == null) {
            I18nizeQuickFixDialog.$$$reportNull$$$0(0);
        }
        if (context == null) {
            I18nizeQuickFixDialog.$$$reportNull$$$0(1);
        }
        this(project, context, defaultPropertyValue, customization, false);
    }

    protected I18nizeQuickFixDialog(@NotNull Project project, @NotNull PsiFile context, String defaultPropertyValue, DialogCustomization customization, boolean ancestorResponsible) {
        if (project == null) {
            I18nizeQuickFixDialog.$$$reportNull$$$0(2);
        }
        if (context == null) {
            I18nizeQuickFixDialog.$$$reportNull$$$0(3);
        }
        super(false);
        this.myProject = project;
        this.myContext = context;
        this.myDefaultPropertyValue = defaultPropertyValue;
        this.$$$setupUI$$$();
        this.myCustomization = customization != null ? customization : new DialogCustomization();
        this.setTitle(this.myCustomization.title != null ? this.myCustomization.title : CodeInsightBundle.message((String)"i18nize.dialog.title", (Object[])new Object[0]));
        this.myPropertiesFile = new TextFieldWithHistory();
        this.myPropertiesFile.setHistorySize(-1);
        this.myPropertiesFilePanel.add((Component)GuiUtils.constructFieldWithBrowseButton((TextFieldWithHistory)this.myPropertiesFile, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeFileChooserFactory chooserFactory = TreeFileChooserFactory.getInstance((Project)I18nizeQuickFixDialog.this.myProject);
                PropertiesFile propertiesFile = I18nizeQuickFixDialog.this.getPropertiesFile();
                TreeFileChooser fileChooser = chooserFactory.createFileChooser(CodeInsightBundle.message((String)"i18nize.dialog.property.file.chooser.title", (Object[])new Object[0]), propertiesFile != null ? propertiesFile.getContainingFile() : null, (FileType)StdFileTypes.PROPERTIES, null);
                fileChooser.showDialog();
                PsiFile selectedFile = fileChooser.getSelectedFile();
                if (selectedFile == null) {
                    return;
                }
                I18nizeQuickFixDialog.this.myPropertiesFile.setText(FileUtil.toSystemDependentName((String)selectedFile.getVirtualFile().getPath()));
            }
        }), "Center");
        this.myPropertiesFile.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                I18nizeQuickFixDialog.this.propertiesFileChanged();
                I18nizeQuickFixDialog.this.somethingChanged();
            }
        });
        this.getKeyTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                I18nizeQuickFixDialog.this.somethingChanged();
            }
        });
        this.myValue.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                I18nizeQuickFixDialog.this.somethingChanged();
            }
        });
        String KEY = "I18NIZE_DIALOG_USE_RESOURCE_BUNDLE";
        boolean useBundleByDefault = !PropertiesComponent.getInstance().isValueSet("I18NIZE_DIALOG_USE_RESOURCE_BUNDLE") || PropertiesComponent.getInstance().isTrueValue("I18NIZE_DIALOG_USE_RESOURCE_BUNDLE");
        this.myUseResourceBundle.setSelected(useBundleByDefault);
        this.myUseResourceBundle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesComponent.getInstance().setValue("I18NIZE_DIALOG_USE_RESOURCE_BUNDLE", Boolean.valueOf(I18nizeQuickFixDialog.this.myUseResourceBundle.isSelected()).toString());
            }
        });
        if (!ancestorResponsible) {
            this.init();
        }
    }

    protected void init() {
        this.populatePropertiesFiles();
        this.propertiesFileChanged();
        this.somethingChanged();
        this.setKeyValueEditBoxes();
        super.init();
    }

    private JTextField getKeyTextField() {
        return (JTextField)this.myKey.getEditor().getEditorComponent();
    }

    @NotNull
    protected List<String> getExistingValueKeys(String value) {
        if (!this.myCustomization.suggestExistingProperties) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                I18nizeQuickFixDialog.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<String> result = new ArrayList<String>();
        PropertiesFile propertiesFile = this.getPropertiesFile();
        if (propertiesFile != null) {
            for (IProperty property : propertiesFile.getProperties()) {
                if (!Comparing.strEqual((String)property.getValue(), (String)value)) continue;
                result.add(0, property.getUnescapedKey());
            }
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            I18nizeQuickFixDialog.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    protected String suggestPropertyKey(String value) {
        PropertiesFile propertiesFile;
        if (this.myCustomization.suggestedName != null) {
            return this.myCustomization.suggestedName;
        }
        String key = this.defaultSuggestPropertyKey(value);
        value = PATTERN.matcher(Normalizer.normalize(value, Normalizer.Form.NFD)).replaceAll("");
        if (key == null) {
            StringBuilder result = new StringBuilder();
            boolean insertDotBeforeNextWord = false;
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    if (insertDotBeforeNextWord) {
                        result.append('.');
                    }
                    result.append(Character.toLowerCase(c));
                    insertDotBeforeNextWord = false;
                    continue;
                }
                if (c == '&') {
                    if (insertDotBeforeNextWord || i == value.length() - 1 || Character.isLetter(value.charAt(i + 1))) continue;
                    insertDotBeforeNextWord = true;
                    continue;
                }
                if (result.length() <= 0) continue;
                insertDotBeforeNextWord = true;
            }
            key = result.toString();
        }
        if ((propertiesFile = this.getPropertiesFile()) != null) {
            if (propertiesFile.findPropertyByKey(key) == null) {
                return key;
            }
            int suffix = 1;
            while (propertiesFile.findPropertyByKey(key + suffix) != null) {
                ++suffix;
            }
            return key + suffix;
        }
        return key;
    }

    protected String defaultSuggestPropertyKey(String value) {
        return null;
    }

    private void propertiesFileChanged() {
        PropertiesFile propertiesFile = this.getPropertiesFile();
        boolean hasResourceBundle = propertiesFile != null && propertiesFile.getResourceBundle().getPropertiesFiles().size() > 1;
        this.myUseResourceBundle.setEnabled(hasResourceBundle);
    }

    private void setKeyValueEditBoxes() {
        List<String> existingValueKeys = this.getExistingValueKeys(this.myDefaultPropertyValue);
        if (existingValueKeys.isEmpty()) {
            this.getKeyTextField().setText(this.suggestPropertyKey(this.myDefaultPropertyValue));
        } else {
            for (String key : existingValueKeys) {
                this.myKey.addItem(key);
            }
            this.myKey.setSelectedItem(existingValueKeys.get(0));
        }
        this.myValue.setText(this.myDefaultPropertyValue);
    }

    protected void somethingChanged() {
        this.setOKActionEnabled(!StringUtil.isEmptyOrSpaces((String)this.getKey()));
    }

    private void populatePropertiesFiles() {
        List<String> paths = this.suggestPropertiesFiles();
        String lastUrl = this.suggestSelectedFileUrl(paths);
        String lastPath = lastUrl == null ? null : FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)lastUrl));
        Collections.sort(paths, (path1, path2) -> {
            if (lastPath != null && lastPath.equals(path1)) {
                return -1;
            }
            if (lastPath != null && lastPath.equals(path2)) {
                return 1;
            }
            int r = LastSelectedPropertiesFileStore.getUseCount(path2) - LastSelectedPropertiesFileStore.getUseCount(path1);
            return r == 0 ? path1.compareTo((String)path2) : r;
        });
        this.myPropertiesFile.setHistory(paths);
        if (lastPath != null) {
            this.myPropertiesFile.setSelectedItem((Object)lastPath);
        }
        if (this.myPropertiesFile.getSelectedIndex() == -1 && !paths.isEmpty()) {
            this.myPropertiesFile.setText(paths.get(0));
        }
    }

    private String suggestSelectedFileUrl(List<String> paths) {
        if (this.myDefaultPropertyValue != null) {
            for (String path : paths) {
                PsiFile psiFile;
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
                if (file == null || !((psiFile = this.myContext.getManager().findFile(file)) instanceof PropertiesFile)) continue;
                for (IProperty property : ((PropertiesFile)psiFile).getProperties()) {
                    if (!property.getValue().equals(this.myDefaultPropertyValue)) continue;
                    return path;
                }
            }
        }
        return LastSelectedPropertiesFileStore.getInstance().suggestLastSelectedPropertiesFileUrl(this.myContext);
    }

    private void saveLastSelectedFile() {
        PropertiesFile propertiesFile = this.getPropertiesFile();
        if (propertiesFile != null) {
            LastSelectedPropertiesFileStore.getInstance().saveLastSelectedPropertiesFile(this.myContext, propertiesFile);
        }
    }

    protected List<String> suggestPropertiesFiles() {
        if (this.myCustomization.propertiesFiles != null && !this.myCustomization.propertiesFiles.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            for (PropertiesFile propertiesFile : this.myCustomization.propertiesFiles) {
                VirtualFile virtualFile = propertiesFile.getVirtualFile();
                if (virtualFile == null) continue;
                list.add(virtualFile.getPath());
            }
            return list;
        }
        return this.defaultSuggestPropertiesFiles();
    }

    protected List<String> defaultSuggestPropertiesFiles() {
        return I18nUtil.defaultSuggestPropertiesFiles(this.myProject);
    }

    protected PropertiesFile getPropertiesFile() {
        String path = FileUtil.toSystemIndependentName((String)this.myPropertiesFile.getText());
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        return virtualFile != null ? PropertiesImplUtil.getPropertiesFile(PsiManager.getInstance((Project)this.myProject).findFile(virtualFile)) : null;
    }

    private boolean createPropertiesFileIfNotExists() {
        if (this.getPropertiesFile() != null) {
            return true;
        }
        final String path = FileUtil.toSystemIndependentName((String)this.myPropertiesFile.getText());
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            String message = CodeInsightBundle.message((String)"i18nize.empty.file.path", (Object[])new Object[]{this.myPropertiesFile.getText()});
            Messages.showErrorDialog((Project)this.myProject, (String)message, (String)CodeInsightBundle.message((String)"i18nize.error.creating.properties.file", (Object[])new Object[0]));
            this.myPropertiesFile.requestFocusInWindow();
            return false;
        }
        final FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(path);
        if (fileType != StdFileTypes.PROPERTIES && fileType != StdFileTypes.XML) {
            String message = CodeInsightBundle.message((String)"i18nize.cant.create.properties.file.because.its.name.is.associated", (Object[])new Object[]{this.myPropertiesFile.getText(), fileType.getDescription()});
            Messages.showErrorDialog((Project)this.myProject, (String)message, (String)CodeInsightBundle.message((String)"i18nize.error.creating.properties.file", (Object[])new Object[0]));
            this.myPropertiesFile.requestFocusInWindow();
            return false;
        }
        try {
            final File file = new File(path).getCanonicalFile();
            FileUtil.createParentDirs((File)file);
            ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<PsiFile, Exception>(){

                public PsiFile compute() throws Exception {
                    VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file.getParentFile());
                    PsiManager psiManager = PsiManager.getInstance((Project)I18nizeQuickFixDialog.this.myProject);
                    if (dir == null) {
                        throw new IOException("Error creating directory structure for file '" + path + "'");
                    }
                    if (fileType == StdFileTypes.PROPERTIES) {
                        return psiManager.findFile(dir.createChildData((Object)this, file.getName()));
                    }
                    FileTemplate template = FileTemplateManager.getInstance((Project)I18nizeQuickFixDialog.this.myProject).getInternalTemplate("XML Properties File.xml");
                    LOG.assertTrue(template != null);
                    return (PsiFile)FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)file.getName(), null, (PsiDirectory)psiManager.findDirectory(dir));
                }
            });
        }
        catch (Exception e) {
            Messages.showErrorDialog((Project)this.myProject, (String)e.getLocalizedMessage(), (String)CodeInsightBundle.message((String)"i18nize.error.creating.properties.file", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCustomization.focusValueComponent ? this.myValue : this.myKey;
    }

    public void dispose() {
        this.saveLastSelectedFile();
        super.dispose();
    }

    protected void doOKAction() {
        if (!this.createPropertiesFileIfNotExists()) {
            return;
        }
        Collection<PropertiesFile> propertiesFiles = this.getAllPropertiesFiles();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            String messageText;
            int code;
            IProperty existingProperty = propertiesFile.findPropertyByKey(this.getKey());
            String propValue = this.myValue.getText();
            if (existingProperty == null || Comparing.strEqual((String)existingProperty.getValue(), (String)propValue) || (code = Messages.showOkCancelDialog((Project)this.myProject, (String)(messageText = CodeInsightBundle.message((String)"i18nize.dialog.error.property.already.defined.message", (Object[])new Object[]{this.getKey(), propertiesFile.getName()})), (String)CodeInsightBundle.message((String)"i18nize.dialog.error.property.already.defined.title", (Object[])new Object[0]), null)) != 2) continue;
            return;
        }
        super.doOKAction();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            I18nizeQuickFixDialog.$$$reportNull$$$0(6);
        }
        return actionArray;
    }

    public void doHelpAction() {
        HelpManager.getInstance().invokeHelp("editing.propertyFile.i18nInspection");
    }

    public JComponent getValueComponent() {
        return this.myValue;
    }

    @Override
    public String getValue() {
        return this.myValue.getText();
    }

    @Override
    public String getKey() {
        return this.getKeyTextField().getText();
    }

    @Override
    public boolean hasValidData() {
        assert (!ApplicationManager.getApplication().isUnitTestMode());
        this.show();
        return this.getExitCode() == 0;
    }

    private boolean isUseResourceBundle() {
        return this.myUseResourceBundle.isEnabled() && this.myUseResourceBundle.isSelected();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.codeInsight.i18n.I18nizeQuickFixDialog";
    }

    @Override
    public Collection<PropertiesFile> getAllPropertiesFiles() {
        PropertiesFile propertiesFile = this.getPropertiesFile();
        if (propertiesFile == null) {
            return Collections.emptySet();
        }
        Collection<PropertiesFile> propertiesFiles = this.isUseResourceBundle() ? propertiesFile.getResourceBundle().getPropertiesFiles() : Collections.singleton(propertiesFile);
        return propertiesFiles;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/references/I18nizeQuickFixDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/references/I18nizeQuickFixDialog";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingValueKeys";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JTextField jTextField;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setMinimumSize(new Dimension(148, 209));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(5, 5, 5, 5), 4, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/CodeInsightBundle").getString("i18n.quickfix.property.panel.title"), (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CodeInsightBundle").getString("i18n.quickfix.property.panel.property.key.label"));
        jPanel4.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/CodeInsightBundle").getString("i18n.quickfix.property.panel.property.value.label"));
        jPanel4.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myValue = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/CodeInsightBundle").getString("i18n.quickfix.property.panel.properties.file.label"));
        jPanel4.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myPropertiesFilePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myUseResourceBundle = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/CodeInsightBundle").getString("i18n.quickfix.property.panel.update.all.files.in.bundle.checkbox"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myKey = jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        jPanel4.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 7, 0, new Dimension(100, -1), null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myExtensibilityPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor(jComboBox);
        jLabel2.setLabelFor(jTextField);
        jLabel3.setLabelFor(jPanel2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static class DialogCustomization {
        private final String title;
        private final boolean suggestExistingProperties;
        private final boolean focusValueComponent;
        private final List<PropertiesFile> propertiesFiles;
        private final String suggestedName;

        public DialogCustomization(String title, boolean suggestExistingProperties, boolean focusValueComponent, List<PropertiesFile> propertiesFiles, String suggestedName) {
            this.title = title;
            this.suggestExistingProperties = suggestExistingProperties;
            this.focusValueComponent = focusValueComponent;
            this.propertiesFiles = propertiesFiles;
            this.suggestedName = suggestedName;
        }

        public DialogCustomization() {
            this(null, true, false, null, null);
        }

        public String getSuggestedName() {
            return this.suggestedName;
        }
    }
}

