/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.ResultLayout;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateSeance;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateCursor;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;
import org.jetbrains.dekaf.jdbc.JdbcParametersHandler;
import org.jetbrains.dekaf.jdbc.JdbcUtil;
import org.jetbrains.dekaf.util.Objects;

public abstract class JdbcIntermediateSeance
implements IntegralIntermediateSeance {
    @NotNull
    protected final JdbcIntermediateSession mySession;
    @NotNull
    protected final String myStatementText;
    protected PreparedStatement myStatement;
    protected int myPackLimit = 0;
    @Nullable
    protected ResultSet myDefaultResultSet;
    protected boolean myDefaultResultSetHasRows;
    protected int myAffectedRowsCount;
    @Nullable
    protected JdbcIntermediateCursor<?> myDefaultCursor;

    protected JdbcIntermediateSeance(@NotNull JdbcIntermediateSession session, @NotNull String statementText) {
        this.mySession = session;
        this.myStatementText = statementText;
    }

    @Override
    public synchronized void setInParameters(@NotNull Object[] parameters) {
        assert (this.myStatement != null);
        try {
            this.assignParameters(this.myStatement, parameters);
        }
        catch (SQLException sqle) {
            throw this.mySession.recognizeException(sqle, this.myStatementText);
        }
    }

    protected void assignParameters(@NotNull PreparedStatement stmt, Object[] params) throws SQLException {
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            JdbcParametersHandler.assignParameter(stmt, i + 1, param);
        }
    }

    @Override
    public void setPackLimit(int packLimit) {
        if (packLimit < 0) {
            throw new IllegalArgumentException("PackLimit is negative: " + packLimit);
        }
        this.myPackLimit = packLimit;
    }

    @Override
    public synchronized void execute() {
        try {
            this.mySession.tuneStatement(this.myStatement, this.myPackLimit);
            boolean gotResultSet = this.myStatement.execute();
            if (gotResultSet) {
                this.myDefaultResultSet = this.mySession.getDefaultResultSet(this.myStatement);
                if (!this.myDefaultResultSet.isClosed()) {
                    this.mySession.tuneResultSet(this.myDefaultResultSet, this.myPackLimit);
                    this.myDefaultResultSetHasRows = this.myDefaultResultSet.next();
                    if (!this.myDefaultResultSetHasRows) {
                        JdbcUtil.close(this.myDefaultResultSet);
                    }
                } else {
                    this.myDefaultResultSetHasRows = false;
                }
            } else {
                this.myAffectedRowsCount = this.myStatement.getUpdateCount();
            }
        }
        catch (SQLException sqle) {
            throw this.mySession.recognizeException(sqle, this.myStatementText);
        }
    }

    @Override
    public int getAffectedRowsCount() {
        return this.myAffectedRowsCount;
    }

    protected <R> JdbcIntermediateCursor<R> openDefaultCursor(@NotNull ResultLayout<R> layout) {
        if (this.myDefaultResultSet == null) {
            throw new IllegalStateException("Cannot open cursor: the statement was not executed or it has not returned cursor.");
        }
        if (this.myDefaultCursor == null) {
            JdbcIntermediateCursor<R> cursor = new JdbcIntermediateCursor<R>(this, this.myDefaultResultSet, layout, true, this.myDefaultResultSetHasRows ? Boolean.TRUE : Boolean.FALSE);
            this.myDefaultCursor = cursor;
            return cursor;
        }
        if (layout.equals(this.myDefaultCursor.myResultLayout)) {
            return this.myDefaultCursor;
        }
        throw new IllegalStateException("The cursor already opened with another layout.");
    }

    @Override
    public synchronized void close() {
        if (this.myDefaultCursor != null && this.myDefaultCursor.isOpened()) {
            this.myDefaultCursor.close();
            this.myDefaultCursor = null;
        }
        if (this.myDefaultResultSet != null) {
            try {
                JdbcUtil.close(this.myDefaultResultSet);
            }
            finally {
                this.myDefaultResultSet = null;
            }
        }
        if (this.myStatement != null) {
            try {
                JdbcUtil.close(this.myStatement);
            }
            finally {
                this.myStatement = null;
            }
        }
    }

    @Override
    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) throws ClassCastException {
        if (serviceName.equalsIgnoreCase("jdbc-statement")) {
            return Objects.castTo(serviceClass, this.myStatement);
        }
        if (serviceName.equalsIgnoreCase("jdbc-result-set")) {
            return Objects.castTo(serviceClass, this.myDefaultResultSet);
        }
        if (serviceName.equalsIgnoreCase("jdbc-metadata")) {
            return Objects.castTo(serviceClass, this.getResultSetMetaData());
        }
        return null;
    }

    @Nullable
    private ResultSetMetaData getResultSetMetaData() {
        ResultSet rset = this.myDefaultResultSet;
        if (rset == null) {
            return null;
        }
        try {
            return rset.getMetaData();
        }
        catch (SQLException e) {
            String className = rset.getClass().getName();
            throw this.mySession.recognizeException(e, className + ".getMetaData()");
        }
    }

    public boolean isStatementOpened() {
        try {
            return this.myStatement != null && JdbcUtil.isClosed(this.myStatement);
        }
        catch (SQLException sqle) {
            JdbcUtil.printCloseException(sqle, this.myStatement.getClass());
            return false;
        }
    }

    public int countOpenedCursors() {
        return this.myDefaultCursor != null && this.myDefaultCursor.isOpened() ? 1 : 0;
    }
}

