/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.jetbrains.annotations.NotNull;

abstract class JdbcUtil {
    JdbcUtil() {
    }

    static String getColumnName(@NotNull ResultSetMetaData md, int columnIndex) throws SQLException {
        boolean sybaseNative = md.getClass().getSimpleName().equals("RowFormat2Token");
        return !sybaseNative ? md.getColumnName(columnIndex) : md.getColumnLabel(columnIndex);
    }

    static boolean isClosed(Connection connection) throws SQLException {
        if (connection == null) {
            return true;
        }
        try {
            return connection.isClosed();
        }
        catch (AbstractMethodError ame) {
            return false;
        }
    }

    static boolean isClosed(Statement statement) throws SQLException {
        if (statement == null) {
            return true;
        }
        try {
            return statement.isClosed();
        }
        catch (AbstractMethodError ame) {
            return false;
        }
    }

    static boolean isClosed(ResultSet rset) throws SQLException {
        if (rset == null) {
            return true;
        }
        try {
            return rset.isClosed();
        }
        catch (AbstractMethodError ame) {
            return false;
        }
    }

    static void close(Connection connection) {
        try {
            if (JdbcUtil.isClosed(connection)) {
                return;
            }
            connection.close();
        }
        catch (Exception e) {
            JdbcUtil.printCloseException(e, connection.getClass());
        }
    }

    static void close(Statement statement) {
        try {
            if (!JdbcUtil.isClosed(statement)) {
                statement.close();
            }
        }
        catch (Exception e) {
            JdbcUtil.printCloseException(e, statement.getClass());
        }
    }

    static void close(ResultSet rset) {
        try {
            if (!JdbcUtil.isClosed(rset)) {
                rset.close();
            }
        }
        catch (Exception e) {
            JdbcUtil.printCloseException(e, rset.getClass());
        }
    }

    static void printCloseException(Exception e, Class serviceClass) {
        String operation = "close JDBC object (" + serviceClass.getCanonicalName() + ")";
        JdbcUtil.printOperationException(e, operation);
    }

    static void printOperationException(Exception e, String operation) {
        String message;
        if (e instanceof SQLException) {
            SQLException sqle = (SQLException)e;
            message = String.format("JDBC ERROR: Failed to " + operation + ". SQL exception class (%s) encountered, with SQL state %s, error code %d and message: %s", sqle.getClass().getName(), sqle.getSQLState(), sqle.getErrorCode(), sqle.getMessage());
        } else {
            message = String.format("JDBC ERROR: Failed to " + operation + ". Exception class (%s) encountered with message: %s", e.getClass().getName(), e.getMessage());
        }
        System.err.println(message);
    }
}

