/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.appServerIntegration;

import com.intellij.database.dataSource.DataSourceProvider;
import com.intellij.icons.AllIcons;
import com.intellij.javaee.appServerIntegrations.AppServerSpecificValidator;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.openapi.ex.AppServerIntegrationsManager;
import com.intellij.javaee.oss.descriptor.JavaeeDescriptorsManager;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeeServerHelper;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.applicationServer.WeblogicApplicationServerHelper;
import com.intellij.javaee.weblogic.applicationServer.WeblogicDeploymentSettingsEditor;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicVersion;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicVersionConfig;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicVersionList;
import com.intellij.javaee.weblogic.build.WebLogicValidatorsFactory;
import com.intellij.javaee.weblogic.dataSource.WeblogicDataSourceProviderImpl;
import com.intellij.javaee.weblogic.runDebug.deployment.WLDeploymentModel;
import com.intellij.javaee.weblogic.runDebug.deployment.WeblogicDeploymentProvider;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.util.Function;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeblogicIntegration
extends JavaeeIntegration {
    public static WeblogicIntegration getInstance() {
        return (WeblogicIntegration)AppServerIntegrationsManager.getInstance().getIntegration(WeblogicIntegration.class);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Oracle;
        if (icon == null) {
            WeblogicIntegration.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @NotNull
    public Icon getBigIcon() {
        Icon icon = AllIcons.Providers.Oracle;
        if (icon == null) {
            WeblogicIntegration.$$$reportNull$$$0(1);
        }
        return icon;
    }

    public DeploymentProvider getDeploymentProvider(boolean local) {
        return new WeblogicDeploymentProvider(!local);
    }

    protected void collectDescriptors(JavaeeDescriptorsManager descriptorsManager) {
    }

    @NotNull
    public String getName() {
        String string = WeblogicBundle.message("weblogic.integration.presentable.name", new Object[0]);
        if (string == null) {
            WeblogicIntegration.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String getNameFromTemplate(String template) throws Exception {
        return null;
    }

    public String getVersionFromTemplate(String template) throws Exception {
        return null;
    }

    @NotNull
    public String getServerVersion(JavaeePersistentData persistentData) throws Exception {
        String home = persistentData.HOME;
        WeblogicVersionList versionList = WeblogicVersionConfig.getVersionList(persistentData);
        if (versionList.isEmpty()) {
            throw new Exception(WeblogicBundle.message("message.text.weblogic.server.configuration.directory.is.not.bea.home", home));
        }
        WeblogicVersion version = WeblogicVersionConfig.getChosenVersion(persistentData);
        if (version == null) {
            throw new Exception(WeblogicBundle.message("error.cannot.find.selected.server.version", new Object[0]));
        }
        if (!version.getJarFile().exists()) {
            throw new Exception(WeblogicBundle.message("error.cannot.find.libraries.in.path", version.getLibDir()));
        }
        String string = StringUtil.join(versionList.getVersions(), (String)", ");
        if (string == null) {
            WeblogicIntegration.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected void checkValidServerHome(String home, String version) throws Exception {
    }

    protected boolean allLibrariesFound(Collection<String> classes, Function<String, String> mapper) {
        return true;
    }

    protected void addLibraryLocations(JavaeePersistentData persistentData, List<File> locations) {
        WeblogicVersion version = WeblogicVersionConfig.getChosenVersion(persistentData);
        if (version == null) {
            return;
        }
        locations.add(version.getLibDir());
    }

    protected void addLibraryLocations(String home, List<File> locations) {
        throw new UnsupportedOperationException();
    }

    public String getContextRoot(JavaeeFacet facet) {
        return null;
    }

    @Nullable
    public AppServerSpecificValidator getAppServerSpecificValidator(@NotNull JavaeeFacet facet, @NotNull ApplicationServer server) {
        if (facet == null) {
            WeblogicIntegration.$$$reportNull$$$0(4);
        }
        if (server == null) {
            WeblogicIntegration.$$$reportNull$$$0(5);
        }
        return WebLogicValidatorsFactory.createValidator(facet, server);
    }

    public AppServerSpecificValidator getAppServerSpecificValidator(@NotNull ApplicationServer server, ArtifactType artifactType, @NotNull Project project) {
        if (server == null) {
            WeblogicIntegration.$$$reportNull$$$0(6);
        }
        if (project == null) {
            WeblogicIntegration.$$$reportNull$$$0(7);
        }
        return WebLogicValidatorsFactory.createValidator(server, artifactType, project);
    }

    public DataSourceProvider getDataSourceProvider() {
        return new WeblogicDataSourceProviderImpl();
    }

    public SettingsEditor<DeploymentModel> createAdditionalDeploymentSettingsEditor(CommonModel commonModel, DeploymentSource source) {
        return new WeblogicDeploymentSettingsEditor(commonModel, source);
    }

    public DeploymentModel createNewDeploymentModel(CommonModel commonModel, DeploymentSource source) {
        return new WLDeploymentModel(commonModel, source);
    }

    protected JavaeeServerHelper createServerHelper() {
        return new WeblogicApplicationServerHelper();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/weblogic/appServerIntegration/WeblogicIntegration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBigIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerVersion";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/weblogic/appServerIntegration/WeblogicIntegration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAppServerSpecificValidator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

