/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.editors;

import com.intellij.javaee.model.xml.ejb.CmpField;
import com.intellij.javaee.model.xml.ejb.EntityBean;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.model.persistence.FieldGroup;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRdbmsBean;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.reflect.DomGenericInfo;
import com.intellij.util.xml.ui.ChildGenericValueColumnInfo;
import com.intellij.util.xml.ui.DomCollectionControl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class WLFieldGroupsPanel
extends DomCollectionControl<FieldGroup> {
    private final EntityBean myEjb;

    public WLFieldGroupsPanel(EntityBean ejb, WeblogicRdbmsBean weblogicBean) {
        super((DomElement)weblogicBean, "field-group");
        this.myEjb = ejb;
    }

    protected ColumnInfo[] createColumnInfos(DomElement parent) {
        ArrayList<Object> result = new ArrayList<Object>();
        DomGenericInfo info = parent.getManager().getGenericInfo(FieldGroup.class);
        result.add(new ChildGenericValueColumnInfo(WeblogicBundle.message("column.name.configure.field.groups.group.name", new Object[0]), info.getFixedChildDescription("group-name"), (TableCellEditor)new DefaultCellEditor(new JTextField())));
        for (CmpField field : this.myEjb.getCmpFields()) {
            final String fieldName = (String)field.getFieldName().getValue();
            result.add(new ColumnInfo<FieldGroup, Boolean>(fieldName){

                public TableCellRenderer getRenderer(FieldGroup p0) {
                    return new BooleanTableCellRenderer();
                }

                public TableCellEditor getEditor(FieldGroup item) {
                    return new BooleanTableCellEditor();
                }

                public void setValue(FieldGroup o, Boolean aValue) {
                    Set cmpNames = ContainerUtil.map2Set((Collection)WLFieldGroupsPanel.this.myEjb.getCmpFields(), s -> (String)s.getFieldName().getValue());
                    for (GenericDomValue<String> value : o.getCmpFields()) {
                        if (cmpNames.contains(value.getValue())) continue;
                        value.undefine();
                    }
                    if (!aValue.booleanValue()) {
                        GenericDomValue value = (GenericDomValue)ContainerUtil.find(o.getCmpFields(), object -> Comparing.equal((String)fieldName, (String)((String)object.getValue())));
                        if (value != null) {
                            value.undefine();
                        }
                    } else {
                        o.addCmpField().setValue((Object)fieldName);
                    }
                }

                public boolean isCellEditable(FieldGroup o) {
                    return true;
                }

                public Boolean valueOf(FieldGroup object) {
                    return ContainerUtil.map2Set(object.getCmpFields(), s -> (String)s.getValue()).contains(fieldName);
                }
            });
        }
        return result.toArray(new ColumnInfo[result.size()]);
    }
}

