/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.reference;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.struts.inplace.reference.BaseReferenceProvider;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.highlighting.ResolvingElementQuickFix;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlValueReference
implements PsiReference,
LocalQuickFixProvider,
EmptyResolveMessageProvider {
    protected final XmlAttributeValue myValue;
    private final BaseReferenceProvider myProvider;
    protected boolean mySoft;
    private TextRange myRange;
    protected int errorType;
    private static final int ERROR_NO = 0;
    private static final int ERROR_EMPTY = 1;
    private static final int ERROR_DEFAULT = 2;

    public void setSoft(boolean soft) {
        this.mySoft = soft;
    }

    public void setRange(TextRange range) {
        this.myRange = range;
    }

    public XmlValueReference(XmlAttributeValue attribute, BaseReferenceProvider provider) {
        this(attribute, provider, null);
    }

    public XmlValueReference(XmlAttributeValue attribute, BaseReferenceProvider provider, TextRange range) {
        this.myRange = range == null ? new TextRange(1, attribute.getValue().length() + 1) : range;
        this.myValue = attribute;
        this.myProvider = provider;
        this.mySoft = provider.isSoft();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myValue.getProject();
        if (project == null) {
            XmlValueReference.$$$reportNull$$$0(0);
        }
        return project;
    }

    @Nullable
    public WebFacet getWebFacet() {
        return WebUtil.getWebFacet((PsiElement)this.myValue);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return ElementManipulators.getManipulator((PsiElement)this.myValue).handleContentChange((PsiElement)this.myValue, this.getRangeInElement(), newElementName);
    }

    @Nullable
    protected static Object[] getItems(Collection<? extends DomElement> elements) {
        if (elements == null) {
            return null;
        }
        return ElementPresentationManager.getInstance().createVariants(elements, 1);
    }

    @NotNull
    public String getValue() {
        String s = this.myValue.getValue();
        if (this.myRange == null) {
            String string = s;
            if (string == null) {
                XmlValueReference.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = s.substring(this.myRange.getStartOffset() - 1, this.myRange.getEndOffset() - 1);
        if (string == null) {
            XmlValueReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myProvider.getCanonicalName() + " " + this.getValue();
        if (string == null) {
            XmlValueReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    public PsiElement bindToElement(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            XmlValueReference.$$$reportNull$$$0(4);
        }
        return null;
    }

    public PsiElement getElement() {
        return this.myValue;
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objects = this.doGetVariants();
        Object[] objectArray = objects == null ? EMPTY_ARRAY : objects;
        if (objectArray == null) {
            XmlValueReference.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    public TextRange getRangeInElement() {
        switch (this.errorType) {
            case 1: {
                return new TextRange(1, this.getValue().length() + 1);
            }
        }
        if (this.myRange == null) {
            return new TextRange(1, this.getValue().length() + 1);
        }
        return this.myRange;
    }

    public PsiElement resolve() {
        if (this.myValue.getValue().trim().length() == 0) {
            this.errorType = 1;
            return null;
        }
        this.errorType = 0;
        PsiElement result = this.doResolve();
        if (result == null && this.errorType == 0) {
            this.errorType = 2;
        }
        return result;
    }

    @Nullable
    protected abstract PsiElement doResolve();

    @Nullable
    protected abstract Object[] doGetVariants();

    public boolean isReferenceTo(PsiElement psielement) {
        return psielement.getManager().areElementsEquivalent(psielement, this.resolve());
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        switch (this.errorType) {
            case 1: {
                if ("Wrong attribute value" == null) {
                    XmlValueReference.$$$reportNull$$$0(6);
                }
                return "Wrong attribute value";
            }
        }
        String string = "Cannot resolve " + this.getCanonicalText();
        if (string == null) {
            XmlValueReference.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    protected ResolvingElementQuickFix createResolvingFix(DomElement scope) {
        String text;
        Class<? extends DomElement> domClass = this.myProvider.getDomClass();
        if (domClass != null && (text = this.getValue().trim()).length() > 0 && scope != null) {
            return ResolvingElementQuickFix.createFix((String)text, domClass, (DomElement)scope);
        }
        return null;
    }

    public LocalQuickFix[] getQuickFixes() {
        LocalQuickFix[] localQuickFixArray;
        ResolvingElementQuickFix quickFix = this.createResolvingFix(this.getScope());
        if (quickFix == null) {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        } else {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = quickFix;
        }
        return localQuickFixArray;
    }

    @Nullable
    protected DomElement getScope() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/struts/inplace/reference/XmlValueReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/struts/inplace/reference/XmlValueReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

