/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js;

import com.google.gwt.dev.js.ScopeContext;
import com.google.gwt.dev.js.parserExceptions.JsParserException;
import com.google.gwt.dev.js.rhino.CodePosition;
import com.google.gwt.dev.js.rhino.Node;
import com.google.gwt.dev.js.rhino.TokenStream;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDebugger;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsRegExp;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;

public class JsAstMapper {
    private final ScopeContext scopeContext;
    @NotNull
    private final String fileName;

    public JsAstMapper(@NotNull JsScope scope2, @NotNull String fileName) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/google/gwt/dev/js/JsAstMapper", "<init>"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/google/gwt/dev/js/JsAstMapper", "<init>"));
        }
        this.scopeContext = new ScopeContext(scope2);
        this.fileName = fileName;
    }

    private static JsParserException createParserException(String msg, Node offender) {
        return new JsParserException("Parser encountered internal error: " + msg, offender.getPosition());
    }

    private JsNode map(Node node) throws JsParserException {
        return this.withLocation(this.mapWithoutLocation(node), node);
    }

    private JsNode mapWithoutLocation(Node node) throws JsParserException {
        switch (node.getType()) {
            case 147: {
                JsBlock block = new JsBlock();
                this.mapStatements(block.getStatements(), node);
                return block;
            }
            case 146: {
                return this.mapDebuggerStatement(node);
            }
            case 132: {
                return null;
            }
            case 140: {
                return this.mapExpressionStatement(node);
            }
            case 56: {
                return this.mapRegExp(node);
            }
            case 23: {
                return this.mapBinaryOperation(JsBinaryOperator.ADD, node);
            }
            case 24: {
                return this.mapBinaryOperation(JsBinaryOperator.SUB, node);
            }
            case 25: {
                return this.mapBinaryOperation(JsBinaryOperator.MUL, node);
            }
            case 26: {
                return this.mapBinaryOperation(JsBinaryOperator.DIV, node);
            }
            case 27: {
                return this.mapBinaryOperation(JsBinaryOperator.MOD, node);
            }
            case 101: {
                return this.mapBinaryOperation(JsBinaryOperator.AND, node);
            }
            case 100: {
                return this.mapBinaryOperation(JsBinaryOperator.OR, node);
            }
            case 13: {
                return this.mapBinaryOperation(JsBinaryOperator.BIT_AND, node);
            }
            case 11: {
                return this.mapBinaryOperation(JsBinaryOperator.BIT_OR, node);
            }
            case 12: {
                return this.mapBinaryOperation(JsBinaryOperator.BIT_XOR, node);
            }
            case 97: {
                return this.mapAssignmentVariant(node);
            }
            case 103: {
                return this.mapRelationalVariant(node);
            }
            case 102: {
                return this.mapEqualityVariant(node);
            }
            case 104: {
                return this.mapShiftVariant(node);
            }
            case 105: {
                return this.mapUnaryVariant(node);
            }
            case 106: {
                return this.mapIncDecFixity(JsUnaryOperator.INC, node);
            }
            case 107: {
                return this.mapIncDecFixity(JsUnaryOperator.DEC, node);
            }
            case 98: {
                return this.mapConditional(node);
            }
            case 46: {
                return new JsStringLiteral(node.getString());
            }
            case 148: {
                return JsAstMapper.mapIntNumber(node);
            }
            case 45: {
                return JsAstMapper.mapDoubleNumber(node);
            }
            case 43: {
                return this.mapCall(node);
            }
            case 39: {
                return this.mapGetProp(node);
            }
            case 40: {
                return this.mapSetProp(node);
            }
            case 31: {
                return this.mapDeleteProp(node);
            }
            case 113: {
                return this.mapIfStatement(node);
            }
            case 118: {
                return this.mapDoOrWhileStatement(true, node);
            }
            case 119: {
                return this.mapDoOrWhileStatement(false, node);
            }
            case 120: {
                return this.mapForStatement(node);
            }
            case 124: {
                return this.mapWithStatement(node);
            }
            case 41: {
                return this.mapGetElem(node);
            }
            case 42: {
                return this.mapSetElem(node);
            }
            case 110: {
                return this.mapFunction(node);
            }
            case 133: {
                return this.mapBlock(node);
            }
            case 10: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG, node);
            }
            case 44: 
            case 61: {
                return this.scopeContext.globalNameFor(node.getString()).makeRef();
            }
            case 5: {
                return this.mapReturn(node);
            }
            case 121: {
                return this.mapBreak(node);
            }
            case 122: {
                return this.mapContinue(node);
            }
            case 135: {
                return this.mapObjectLit(node);
            }
            case 134: {
                return this.mapArrayLit(node);
            }
            case 123: {
                return this.mapVar(node);
            }
            case 109: {
                return JsAstMapper.mapPrimary(node);
            }
            case 96: {
                return this.mapBinaryOperation(JsBinaryOperator.COMMA, node);
            }
            case 30: {
                return this.mapNew(node);
            }
            case 62: {
                return this.mapThrowStatement(node);
            }
            case 75: {
                return this.mapTryStatement(node);
            }
            case 115: {
                return this.mapSwitchStatement(node);
            }
            case 136: {
                return this.mapLabel(node);
            }
        }
        int tokenType = node.getType();
        throw JsAstMapper.createParserException("Unexpected top-level token type: " + tokenType, node);
    }

    private JsArrayLiteral mapArrayLit(Node node) throws JsParserException {
        JsArrayLiteral toLit = new JsArrayLiteral();
        for (Node from = node.getFirstChild(); from != null; from = from.getNext()) {
            toLit.getExpressions().add(this.mapExpression(from));
        }
        return toLit;
    }

    private JsNameRef mapAsPropertyNameRef(Node nameRefNode) throws JsParserException {
        JsNode unknown = this.map(nameRefNode);
        if (unknown instanceof JsStringLiteral) {
            JsStringLiteral lit = (JsStringLiteral)unknown;
            return this.scopeContext.referenceFor(lit.getValue());
        }
        throw JsAstMapper.createParserException("Expecting a name reference", nameRefNode);
    }

    private JsExpression mapAssignmentVariant(Node asgNode) throws JsParserException {
        switch (asgNode.getOperation()) {
            case 128: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG, asgNode);
            }
            case 23: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_ADD, asgNode);
            }
            case 24: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_SUB, asgNode);
            }
            case 25: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_MUL, asgNode);
            }
            case 26: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_DIV, asgNode);
            }
            case 27: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_MOD, asgNode);
            }
            case 13: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_BIT_AND, asgNode);
            }
            case 11: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_BIT_OR, asgNode);
            }
            case 12: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_BIT_XOR, asgNode);
            }
            case 20: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_SHL, asgNode);
            }
            case 21: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_SHR, asgNode);
            }
            case 22: {
                return this.mapBinaryOperation(JsBinaryOperator.ASG_SHRU, asgNode);
            }
        }
        throw JsAstMapper.createParserException("Unknown assignment operator variant: " + asgNode.getOperation(), asgNode);
    }

    private JsExpression mapBinaryOperation(JsBinaryOperator op, Node node) throws JsParserException {
        Node from1 = node.getFirstChild();
        Node from2 = from1.getNext();
        JsExpression to1 = this.mapExpression(from1);
        JsExpression to2 = this.mapExpression(from2);
        return new JsBinaryOperation(op, to1, to2);
    }

    private JsBlock mapBlock(Node nodeStmts) throws JsParserException {
        JsBlock block = new JsBlock();
        this.mapStatements(block.getStatements(), nodeStmts);
        return block;
    }

    private JsBreak mapBreak(Node breakNode) {
        return new JsBreak(this.getTargetLabel(breakNode));
    }

    @Nullable
    private JsNameRef getTargetLabel(@NotNull Node statementWithLabel) {
        if (statementWithLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementWithLabel", "com/google/gwt/dev/js/JsAstMapper", "getTargetLabel"));
        }
        int type2 = statementWithLabel.getType();
        if (type2 != 121 && type2 != 122) {
            String tokenTypeName = TokenStream.tokenToName(statementWithLabel.getType());
            throw new AssertionError((Object)("Unexpected node type with label: " + tokenTypeName));
        }
        Node label2 = statementWithLabel.getFirstChild();
        if (label2 == null) {
            return null;
        }
        String identifier2 = label2.getString();
        assert (identifier2 != null) : "If label exists identifier should not be null";
        JsName labelName = this.scopeContext.labelFor(identifier2);
        assert (labelName != null) : "Unknown label name: " + identifier2;
        return labelName.makeRef();
    }

    private JsInvocation mapCall(Node callNode) throws JsParserException {
        Node from = callNode.getFirstChild();
        JsExpression qualifier = this.mapExpression(from);
        SmartList arguments2 = new SmartList();
        for (from = from.getNext(); from != null; from = from.getNext()) {
            arguments2.add(this.mapExpression(from));
        }
        return new JsInvocation(qualifier, (List<? extends JsExpression>)arguments2);
    }

    private JsExpression mapConditional(Node condNode) throws JsParserException {
        JsConditional toCond = new JsConditional();
        Node fromTest = condNode.getFirstChild();
        toCond.setTestExpression(this.mapExpression(fromTest));
        Node fromThen = fromTest.getNext();
        toCond.setThenExpression(this.mapExpression(fromThen));
        Node fromElse = fromThen.getNext();
        toCond.setElseExpression(this.mapExpression(fromElse));
        return toCond;
    }

    private JsContinue mapContinue(Node contNode) {
        return new JsContinue(this.getTargetLabel(contNode));
    }

    private JsStatement mapDebuggerStatement(Node node) {
        return new JsDebugger();
    }

    private JsExpression mapDeleteProp(Node node) throws JsParserException {
        Node from = node.getFirstChild();
        JsExpression to = this.mapExpression(from);
        if (to instanceof JsNameRef) {
            return new JsPrefixOperation(JsUnaryOperator.DELETE, to);
        }
        if (to instanceof JsArrayAccess) {
            return new JsPrefixOperation(JsUnaryOperator.DELETE, to);
        }
        throw JsAstMapper.createParserException("'delete' can only operate on property names and array elements", from);
    }

    private JsStatement mapDoOrWhileStatement(boolean isWhile, Node ifNode) throws JsParserException {
        Node fromBody;
        Node fromTestExpr;
        if (isWhile) {
            fromTestExpr = ifNode.getFirstChild();
            fromBody = ifNode.getFirstChild().getNext();
        } else {
            fromBody = ifNode.getFirstChild();
            fromTestExpr = ifNode.getFirstChild().getNext();
        }
        JsExpression toTestExpr = this.mapExpression(fromTestExpr);
        JsStatement toBody = this.mapStatement(fromBody);
        if (isWhile) {
            return new JsWhile(toTestExpr, toBody);
        }
        return new JsDoWhile(toTestExpr, toBody);
    }

    private JsExpression mapEqualityVariant(Node eqNode) throws JsParserException {
        switch (eqNode.getOperation()) {
            case 14: {
                return this.mapBinaryOperation(JsBinaryOperator.EQ, eqNode);
            }
            case 15: {
                return this.mapBinaryOperation(JsBinaryOperator.NEQ, eqNode);
            }
            case 53: {
                return this.mapBinaryOperation(JsBinaryOperator.REF_EQ, eqNode);
            }
            case 54: {
                return this.mapBinaryOperation(JsBinaryOperator.REF_NEQ, eqNode);
            }
            case 16: {
                return this.mapBinaryOperation(JsBinaryOperator.LT, eqNode);
            }
            case 17: {
                return this.mapBinaryOperation(JsBinaryOperator.LTE, eqNode);
            }
            case 18: {
                return this.mapBinaryOperation(JsBinaryOperator.GT, eqNode);
            }
            case 19: {
                return this.mapBinaryOperation(JsBinaryOperator.GTE, eqNode);
            }
        }
        throw JsAstMapper.createParserException("Unknown equality operator variant: " + eqNode.getOperation(), eqNode);
    }

    private JsExpression mapExpression(Node exprNode) throws JsParserException {
        JsNode unknown = this.map(exprNode);
        if (unknown instanceof JsExpression) {
            return (JsExpression)unknown;
        }
        throw JsAstMapper.createParserException("Expecting an expression", exprNode);
    }

    private JsStatement mapExpressionStatement(Node node) throws JsParserException {
        JsExpression expr2 = this.mapExpression(node.getFirstChild());
        return expr2.makeStmt();
    }

    private JsStatement mapForStatement(Node forNode) throws JsParserException {
        JsFor toFor;
        Node fromInit = forNode.getFirstChild();
        Node fromTest = fromInit.getNext();
        Node fromIncr = fromTest.getNext();
        Node fromBody = fromIncr.getNext();
        if (fromBody == null) {
            JsForIn toForIn;
            Node fromIter = forNode.getFirstChild();
            Node fromObjExpr = fromIter.getNext();
            fromBody = fromObjExpr.getNext();
            if (fromIter.getType() == 123) {
                Node fromIterVarName = fromIter.getFirstChild();
                String fromName = fromIterVarName.getString();
                JsName toName = this.scopeContext.localNameFor(fromName);
                toForIn = new JsForIn(toName);
                Node fromIterInit = fromIterVarName.getFirstChild();
                if (fromIterInit != null) {
                    toForIn.setIterExpression(this.mapOptionalExpression(fromIterInit));
                }
            } else {
                toForIn = new JsForIn();
                toForIn.setIterExpression(this.mapExpression(fromIter));
            }
            toForIn.setObjectExpression(this.mapExpression(fromObjExpr));
            JsStatement bodyStmt = this.mapStatement(fromBody);
            if (bodyStmt != null) {
                toForIn.setBody(bodyStmt);
            } else {
                toForIn.setBody(JsEmpty.INSTANCE);
            }
            return toForIn;
        }
        JsNode init2 = this.map(fromInit);
        JsExpression condition2 = this.mapOptionalExpression(fromTest);
        JsExpression increment = this.mapOptionalExpression(fromIncr);
        assert (init2 != null);
        if (init2 instanceof JsVars) {
            toFor = new JsFor((JsVars)init2, condition2, increment);
        } else {
            assert (init2 instanceof JsExpression);
            toFor = new JsFor((JsExpression)init2, condition2, increment);
        }
        JsStatement bodyStmt = this.mapStatement(fromBody);
        if (bodyStmt != null) {
            toFor.setBody(bodyStmt);
        } else {
            toFor.setBody(JsEmpty.INSTANCE);
        }
        return toFor;
    }

    public JsFunction mapFunction(Node fnNode) throws JsParserException {
        int nodeType = fnNode.getType();
        assert (nodeType == 110) : "Expected function node, got: " + TokenStream.tokenToName(nodeType);
        Node fromFnNameNode = fnNode.getFirstChild();
        Node fromParamNode = fnNode.getFirstChild().getNext().getFirstChild();
        Node fromBodyNode = fnNode.getFirstChild().getNext().getNext();
        JsFunction toFn = this.scopeContext.enterFunction();
        String fnNameIdent = fromFnNameNode.getString();
        if (fnNameIdent != null && fnNameIdent.length() > 0) {
            toFn.setName(this.scopeContext.globalNameFor(fnNameIdent));
        }
        while (fromParamNode != null) {
            String fromParamName = fromParamNode.getString();
            JsName name2 = this.scopeContext.localNameFor(fromParamName);
            toFn.getParameters().add(new JsParameter(name2));
            fromParamNode = fromParamNode.getNext();
        }
        JsBlock toBody = this.mapBlock(fromBodyNode);
        toFn.setBody(toBody);
        this.scopeContext.exitFunction();
        return toFn;
    }

    private JsArrayAccess mapGetElem(Node getElemNode) throws JsParserException {
        Node from1 = getElemNode.getFirstChild();
        Node from2 = from1.getNext();
        JsExpression to1 = this.mapExpression(from1);
        JsExpression to2 = this.mapExpression(from2);
        return new JsArrayAccess(to1, to2);
    }

    private JsNameRef mapGetProp(Node getPropNode) throws JsParserException {
        Node from1 = getPropNode.getFirstChild();
        Node from2 = from1.getNext();
        JsExpression toQualifier = this.mapExpression(from1);
        JsNameRef toNameRef = this.mapAsPropertyNameRef(from2);
        toNameRef.setQualifier(toQualifier);
        return toNameRef;
    }

    private JsIf mapIfStatement(Node ifNode) throws JsParserException {
        Node fromTestExpr = ifNode.getFirstChild();
        Node fromThenBlock = ifNode.getFirstChild().getNext();
        Node fromElseBlock = ifNode.getFirstChild().getNext().getNext();
        JsIf toIf = new JsIf(this.mapExpression(fromTestExpr), this.mapStatement(fromThenBlock));
        if (fromElseBlock != null) {
            toIf.setElseStatement(this.mapStatement(fromElseBlock));
        }
        return toIf;
    }

    private JsExpression mapIncDecFixity(JsUnaryOperator op, Node node) throws JsParserException {
        switch (node.getOperation()) {
            case 130: {
                return this.mapPrefixOperation(op, node);
            }
            case 131: {
                return this.mapPostfixOperation(op, node);
            }
        }
        throw JsAstMapper.createParserException("Unknown prefix/postfix variant: " + node.getOperation(), node);
    }

    private JsLabel mapLabel(Node labelNode) throws JsParserException {
        String fromName = labelNode.getFirstChild().getString();
        JsName toName = this.scopeContext.enterLabel(fromName, fromName);
        Node fromStmt = labelNode.getFirstChild().getNext();
        JsLabel toLabel = new JsLabel(toName);
        toLabel.setStatement(this.mapStatement(fromStmt));
        this.scopeContext.exitLabel();
        return toLabel;
    }

    private JsNew mapNew(Node newNode) throws JsParserException {
        Node fromCtorExpr = newNode.getFirstChild();
        JsNew newExpr = new JsNew(this.mapExpression(fromCtorExpr));
        List<JsExpression> args = newExpr.getArguments();
        for (Node fromArg = fromCtorExpr.getNext(); fromArg != null; fromArg = fromArg.getNext()) {
            args.add(this.mapExpression(fromArg));
        }
        return newExpr;
    }

    private static JsExpression mapIntNumber(Node numberNode) {
        double value2 = numberNode.getDouble();
        if (value2 <= 2.147483647E9 && value2 >= -2.147483648E9) {
            return new JsIntLiteral((int)numberNode.getDouble());
        }
        return new JsDoubleLiteral(numberNode.getDouble());
    }

    private static JsExpression mapDoubleNumber(Node numberNode) {
        return new JsDoubleLiteral(numberNode.getDouble());
    }

    private JsExpression mapObjectLit(Node objLitNode) throws JsParserException {
        JsObjectLiteral toLit = new JsObjectLiteral();
        for (Node fromPropInit = objLitNode.getFirstChild(); fromPropInit != null; fromPropInit = fromPropInit.getNext()) {
            Node fromLabelExpr = fromPropInit;
            JsExpression toLabelExpr = this.mapExpression(fromLabelExpr);
            Node fromValueExpr = fromPropInit = fromPropInit.getNext();
            if (fromValueExpr == null) {
                throw JsAstMapper.createParserException("Expected an init expression for: " + toLabelExpr, objLitNode);
            }
            JsExpression toValueExpr = this.mapExpression(fromValueExpr);
            JsPropertyInitializer toPropInit = new JsPropertyInitializer(toLabelExpr, toValueExpr);
            toLit.getPropertyInitializers().add(toPropInit);
        }
        return toLit;
    }

    private JsExpression mapOptionalExpression(Node exprNode) throws JsParserException {
        JsNode unknown = this.map(exprNode);
        if (unknown != null) {
            if (unknown instanceof JsExpression) {
                return (JsExpression)unknown;
            }
            throw JsAstMapper.createParserException("Expecting an expression or null", exprNode);
        }
        return null;
    }

    private JsExpression mapPostfixOperation(JsUnaryOperator op, Node node) throws JsParserException {
        Node from = node.getFirstChild();
        JsExpression to = this.mapExpression(from);
        return new JsPostfixOperation(op, to);
    }

    private JsExpression mapPrefixOperation(JsUnaryOperator op, Node node) throws JsParserException {
        Node from = node.getFirstChild();
        JsExpression to = this.mapExpression(from);
        return new JsPrefixOperation(op, to);
    }

    private static JsExpression mapPrimary(Node node) throws JsParserException {
        switch (node.getOperation()) {
            case 50: {
                return new JsThisRef();
            }
            case 52: {
                return new JsBooleanLiteral(true);
            }
            case 51: {
                return new JsBooleanLiteral(false);
            }
            case 49: {
                return new JsNullLiteral();
            }
            case 74: {
                return new JsNameRef("undefined");
            }
        }
        throw JsAstMapper.createParserException("Unknown primary: " + node.getOperation(), node);
    }

    private JsNode mapRegExp(Node regExpNode) {
        JsRegExp toRegExp = new JsRegExp();
        Node fromPattern = regExpNode.getFirstChild();
        toRegExp.setPattern(fromPattern.getString());
        Node fromFlags = fromPattern.getNext();
        if (fromFlags != null) {
            toRegExp.setFlags(fromFlags.getString());
        }
        return toRegExp;
    }

    private JsExpression mapRelationalVariant(Node relNode) throws JsParserException {
        switch (relNode.getOperation()) {
            case 16: {
                return this.mapBinaryOperation(JsBinaryOperator.LT, relNode);
            }
            case 17: {
                return this.mapBinaryOperation(JsBinaryOperator.LTE, relNode);
            }
            case 18: {
                return this.mapBinaryOperation(JsBinaryOperator.GT, relNode);
            }
            case 19: {
                return this.mapBinaryOperation(JsBinaryOperator.GTE, relNode);
            }
            case 64: {
                return this.mapBinaryOperation(JsBinaryOperator.INSTANCEOF, relNode);
            }
            case 63: {
                return this.mapBinaryOperation(JsBinaryOperator.INOP, relNode);
            }
        }
        throw JsAstMapper.createParserException("Unknown relational operator variant: " + relNode.getOperation(), relNode);
    }

    private JsReturn mapReturn(Node returnNode) throws JsParserException {
        JsReturn toReturn = new JsReturn();
        Node from = returnNode.getFirstChild();
        if (from != null) {
            JsExpression to = this.mapExpression(from);
            toReturn.setExpression(to);
        }
        return toReturn;
    }

    private JsExpression mapSetElem(Node setElemNode) throws JsParserException {
        JsArrayAccess lhs = this.mapGetElem(setElemNode);
        Node fromRhs = setElemNode.getFirstChild().getNext().getNext();
        JsExpression toRhs = this.mapExpression(fromRhs);
        return new JsBinaryOperation(JsBinaryOperator.ASG, lhs, toRhs);
    }

    private JsExpression mapSetProp(Node getPropNode) throws JsParserException {
        JsNameRef lhs = this.mapGetProp(getPropNode);
        Node fromRhs = getPropNode.getFirstChild().getNext().getNext();
        JsExpression toRhs = this.mapExpression(fromRhs);
        return new JsBinaryOperation(JsBinaryOperator.ASG, lhs, toRhs);
    }

    private JsExpression mapShiftVariant(Node shiftNode) throws JsParserException {
        switch (shiftNode.getOperation()) {
            case 20: {
                return this.mapBinaryOperation(JsBinaryOperator.SHL, shiftNode);
            }
            case 21: {
                return this.mapBinaryOperation(JsBinaryOperator.SHR, shiftNode);
            }
            case 22: {
                return this.mapBinaryOperation(JsBinaryOperator.SHRU, shiftNode);
            }
        }
        throw JsAstMapper.createParserException("Unknown equality operator variant: " + shiftNode.getOperation(), shiftNode);
    }

    private JsStatement mapStatement(Node nodeStmt) throws JsParserException {
        JsNode unknown = this.map(nodeStmt);
        if (unknown != null) {
            if (unknown instanceof JsStatement) {
                return (JsStatement)unknown;
            }
            if (unknown instanceof JsExpression) {
                return ((JsExpression)unknown).makeStmt();
            }
            throw JsAstMapper.createParserException("Expecting a statement", nodeStmt);
        }
        return JsEmpty.INSTANCE;
    }

    private void mapStatements(List<JsStatement> stmts, Node nodeStmts) throws JsParserException {
        for (Node curr = nodeStmts.getFirstChild(); curr != null; curr = curr.getNext()) {
            JsStatement stmt = this.mapStatement(curr);
            if (stmt == null) continue;
            stmts.add(stmt);
        }
    }

    public List<JsStatement> mapStatements(Node nodeStmts) throws JsParserException {
        ArrayList<JsStatement> stmts = new ArrayList<JsStatement>();
        this.mapStatements(stmts, nodeStmts);
        return stmts;
    }

    private JsSwitch mapSwitchStatement(Node switchNode) throws JsParserException {
        JsSwitch toSwitch = new JsSwitch();
        Node fromSwitchExpr = switchNode.getFirstChild();
        toSwitch.setExpression(this.mapExpression(fromSwitchExpr));
        for (Node fromMember = fromSwitchExpr.getNext(); fromMember != null; fromMember = fromMember.getNext()) {
            if (fromMember.getType() == 116) {
                JsCase toCase = new JsCase();
                Node fromCaseExpr = fromMember.getFirstChild();
                toCase.setCaseExpression(this.mapExpression(fromCaseExpr));
                Node fromCaseBlock = fromCaseExpr.getNext();
                this.mapStatements(toCase.getStatements(), fromCaseBlock);
                toSwitch.getCases().add(toCase);
                continue;
            }
            assert (fromMember.getType() == 117);
            JsDefault toDefault = new JsDefault();
            Node fromDefaultBlock = fromMember.getFirstChild();
            this.mapStatements(toDefault.getStatements(), fromDefaultBlock);
            toSwitch.getCases().add(toDefault);
        }
        return toSwitch;
    }

    private JsThrow mapThrowStatement(Node throwNode) throws JsParserException {
        Node fromExpr = throwNode.getFirstChild();
        JsThrow toThrow = new JsThrow(this.mapExpression(fromExpr));
        return toThrow;
    }

    private JsTry mapTryStatement(Node tryNode) throws JsParserException {
        JsTry toTry = new JsTry();
        Node fromTryBody = tryNode.getFirstChild();
        toTry.setTryBlock(this.mapBlock(fromTryBody));
        Node fromCatchNodes = fromTryBody.getNext();
        Node fromCatchNode = fromCatchNodes.getFirstChild();
        while (fromCatchNode != null) {
            assert (fromCatchNode.getType() == 125);
            Node fromCatchVarName = fromCatchNode.getFirstChild();
            JsCatch catchBlock = this.scopeContext.enterCatch(fromCatchVarName.getString());
            fromCatchNode = fromCatchNode.getNext();
            Node fromCondition = fromCatchVarName.getNext();
            JsExpression toCondition = this.mapExpression(fromCondition);
            catchBlock.setCondition(toCondition);
            if (fromCatchNode == null && toCondition instanceof JsBooleanLiteral && ((JsBooleanLiteral)toCondition).getValue()) {
                catchBlock.setCondition(null);
            }
            Node fromCatchBody = fromCondition.getNext();
            catchBlock.setBody(this.mapBlock(fromCatchBody));
            toTry.getCatches().add(catchBlock);
            this.scopeContext.exitCatch();
        }
        Node fromFinallyNode = fromCatchNodes.getNext();
        if (fromFinallyNode != null) {
            toTry.setFinallyBlock(this.mapBlock(fromFinallyNode));
        }
        return toTry;
    }

    private JsExpression mapUnaryVariant(Node unOp) throws JsParserException {
        switch (unOp.getOperation()) {
            case 24: {
                double value2;
                Node operand = unOp.getFirstChild();
                if (operand.getType() == 148 && -(value2 = operand.getDouble()) >= -2.147483648E9) {
                    return new JsIntLiteral((int)(-value2));
                }
                return this.mapPrefixOperation(JsUnaryOperator.NEG, unOp);
            }
            case 129: {
                return this.mapPrefixOperation(JsUnaryOperator.NOT, unOp);
            }
            case 28: {
                return this.mapPrefixOperation(JsUnaryOperator.BIT_NOT, unOp);
            }
            case 32: {
                return this.mapPrefixOperation(JsUnaryOperator.TYPEOF, unOp);
            }
            case 23: {
                return this.mapPrefixOperation(JsUnaryOperator.POS, unOp);
            }
            case 132: {
                return this.mapPrefixOperation(JsUnaryOperator.VOID, unOp);
            }
        }
        throw JsAstMapper.createParserException("Unknown unary operator variant: " + unOp.getOperation(), unOp);
    }

    private JsVars mapVar(Node varNode) throws JsParserException {
        JsVars toVars = new JsVars();
        for (Node fromVar = varNode.getFirstChild(); fromVar != null; fromVar = fromVar.getNext()) {
            String fromName = fromVar.getString();
            JsName toName = this.scopeContext.localNameFor(fromName);
            JsVars.JsVar toVar = this.withLocation(new JsVars.JsVar(toName), fromVar);
            Node fromInit = fromVar.getFirstChild();
            if (fromInit != null) {
                JsExpression toInit = this.mapExpression(fromInit);
                toVar.setInitExpression(toInit);
            }
            toVars.add(toVar);
        }
        return toVars;
    }

    private JsNode mapWithStatement(Node withNode) throws JsParserException {
        throw JsAstMapper.createParserException("Internal error: unexpected token 'with'", withNode);
    }

    private <T extends JsNode> T withLocation(T astNode, Node node) {
        CodePosition location2 = node.getPosition();
        if (location2 != null) {
            JsExpression expression2;
            JsLocation jsLocation = new JsLocation(this.fileName, location2.getLine(), location2.getOffset());
            if (astNode instanceof SourceInfoAwareJsNode) {
                astNode.setSource(jsLocation);
            } else if (astNode instanceof JsExpressionStatement && (expression2 = ((JsExpressionStatement)astNode).getExpression()).getSource() == null) {
                expression2.setSource(jsLocation);
            }
        }
        return astNode;
    }
}

