/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.coroutines;

import java.util.ArrayList;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.coroutines.ProcessUninitializedStoresKt;
import org.jetbrains.kotlin.codegen.coroutines.UninitializedNewValue;
import org.jetbrains.kotlin.codegen.coroutines.UninitializedNewValueMarkerInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.CustomFramesMethodAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\tH\u0002\u00a8\u0006\f"}, d2={"processUninitializedStores", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "getUninitializedValueForConstructorCall", "Lorg/jetbrains/kotlin/codegen/coroutines/UninitializedNewValue;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "isConstructorCall", "", "backend"})
public final class ProcessUninitializedStoresKt {
    /*
     * WARNING - void declaration
     */
    public static final void processUninitializedStores(@NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        UninitializedNewValueMarkerInterpreter interpreter = new UninitializedNewValueMarkerInterpreter();
        Frame<V>[] frames2 = new CustomFramesMethodAnalyzer("fake", methodNode, interpreter, processUninitializedStores.frames.1.INSTANCE).analyze();
        for (IndexedValue indexedValue : ArraysKt.withIndex((Object[])methodNode.instructions.toArray())) {
            Set<AbstractInsnNode> copyUsages;
            boolean bl;
            UninitializedNewValue uninitializedValue;
            Frame frame;
            int index2 = indexedValue.component1();
            AbstractInsnNode insn = (AbstractInsnNode)indexedValue.component2();
            if (frames2[index2] == null) {
                continue;
            }
            AbstractInsnNode abstractInsnNode = insn;
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"insn");
            if (ProcessUninitializedStoresKt.getUninitializedValueForConstructorCall(frame, abstractInsnNode) == null) {
                continue;
            }
            if (interpreter.getUninitializedValuesToCopyUsages().get(uninitializedValue.getNewInsn()) == null) {
                Intrinsics.throwNpe();
            }
            boolean bl2 = bl = copyUsages.size() > 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "At least DUP copy operation expected";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (copyUsages.size() == 1) continue;
            Iterable $receiver$iv = SetsKt.plus(copyUsages, (Object)uninitializedValue.getNewInsn());
            for (Object element$iv : $receiver$iv) {
                AbstractInsnNode it = (AbstractInsnNode)element$iv;
                methodNode.instructions.remove(it);
            }
            int indexOfConstructorArgumentFromTopOfStack = ((Object[])Type.getArgumentTypes((String)((MethodInsnNode)insn).desc)).length;
            ArrayList<Type> storedTypes = new ArrayList<Type>();
            int nextVarIndex = methodNode.maxLocals;
            int it = 0;
            int n = indexOfConstructorArgumentFromTopOfStack;
            while (it < n) {
                void i;
                BasicValue value2 = (BasicValue)frame.getStack(frame.getStackSize() - 1 - i);
                Type type2 = value2.getType();
                methodNode.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(type2.getOpcode(54), nextVarIndex));
                nextVarIndex += type2.getSize();
                storedTypes.add(type2);
                ++i;
            }
            methodNode.maxLocals = Math.max(methodNode.maxLocals, nextVarIndex);
            methodNode.instructions.insertBefore(insn, UtilKt.insnListOf((AbstractInsnNode)new TypeInsnNode(187, uninitializedValue.getNewInsn().desc), (AbstractInsnNode)new InsnNode(89)));
            for (Type type3 : CollectionsKt.reversed((Iterable)storedTypes)) {
                methodNode.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(type3.getOpcode(21), nextVarIndex -= type3.getSize()));
            }
        }
    }

    private static final UninitializedNewValue getUninitializedValueForConstructorCall(@NotNull Frame<BasicValue> $receiver, AbstractInsnNode insn) {
        boolean bl;
        if (!ProcessUninitializedStoresKt.isConstructorCall(insn)) {
            return null;
        }
        boolean bl2 = bl = insn.getOpcode() == 183;
        if (_Assertions.ENABLED && !bl) {
            String string = "Expected opcode Opcodes.INVOKESPECIAL for <init>, but " + insn.getOpcode() + " found";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        AbstractInsnNode abstractInsnNode = insn;
        if (abstractInsnNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.MethodInsnNode");
        }
        int paramsCountIncludingReceiver = ((Object[])Type.getArgumentTypes((String)((MethodInsnNode)abstractInsnNode).desc)).length + 1;
        Value value2 = $receiver.getStack($receiver.getStackSize() - (paramsCountIncludingReceiver + 1));
        if (!(value2 instanceof UninitializedNewValue)) {
            value2 = null;
        }
        UninitializedNewValue uninitializedNewValue = (UninitializedNewValue)value2;
        if (uninitializedNewValue == null) {
            String string = "Expected value generated with NEW";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        UninitializedNewValue newValue = uninitializedNewValue;
        boolean bl3 = $receiver.getStack($receiver.getStackSize() - paramsCountIncludingReceiver) instanceof UninitializedNewValue;
        if (_Assertions.ENABLED && !bl3) {
            String string = "Next value after NEW should be one generated by DUP";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return newValue;
    }

    private static final boolean isConstructorCall(@NotNull AbstractInsnNode $receiver) {
        return $receiver instanceof MethodInsnNode && Intrinsics.areEqual((Object)((MethodInsnNode)$receiver).name, (Object)"<init>");
    }

    @Nullable
    public static final /* synthetic */ UninitializedNewValue access$getUninitializedValueForConstructorCall(@NotNull Frame $receiver, @NotNull AbstractInsnNode insn) {
        return ProcessUninitializedStoresKt.getUninitializedValueForConstructorCall((Frame<BasicValue>)$receiver, insn);
    }
}

