/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.roots.DependencyScope;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.KotlinGradleModel;
import org.jetbrains.kotlin.gradle.KotlinGradleModelBuilder;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleProjectResolverExtensionKt;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006H\u0002J&\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00100\u000fH\u0016J\u0016\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00100\u000fH\u0016J,\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0016J,\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleProjectResolverExtension;", "Lorg/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension;", "()V", "addDependency", "", "ideModule", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "targetModule", "findModule", "ideProject", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "moduleId", "", "getExtraProjectModelClasses", "", "Ljava/lang/Class;", "", "getToolingExtensionsClasses", "populateModuleDependencies", "gradleModule", "Lorg/gradle/tooling/model/idea/IdeaModule;", "populateSourceSetDependencies", "fromModule", "idea-gradle"})
public final class KotlinGradleProjectResolverExtension
extends AbstractProjectResolverExtension {
    @NotNull
    public Set<Class<? extends Object>> getToolingExtensionsClasses() {
        return SetsKt.setOf((Object[])new Class[]{KotlinGradleModelBuilder.class, Unit.class});
    }

    @NotNull
    public Set<Class<? extends Object>> getExtraProjectModelClasses() {
        return SetsKt.setOf(KotlinGradleModel.class);
    }

    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) {
        Intrinsics.checkParameterIsNotNull((Object)gradleModule, (String)"gradleModule");
        Intrinsics.checkParameterIsNotNull(ideModule, (String)"ideModule");
        Intrinsics.checkParameterIsNotNull(ideProject, (String)"ideProject");
        KotlinGradleModel kotlinGradleModel = (KotlinGradleModel)this.resolverCtx.getExtraProject(gradleModule, KotlinGradleModel.class);
        if (kotlinGradleModel == null) {
            return;
        }
        KotlinGradleModel gradleModel = kotlinGradleModel;
        Iterable $receiver$iv = gradleModel.getTransitiveCommonDependencies();
        for (Object element$iv : $receiver$iv) {
            DataNode<ModuleData> targetModule;
            String implementsModuleId = (String)element$iv;
            if (this.findModule(ideProject, implementsModuleId) == null) {
                return;
            }
            if (this.resolverCtx.isResolveModulePerSourceSet()) {
                this.populateSourceSetDependencies(gradleModule, ideModule, targetModule);
                continue;
            }
            this.addDependency(ideModule, targetModule);
        }
        KotlinGradleProjectResolverExtensionKt.setResolved(ideModule, true);
        KotlinGradleProjectResolverExtensionKt.setHasKotlinPlugin(ideModule, gradleModel.getHasKotlinPlugin());
        KotlinGradleProjectResolverExtensionKt.setCompilerArgumentsBySourceSet(ideModule, gradleModel.getCompilerArgumentsBySourceSet());
        KotlinGradleProjectResolverExtensionKt.setCoroutines(ideModule, gradleModel.getCoroutines());
        KotlinGradleProjectResolverExtensionKt.setPlatformPluginId(ideModule, gradleModel.getPlatformPluginId());
        super.populateModuleDependencies(gradleModule, ideModule, ideProject);
    }

    private final void addDependency(DataNode<? extends ModuleData> ideModule, DataNode<? extends ModuleData> targetModule) {
        ModuleDependencyData moduleDependencyData = new ModuleDependencyData((ModuleData)ideModule.getData(), (ModuleData)targetModule.getData());
        moduleDependencyData.setScope(DependencyScope.COMPILE);
        moduleDependencyData.setExported(false);
        ideModule.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)moduleDependencyData);
    }

    private final DataNode<ModuleData> findModule(DataNode<ProjectData> ideProject, String moduleId) {
        Object v2;
        block2: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)ideProject.getChildren();
            for (Object t : iterable2) {
                DataNode it = (DataNode)t;
                Object object = it.getData();
                if (!(object instanceof ModuleData)) {
                    object = null;
                }
                ModuleData moduleData = (ModuleData)object;
                if (!Intrinsics.areEqual((Object)(moduleData != null ? moduleData.getId() : null), (Object)moduleId)) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    private final void populateSourceSetDependencies(IdeaModule gradleModule, DataNode<ModuleData> fromModule, DataNode<ModuleData> targetModule) {
        void $receiver$iv$iv;
        void $receiver$iv;
        String string;
        Map map2;
        void $receiver$iv$iv2;
        void $receiver$iv2;
        Iterable iterable = ExternalSystemApiUtil.findAll(fromModule, (Key)GradleSourceSetData.KEY);
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10)), (int)16);
        void var7_7 = $receiver$iv2;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        for (Object element$iv$iv : $receiver$iv$iv2) {
            void it;
            DataNode dataNode = (DataNode)element$iv$iv;
            map2 = destination$iv$iv;
            string = ((GradleSourceSetData)it.getData()).getId();
            map2.put(string, element$iv$iv);
        }
        Map fromSourceSets = destination$iv$iv;
        Iterable capacity$iv22 = ExternalSystemApiUtil.findAll(targetModule, (Key)GradleSourceSetData.KEY);
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv = $receiver$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            void it;
            DataNode $i$a$1$associateBy = (DataNode)element$iv$iv;
            map2 = destination$iv$iv2;
            string = StringsKt.substringAfterLast$default((String)((GradleSourceSetData)it.getData()).getId(), (char)':', null, (int)2, null);
            map2.put(string, element$iv$iv);
        }
        Map targetSourceSets = destination$iv$iv2;
        ExternalProject externalProject = (ExternalProject)this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (externalProject == null) {
            return;
        }
        ExternalProject externalProject2 = externalProject;
        for (ExternalSourceSet sourceSet : externalProject2.getSourceSets().values()) {
            DataNode targetModuleDataNode;
            DataNode fromModuleDataNode;
            if (sourceSet == null || sourceSet.getSources().isEmpty()) continue;
            String moduleId = GradleProjectResolverUtil.getModuleId((ExternalProject)externalProject2, (ExternalSourceSet)sourceSet);
            if ((fromSourceSets.isEmpty() ? fromModule : (DataNode)fromSourceSets.get(moduleId)) == null) {
                continue;
            }
            fromModuleDataNode = fromModuleDataNode;
            if ((targetSourceSets.isEmpty() ? targetModule : (DataNode)targetSourceSets.get(sourceSet.getName())) == null) {
                continue;
            }
            targetModuleDataNode = targetModuleDataNode;
            this.addDependency((DataNode<? extends ModuleData>)fromModuleDataNode, (DataNode<? extends ModuleData>)targetModuleDataNode);
        }
    }
}

