/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.facet.Facet;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.CoroutineSupport;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.gradle.ArgsInfo;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleProjectResolverExtensionKt;
import org.jetbrains.kotlin.idea.facet.FacetUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.facet.KotlinFacetType;
import org.jetbrains.kotlin.idea.inspections.gradle.DifferentStdlibGradleVersionInspectionKt;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleInspectionVisitorKt;
import org.jetbrains.kotlin.idea.inspections.gradle.NodeWithData;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a8\u0010\b\u001a\u0004\u0018\u00010\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u001c\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u001a\u001a\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u001a\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"gradlePropertyFiles", "", "", "adjustClasspath", "", "kotlinFacet", "Lorg/jetbrains/kotlin/idea/facet/KotlinFacet;", "dependencyClasspath", "configureFacetByGradleModule", "moduleNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "sourceSetNode", "Lorg/jetbrains/plugins/gradle/model/data/GradleSourceSetData;", "ideModule", "Lcom/intellij/openapi/module/Module;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "detectPlatformByLibrary", "Lorg/jetbrains/kotlin/config/TargetPlatformKind;", "detectPlatformByPlugin", "findKotlinCoroutinesProperty", "project", "Lcom/intellij/openapi/project/Project;", "idea-gradle"})
public final class KotlinGradleSourceSetDataServiceKt {
    private static final List<String> gradlePropertyFiles = CollectionsKt.listOf((Object[])new String[]{"local.properties", "gradle.properties"});

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final TargetPlatformKind<?> detectPlatformByPlugin(@NotNull DataNode<ModuleData> moduleNode) {
        block5: {
            TargetPlatformKind targetPlatformKind;
            block7: {
                block6: {
                    String string;
                    Intrinsics.checkParameterIsNotNull(moduleNode, (String)"moduleNode");
                    String string2 = string = KotlinGradleProjectResolverExtensionKt.getPlatformPluginId(moduleNode);
                    if (string2 == null) break block5;
                    switch (string2.hashCode()) {
                        case 107431447: {
                            if (!string.equals("kotlin-platform-js")) return null;
                            break block6;
                        }
                        case -964592237: {
                            if (!string.equals("kotlin-platform-jvm")) return null;
                            break;
                        }
                        case 1252084665: {
                            if (!string.equals("kotlin-platform-common")) return null;
                            break block7;
                        }
                    }
                    targetPlatformKind = TargetPlatformKind.Jvm.Companion.get(JvmTarget.JVM_1_6);
                    return targetPlatformKind;
                }
                targetPlatformKind = TargetPlatformKind.JavaScript.INSTANCE;
                return targetPlatformKind;
            }
            targetPlatformKind = TargetPlatformKind.Common.INSTANCE;
            return targetPlatformKind;
        }
        return null;
    }

    private static final TargetPlatformKind<?> detectPlatformByLibrary(DataNode<ModuleData> moduleNode) {
        Map.Entry it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = FacetUtilsKt.getMavenLibraryIdToPlatform().entrySet();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            if (!(DifferentStdlibGradleVersionInspectionKt.getResolvedKotlinStdlibVersionByModuleData(moduleNode, CollectionsKt.listOf(it.getKey())) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            TargetPlatformKind targetPlatformKind = (TargetPlatformKind)it.getValue();
            collection.add(targetPlatformKind);
        }
        List detectedPlatforms = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        TargetPlatformKind targetPlatformKind = (TargetPlatformKind)CollectionsKt.singleOrNull((List)detectedPlatforms);
        if (targetPlatformKind == null) {
            Object v1;
            block4: {
                $receiver$iv = detectedPlatforms;
                for (Object element$iv : $receiver$iv) {
                    TargetPlatformKind it2 = (TargetPlatformKind)element$iv;
                    if (!(Intrinsics.areEqual((Object)it2, (Object)TargetPlatformKind.Common.INSTANCE) ^ true)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            targetPlatformKind = v1;
        }
        return targetPlatformKind;
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinFacet configureFacetByGradleModule(DataNode<ModuleData> moduleNode, DataNode<GradleSourceSetData> sourceSetNode, Module ideModule, IdeModifiableModelsProvider modelsProvider) {
        ArgsInfo argsInfo;
        Object object;
        KotlinFacet kotlinFacet;
        block14: {
            block13: {
                Object object2;
                Object it;
                String string;
                TargetPlatformKind<?> platformKind;
                NodeWithData facet2;
                NodeWithData p1;
                if (!KotlinGradleProjectResolverExtensionKt.isResolved(moduleNode).booleanValue()) {
                    return null;
                }
                if (!KotlinGradleProjectResolverExtensionKt.getHasKotlinPlugin(moduleNode).booleanValue()) {
                    ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(ideModule);
                    KotlinFacet facet2 = (KotlinFacet)facetModel.getFacetByType(KotlinFacetType.Companion.getTYPE_ID());
                    if (facet2 != null) {
                        facetModel.removeFacet((Facet)facet2);
                    }
                    return null;
                }
                Key key = BuildScriptClasspathData.KEY;
                Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"BuildScriptClasspathData.KEY");
                Object object3 = (NodeWithData)CollectionsKt.firstOrNull(KotlinGradleInspectionVisitorKt.findAll(moduleNode, key));
                if (object3 == null || (object3 = (BuildScriptClasspathData)((NodeWithData)object3).getData()) == null || (object3 = KotlinGradleInspectionVisitorKt.findKotlinPluginVersion((BuildScriptClasspathData)(p1 = (facet2 = object3)))) == null) {
                    return null;
                }
                Object compilerVersion = object3;
                TargetPlatformKind<?> targetPlatformKind = KotlinGradleSourceSetDataServiceKt.detectPlatformByPlugin(moduleNode);
                if (targetPlatformKind == null) {
                    targetPlatformKind = platformKind = KotlinGradleSourceSetDataServiceKt.detectPlatformByLibrary(moduleNode);
                }
                if ((string = KotlinGradleProjectResolverExtensionKt.getCoroutines(moduleNode)) == null) {
                    Project project = ideModule.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"ideModule.project");
                    string = KotlinGradleSourceSetDataServiceKt.findKotlinCoroutinesProperty(project);
                }
                LanguageFeature.State coroutinesProperty = CoroutineSupport.INSTANCE.byCompilerArgument(string);
                kotlinFacet = FacetUtilsKt.getOrCreateFacet$default(ideModule, modelsProvider, false, false, 4, null);
                FacetUtilsKt.configureFacet(kotlinFacet, (String)compilerVersion, coroutinesProperty, platformKind, modelsProvider);
                object = sourceSetNode;
                if (object == null || (object = (GradleSourceSetData)object.getData()) == null || (object = object.getId()) == null) break block13;
                Object object4 = it = (object2 = object);
                int n = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)it), (char)':', (int)0, (boolean)false, (int)6, null) + 1;
                Object object5 = object4;
                if (object5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)object5).substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                object = string2;
                if (string2 != null) break block14;
            }
            object = "main";
        }
        GradleSourceSetData sourceSetName = object;
        Map<String, ArgsInfo> map2 = KotlinGradleProjectResolverExtensionKt.getCompilerArgumentsBySourceSet(moduleNode);
        ArgsInfo argsInfo2 = argsInfo = map2 != null ? map2.get(sourceSetName) : null;
        if (argsInfo != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            List currentCompilerArguments = argsInfo.getCurrentArguments();
            List defaultCompilerArguments = argsInfo.getDefaultArguments();
            Iterable iterable = $receiver$iv = (Iterable)argsInfo.getDependencyClasspath();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string3 = PathUtil.toSystemIndependentName((String)it);
                collection.add(string3);
            }
            List dependencyClasspath = (List)destination$iv$iv;
            Collection collection = currentCompilerArguments;
            if (!collection.isEmpty()) {
                FacetUtilsKt.parseCompilerArgumentsToFacet(currentCompilerArguments, defaultCompilerArguments, kotlinFacet, modelsProvider);
            }
            KotlinGradleSourceSetDataServiceKt.adjustClasspath(kotlinFacet, dependencyClasspath);
        }
        return kotlinFacet;
    }

    private static final void adjustClasspath(KotlinFacet kotlinFacet, List<String> dependencyClasspath) {
        String string;
        boolean bl;
        Object fullClasspath;
        K2JVMCompilerArguments arguments2;
        block10: {
            Object object;
            block9: {
                if (dependencyClasspath.isEmpty()) {
                    return;
                }
                CommonCompilerArguments commonCompilerArguments = ((KotlinFacetConfiguration)kotlinFacet.getConfiguration()).getSettings().getCompilerArguments();
                if (!(commonCompilerArguments instanceof K2JVMCompilerArguments)) {
                    commonCompilerArguments = null;
                }
                K2JVMCompilerArguments k2JVMCompilerArguments = (K2JVMCompilerArguments)commonCompilerArguments;
                if (k2JVMCompilerArguments == null) {
                    return;
                }
                arguments2 = k2JVMCompilerArguments;
                object = arguments2.getClasspath();
                if (object == null) break block9;
                CharSequence charSequence = (CharSequence)object;
                String[] stringArray = new String[1];
                String string2 = File.pathSeparator;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File.pathSeparator");
                stringArray[0] = string2;
                object = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                if (object != null) break block10;
            }
            object = fullClasspath = CollectionsKt.emptyList();
        }
        if (fullClasspath.isEmpty()) {
            return;
        }
        List newClasspath = CollectionsKt.minus((Iterable)((Iterable)fullClasspath), (Iterable)dependencyClasspath);
        Collection collection = newClasspath;
        K2JVMCompilerArguments k2JVMCompilerArguments = arguments2;
        boolean bl2 = bl = !collection.isEmpty();
        if (bl) {
            Iterable iterable = newClasspath;
            String string3 = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"File.pathSeparator");
            string = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string3, null, null, (int)0, null, null, (int)62, null);
        } else {
            string = null;
        }
        k2JVMCompilerArguments.setClasspath(string);
    }

    private static final String findKotlinCoroutinesProperty(Project project) {
        for (String propertyFileName : gradlePropertyFiles) {
            String string;
            VirtualFile propertyFile;
            if (project.getBaseDir().findChild(propertyFileName) == null) {
                continue;
            }
            Properties properties2 = new Properties();
            properties2.load(propertyFile.getInputStream());
            String string2 = properties2.getProperty("kotlin.coroutines");
            if (string2 == null) continue;
            String it = string = string2;
            return it;
        }
        return CoroutineSupport.INSTANCE.getCompilerArgument(LanguageFeature.Coroutines.getDefaultState());
    }

    @Nullable
    public static final /* synthetic */ KotlinFacet access$configureFacetByGradleModule(@NotNull DataNode moduleNode, @Nullable DataNode sourceSetNode, @NotNull Module ideModule, @NotNull IdeModifiableModelsProvider modelsProvider) {
        return KotlinGradleSourceSetDataServiceKt.configureFacetByGradleModule((DataNode<ModuleData>)moduleNode, (DataNode<GradleSourceSetData>)sourceSetNode, ideModule, modelsProvider);
    }
}

