/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.codegen.inline.SMAPKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.stepping.Action;
import org.jetbrains.kotlin.idea.debugger.stepping.DexBytecode;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinSteppingCommandProvider;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCallImpl;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\u00a8\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a*\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u001a \u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002\u001a\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00012\u0006\u0010$\u001a\u00020%\u001a.\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00012\b\u0010-\u001a\u0004\u0018\u00010\u0011\u001a&\u0010.\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020%2\u0006\u00102\u001a\u00020\u0007\u001a<\u0010.\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u0002070\u00012\u0006\u00101\u001a\u00020%2\u0006\u00102\u001a\u00020\u0007\u001a\u0016\u00108\u001a\u00020\u0007*\u0004\u0018\u00010\u00132\u0006\u00109\u001a\u00020\u0013H\u0002\u001a6\u0010:\u001a\u0004\u0018\u00010;*\u00020+2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020)0\u00012\u0018\u0010=\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00070>H\u0002\u001a*\u0010?\u001a\u0004\u0018\u00010;*\u00020+2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020)0\u00012\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0001H\u0002\u001a$\u0010A\u001a\u0004\u0018\u00010;*\u00020+2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020)0\u00012\u0006\u0010B\u001a\u00020\u0011H\u0002\u00a8\u0006C"}, d2={"findCallsOnPosition", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "filter", "Lkotlin/Function1;", "", "findReturnFromDexBytecode", "", "method", "Lcom/sun/jdi/Method;", "getArgumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "it", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "getInlineArgumentIfAny", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "elementAt", "Lcom/intellij/psi/PsiElement;", "getInlineArgumentsCallsIfAny", "declarationDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getInlineArgumentsIfAny", "Lorg/jetbrains/kotlin/psi/KtFunction;", "inlineFunctionCalls", "getInlineCallFunctionArgumentsIfAny", "getInlineFunctionCallsIfAny", "getInlineFunctionsIfAny", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "offset", "", "getInlineRangeLocalVariables", "Lcom/sun/jdi/LocalVariable;", "stackFrame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "getStepOutAction", "Lorg/jetbrains/kotlin/idea/debugger/stepping/Action;", "location", "Lcom/sun/jdi/Location;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "inlineFunctions", "inlinedArgument", "getStepOverAction", "kotlinSourcePosition", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinSteppingCommandProvider$KotlinSourcePosition;", "frameProxy", "isDexDebug", "sourceFile", "range", "Lkotlin/ranges/IntRange;", "inlineFunctionArguments", "Lorg/jetbrains/kotlin/psi/KtElement;", "contains", "element", "getNextPositionWithFilter", "Lcom/intellij/xdebugger/impl/XSourcePositionImpl;", "locations", "skip", "Lkotlin/Function2;", "getXPositionForStepOutFromInlineFunction", "inlineFunctionsToSkip", "getXPositionForStepOutFromInlinedArgument", "inlinedArgumentToSkip", "idea"})
public final class KotlinSteppingCommandProviderKt {
    private static final boolean contains(@Nullable PsiElement $receiver, PsiElement element3) {
        PsiElement psiElement2 = $receiver;
        return psiElement2 != null && (psiElement2 = psiElement2.getTextRange()) != null ? psiElement2.contains(element3.getTextRange()) : false;
    }

    private static final List<KtFunction> getInlineCallFunctionArgumentsIfAny(SourcePosition sourcePosition) {
        List<KtCallExpression> inlineFunctionCalls = KotlinSteppingCommandProviderKt.getInlineFunctionCallsIfAny(sourcePosition);
        return KotlinSteppingCommandProviderKt.getInlineArgumentsIfAny(inlineFunctionCalls);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KtNamedFunction> getInlineFunctionsIfAny(KtFile file2, int offset2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        void $receiver$iv2;
        PsiElement elementAt;
        PsiElement psiElement2 = file2.findElementAt(offset2);
        if (psiElement2 == null) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        PsiElement psiElement3 = elementAt = psiElement2;
        boolean strict$iv = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtNamedFunction.class, (boolean)strict$iv);
        if (ktNamedFunction == null) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        KtNamedFunction containingFunction = ktNamedFunction;
        DeclarationDescriptor descriptor2 = ResolutionUtils.resolveToDescriptor$default(containingFunction, null, 1, null);
        if (!InlineUtil.isInline(descriptor2)) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        Iterable $i$f$getParentOfType = $receiver$iv = (Iterable)DebuggerUtils.INSTANCE.analyzeElementWithInline(containingFunction, false);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KtNamedFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KtFunction> getInlineArgumentsIfAny(List<? extends KtCallExpression> inlineFunctionCalls) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)inlineFunctionCalls;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Iterable $receiver$iv$iv2;
            Iterable $receiver$iv2;
            KtCallExpression it = (KtCallExpression)element$iv$iv;
            Iterable iterable2 = it.getValueArguments();
            void var8_8 = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void p1;
                ValueArgument valueArgument = (ValueArgument)item$iv$iv;
                Collection collection = destination$iv$iv2;
                KtExpression ktExpression = KotlinSteppingCommandProviderKt.getArgumentExpression((ValueArgument)p1);
                collection.add(ktExpression);
            }
            $receiver$iv2 = (List)destination$iv$iv2;
            $receiver$iv$iv2 = $receiver$iv2;
            destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv2) {
                if (!(element$iv$iv2 instanceof KtFunction)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)var3_3;
    }

    private static final KtExpression getArgumentExpression(ValueArgument it) {
        KtExpression ktExpression;
        KtExpression ktExpression2 = it.getArgumentExpression();
        if (!(ktExpression2 instanceof KtLambdaExpression)) {
            ktExpression2 = null;
        }
        return (ktExpression = (KtLambdaExpression)ktExpression2) != null && (ktExpression = ktExpression.getFunctionLiteral()) != null ? (KtExpression)ktExpression : it.getArgumentExpression();
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KtCallExpression> getInlineArgumentsCallsIfAny(SourcePosition sourcePosition, DeclarationDescriptor declarationDescriptor) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        if (!(declarationDescriptor instanceof CallableDescriptor)) {
            return null;
        }
        Iterable iterable = $receiver$iv = (Iterable)((CallableDescriptor)declarationDescriptor).getValueParameters();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            if (!FunctionTypesKt.isFunctionType(it.getType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set valueParameters = kotlin.collections.CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (valueParameters.isEmpty()) {
            return null;
        }
        Function1<KtCallExpression, Boolean> isCallOfArgument$ = new Function1<KtCallExpression, Boolean>(valueParameters){
            final /* synthetic */ Set $valueParameters;

            public final boolean invoke(@NotNull KtCallExpression ktCallExpression) {
                Intrinsics.checkParameterIsNotNull((Object)ktCallExpression, (String)"ktCallExpression");
                BindingContext context = ResolutionUtils.analyze(ktCallExpression, BodyResolveMode.PARTIAL);
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktCallExpression, context);
                if (!(resolvedCall2 instanceof VariableAsFunctionResolvedCallImpl)) {
                    resolvedCall2 = null;
                }
                VariableAsFunctionResolvedCallImpl variableAsFunctionResolvedCallImpl = (VariableAsFunctionResolvedCallImpl)resolvedCall2;
                if (variableAsFunctionResolvedCallImpl == null) {
                    return false;
                }
                VariableAsFunctionResolvedCallImpl resolvedCall3 = variableAsFunctionResolvedCallImpl;
                VariableDescriptor candidateDescriptor = (VariableDescriptor)resolvedCall3.getVariableCall().getCandidateDescriptor();
                return kotlin.collections.CollectionsKt.contains((Iterable)this.$valueParameters, (Object)candidateDescriptor);
            }
            {
                this.$valueParameters = set2;
                super(1);
            }
        };
        return KotlinSteppingCommandProviderKt.findCallsOnPosition(sourcePosition, (Function1<? super KtCallExpression, Boolean>)((Function1)new Function1<KtCallExpression, Boolean>(isCallOfArgument$){
            final /* synthetic */ getInlineArgumentsCallsIfAny.1 $isCallOfArgument;

            public final boolean invoke(@NotNull KtCallExpression p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return this.$isCallOfArgument.invoke(p1);
            }

            public final KDeclarationContainer getOwner() {
                return null;
            }

            public final String getName() {
                return "isCallOfArgument";
            }

            public final String getSignature() {
                return "invoke(Lorg/jetbrains/kotlin/psi/KtCallExpression;)Z";
            }
            {
                this.$isCallOfArgument = var1_1;
                super(1);
            }
        }));
    }

    private static final List<KtCallExpression> getInlineFunctionCallsIfAny(SourcePosition sourcePosition) {
        getInlineFunctionCallsIfAny.1 isInlineCall$ = getInlineFunctionCallsIfAny.1.INSTANCE;
        return KotlinSteppingCommandProviderKt.findCallsOnPosition(sourcePosition, (Function1<? super KtCallExpression, Boolean>)((Function1)getInlineFunctionCallsIfAny.2.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KtCallExpression> findCallsOnPosition(SourcePosition sourcePosition, Function1<? super KtCallExpression, Boolean> filter2) {
        void $receiver$iv$iv;
        KtCallExpression it;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv;
        PsiFile psiFile = sourcePosition.getFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        KtFile file2 = ktFile;
        int lineNumber = sourcePosition.getLine();
        PsiElement lineElement = DebuggerUtilKt.findElementAtLine(file2, lineNumber);
        if (!(lineElement instanceof KtElement)) {
            KtCallExpression call2;
            if (lineElement != null && (call2 = DebuggerUtilKt.findCallByEndToken(lineElement)) != null && ((Boolean)filter2.invoke((Object)call2)).booleanValue()) {
                return kotlin.collections.CollectionsKt.listOf((Object)call2);
            }
            return kotlin.collections.CollectionsKt.emptyList();
        }
        int start = PsiUtilsKt.getStartOffset(lineElement);
        int end = PsiUtilsKt.getEndOffset(lineElement);
        Iterable iterable = CodeInsightUtils.findElementsOfClassInRange((PsiFile)file2, start, end, KtExpression.class);
        void var9_9 = $receiver$iv;
        Iterable destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            PsiElement psiElement2 = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v2 = it;
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent((KtExpression)v2);
            collection.add(ktExpression);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            if (!(element$iv$iv instanceof KtCallExpression)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            it = (KtCallExpression)element$iv$iv;
            if (!((Boolean)filter2.invoke((Object)it)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set allFilteredCalls = kotlin.collections.CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        int $receiver$iv$iv22 = lineNumber;
        IntRange linesRange = new IntRange($receiver$iv$iv22, lineNumber);
        Iterable $receiver$iv2 = allFilteredCalls;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtCallExpression it2 = (KtCallExpression)element$iv$iv;
            boolean shouldInclude = linesRange.contains(KotlinRefactoringUtilKt.getLineNumber$default((PsiElement)it2, false, 1, null));
            if (shouldInclude) {
                int n = Math.min(linesRange.getStart(), KotlinRefactoringUtilKt.getLineNumber$default((PsiElement)it2, false, 1, null));
                linesRange = new IntRange(n, Math.max(linesRange.getEndInclusive(), KotlinRefactoringUtilKt.getLineNumber((PsiElement)it2, false)));
            }
            if (!shouldInclude) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    @NotNull
    public static final Action getStepOverAction(@NotNull Location location2, @NotNull KotlinSteppingCommandProvider.KotlinSourcePosition kotlinSourcePosition, @NotNull StackFrameProxyImpl frameProxy, boolean isDexDebug) {
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)kotlinSourcePosition, (String)"kotlinSourcePosition");
        Intrinsics.checkParameterIsNotNull((Object)frameProxy, (String)"frameProxy");
        List inlineArgumentsToSkip2 = (List)ApplicationUtilsKt.runReadAction((Function0)new Function0<List<? extends KtFunction>>(kotlinSourcePosition){
            final /* synthetic */ KotlinSteppingCommandProvider.KotlinSourcePosition $kotlinSourcePosition;

            @NotNull
            public final List<KtFunction> invoke() {
                return KotlinSteppingCommandProviderKt.access$getInlineCallFunctionArgumentsIfAny(this.$kotlinSourcePosition.getSourcePosition());
            }
            {
                this.$kotlinSourcePosition = kotlinSourcePosition;
                super(0);
            }
        });
        return KotlinSteppingCommandProviderKt.getStepOverAction(location2, kotlinSourcePosition.getFile(), kotlinSourcePosition.getLinesRange(), inlineArgumentsToSkip2, frameProxy, isDexDebug);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final Action getStepOverAction(@NotNull Location location, @NotNull KtFile sourceFile, @NotNull IntRange range, @NotNull List<? extends KtElement> inlineFunctionArguments, @NotNull StackFrameProxyImpl frameProxy, boolean isDexDebug) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        Intrinsics.checkParameterIsNotNull(inlineFunctionArguments, (String)"inlineFunctionArguments");
        Intrinsics.checkParameterIsNotNull((Object)frameProxy, (String)"frameProxy");
        if (location.declaringType() == null) {
            return new Action.STEP_OVER();
        }
        project = sourceFile.getProject();
        methodLocations = location.method().allLineLocations();
        locationsLineAndFile = CollectionsKt.keysToMap((Iterable)methodLocations, (Function1)new Function1<Location, Pair<? extends Integer, ? extends KtFile>>(isDexDebug, project){
            final /* synthetic */ boolean $isDexDebug;
            final /* synthetic */ Project $project;

            @NotNull
            public final Pair<Integer, KtFile> invoke(Location it) {
                Location location2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)location2, (String)"it");
                Project project = this.$project;
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                return NoStrataPositionManagerHelperKt.ktLocationInfo$default(location2, this.$isDexDebug, project, true, null, 16, null);
            }
            {
                this.$isDexDebug = bl;
                this.$project = project;
                super(1);
            }
        });
        ktLineNumber$ = new Function1<Location, Integer>(locationsLineAndFile, isDexDebug, project){
            final /* synthetic */ Map $locationsLineAndFile;
            final /* synthetic */ boolean $isDexDebug;
            final /* synthetic */ Project $project;

            public final int invoke(@NotNull Location $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Pair pair2 = (Pair)this.$locationsLineAndFile.get($receiver);
                if (pair2 == null) {
                    Project project = this.$project;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                    pair2 = NoStrataPositionManagerHelperKt.ktLocationInfo$default($receiver, this.$isDexDebug, project, true, null, 16, null);
                }
                return ((Number)pair2.getFirst()).intValue();
            }
            {
                this.$locationsLineAndFile = map2;
                this.$isDexDebug = bl;
                this.$project = project;
                super(1);
            }
        };
        ktFileName$ = new Function1<Location, String>(locationsLineAndFile, isDexDebug, project){
            final /* synthetic */ Map $locationsLineAndFile;
            final /* synthetic */ boolean $isDexDebug;
            final /* synthetic */ Project $project;

            @NotNull
            public final String invoke(@NotNull Location $receiver) {
                KtFile ktFile;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Pair pair2 = (Pair)this.$locationsLineAndFile.get($receiver);
                if (pair2 == null) {
                    Project project = this.$project;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                    pair2 = NoStrataPositionManagerHelperKt.ktLocationInfo$default($receiver, this.$isDexDebug, project, true, null, 16, null);
                }
                if ((object = (ktFile = (KtFile)pair2.getSecond())) == null || (object = ((KtFile)object).getName()) == null) {
                    String string = $receiver.sourceName(SMAPKt.getKOTLIN_STRATA_NAME());
                    object = string;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.sourceName(KOTLIN_STRATA_NAME)");
                }
                return object;
            }
            {
                this.$locationsLineAndFile = map2;
                this.$isDexDebug = bl;
                this.$project = project;
                super(1);
            }
        };
        isLocationSuitable$ = new Function1<Location, Boolean>(location, ktLineNumber$, range, sourceFile, ktFileName$){
            final /* synthetic */ Location $location;
            final /* synthetic */ getStepOverAction.1 $ktLineNumber;
            final /* synthetic */ IntRange $range;
            final /* synthetic */ KtFile $sourceFile;
            final /* synthetic */ getStepOverAction.2 $ktFileName;

            public final boolean invoke(@NotNull Location nextLocation) {
                Intrinsics.checkParameterIsNotNull((Object)nextLocation, (String)"nextLocation");
                if (Intrinsics.areEqual((Object)nextLocation.method(), (Object)this.$location.method()) ^ true) {
                    return false;
                }
                int ktLineNumber = this.$ktLineNumber.invoke(nextLocation);
                if (!this.$range.contains(ktLineNumber)) {
                    return false;
                }
                try {
                    return Intrinsics.areEqual((Object)this.$ktFileName.invoke(nextLocation), (Object)this.$sourceFile.getName());
                }
                catch (AbsentInformationException e) {
                    return true;
                }
            }
            {
                this.$location = location2;
                this.$ktLineNumber = var2_2;
                this.$range = intRange;
                this.$sourceFile = ktFile;
                this.$ktFileName = var5_5;
                super(1);
            }
        };
        isBackEdgeLocation$ = new Function0<Boolean>(methodLocations, location, isLocationSuitable$, ktLineNumber$){
            final /* synthetic */ List $methodLocations;
            final /* synthetic */ Location $location;
            final /* synthetic */ getStepOverAction.3 $isLocationSuitable;
            final /* synthetic */ getStepOverAction.1 $ktLineNumber;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke() {
                void $receiver$iv$iv;
                Location it;
                Iterable $receiver$iv = kotlin.collections.CollectionsKt.reversed((Iterable)this.$methodLocations);
                boolean yielding$iv22 = false;
                ArrayList<T> list$iv = new ArrayList<T>();
                for (T item$iv : $receiver$iv) {
                    if (yielding$iv22) {
                        list$iv.add(item$iv);
                        continue;
                    }
                    it = (Location)item$iv;
                    if (Intrinsics.areEqual((Object)it, (Object)this.$location) ^ true) continue;
                    list$iv.add(item$iv);
                    yielding$iv22 = true;
                }
                $receiver$iv = kotlin.collections.CollectionsKt.drop((Iterable)list$iv, (int)1);
                Iterable yielding$iv22 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    Location p1 = (Location)element$iv$iv;
                    if (!this.$isLocationSuitable.invoke(p1)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                boolean yielding$iv = false;
                list$iv = new ArrayList<E>();
                for (T item$iv : $receiver$iv) {
                    if (yielding$iv) {
                        list$iv.add(item$iv);
                        continue;
                    }
                    it = (Location)item$iv;
                    if (this.$ktLineNumber.invoke(it) == this.$ktLineNumber.invoke(this.$location)) continue;
                    list$iv.add(item$iv);
                    yielding$iv = true;
                }
                Location previousSuitableLocation = (Location)kotlin.collections.CollectionsKt.firstOrNull((List)list$iv);
                return previousSuitableLocation != null && this.$ktLineNumber.invoke(previousSuitableLocation) > this.$ktLineNumber.invoke(this.$location);
            }
            {
                this.$methodLocations = list2;
                this.$location = location2;
                this.$isLocationSuitable = var3_3;
                this.$ktLineNumber = var4_4;
                super(0);
            }
        };
        if (isBackEdgeLocation$.invoke()) {
            block25: {
                var14_13 = methodLocations;
                var15_15 = $receiver$iv;
                destination$iv$iv = new ArrayList<E>();
                var17_17 = $receiver$iv$iv.iterator();
                while (var17_17.hasNext()) {
                    element$iv$iv = var17_17.next();
                    p1 = (Location)element$iv$iv;
                    if (!isLocationSuitable$.invoke(p1)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (T element$iv : $receiver$iv) {
                    it = (Location)element$iv;
                    if (!(ktLineNumber$.invoke(it) == ktLineNumber$.invoke(location))) continue;
                    v0 = element$iv;
                    break block25;
                }
                v0 = null;
            }
            if ((v1 = (Location)v0) == null) {
                v1 = location;
            }
        } else {
            v1 = location;
        }
        patchedLocation = v1;
        patchedLineNumber = ktLineNumber$.invoke(patchedLocation);
        lambdaArgumentRanges = (List)ApplicationUtilsKt.runReadAction((Function0)new Function0<List<? extends IntRange>>(inlineFunctionArguments){
            final /* synthetic */ List $inlineFunctionArguments;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<IntRange> invoke() {
                void var3_3;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)this.$inlineFunctionArguments;
                Collection destination$iv$iv = new ArrayList<E>(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    KtElement ktElement = (KtElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    int startLineNumber = KotlinRefactoringUtilKt.getLineNumber((PsiElement)it, true) + 1;
                    int endLineNumber = KotlinRefactoringUtilKt.getLineNumber((PsiElement)it, false) + 1;
                    int n = startLineNumber;
                    IntRange intRange = new IntRange(n, endLineNumber);
                    collection.add(intRange);
                }
                return (List)var3_3;
            }
            {
                this.$inlineFunctionArguments = list2;
                super(0);
            }
        });
        inlineRangeVariables = KotlinSteppingCommandProviderKt.getInlineRangeLocalVariables(frameProxy);
        $i$a$2$firstOrNull = methodLocations;
        yielding$iv = false;
        list$iv = new ArrayList<T>();
        for (Object item$iv : $receiver$iv) {
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            it = (Location)item$iv;
            if (Intrinsics.areEqual((Object)it, (Object)patchedLocation) ^ true) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        $receiver$iv = kotlin.collections.CollectionsKt.drop((Iterable)list$iv, (int)1);
        yielding$iv = false;
        list$iv = new ArrayList<E>();
        for (Object item$iv : $receiver$iv) {
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            it = (Location)item$iv;
            if (ktLineNumber$.invoke((Location)it) == patchedLineNumber) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        $receiver$iv = list$iv;
        list$iv = new ArrayList<Object>();
        for (Object item$iv : $receiver$iv) {
            block26: {
                v2 = loc = (Location)item$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"loc");
                if (!isLocationSuitable$.invoke(v2)) ** GOTO lbl-1000
                $receiver$iv = lambdaArgumentRanges;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    v3 = false;
                } else {
                    for (T element$iv : $receiver$iv) {
                        it = (IntRange)element$iv;
                        if (!it.contains(ktLineNumber$.invoke(loc))) continue;
                        v3 = true;
                        break block26;
                    }
                    v3 = false;
                }
            }
            if (v3) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else {
                v4 = false;
            }
            if (!v4) break;
            list$iv.add(item$iv);
        }
        $receiver$iv = list$iv;
        yielding$iv = false;
        list$iv = new ArrayList<T>();
        for (Object item$iv : $receiver$iv) {
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            it = (Location)item$iv;
            if (ktLineNumber$.invoke((Location)it) == patchedLineNumber) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        probablyInlinedLocations = list$iv;
        if (!probablyInlinedLocations.isEmpty()) {
            if (isDexDebug) {
                method = location.method();
                locationsOfLine = method.locationsOfLine(range.getLast());
                item$iv = locationsOfLine;
                if (item$iv.isEmpty() == false) {
                    $receiver$iv = locationsOfLine;
                    it = $receiver$iv;
                    destination$iv$iv = new ArrayList<E>(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        $i$a$1$any = (Location)item$iv$iv;
                        var31_33 = destination$iv$iv;
                        var32_34 = it.codeIndex();
                        var31_33.add(var32_34);
                    }
                    v5 = (Long)kotlin.collections.CollectionsKt.max((Iterable)((List)destination$iv$iv));
                    v6 = v5 != null ? v5 : -1L;
                } else {
                    v7 = location.method();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"location.method()");
                    v6 = KotlinSteppingCommandProviderKt.findReturnFromDexBytecode(v7);
                }
            } else {
                v6 = -1L;
            }
            returnCodeIndex = v6;
            method = probablyInlinedLocations;
            var35_35 = patchedLineNumber;
            var34_36 = v8;
            var33_37 = v8;
            var32_34 = v9;
            var31_33 = v9;
            locationsOfLine = $receiver$iv;
            destination$iv$iv = new ArrayList<E>(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (T item$iv$iv : $receiver$iv$iv) {
                $i$f$dropWhile = (Location)item$iv$iv;
                var36_38 = destination$iv$iv;
                var37_39 = ktLineNumber$.invoke((Location)it);
                var36_38.add(var37_39);
            }
            var36_38 = (List)destination$iv$iv;
            var34_36(var35_35, kotlin.collections.CollectionsKt.toSet((Iterable)var36_38), inlineRangeVariables, isDexDebug, returnCodeIndex);
            var32_34(var33_37);
            return (Action)var31_33;
        }
        return new Action.STEP_OVER();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Action getStepOutAction(@NotNull Location location2, @NotNull SuspendContextImpl suspendContext, @NotNull List<? extends KtNamedFunction> inlineFunctions, @Nullable KtFunctionLiteral inlinedArgument) {
        XSourcePositionImpl it;
        XSourcePositionImpl position2;
        void $receiver$iv$iv;
        Location it2;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull(inlineFunctions, (String)"inlineFunctions");
        ReferenceType referenceType = location2.declaringType();
        if (referenceType == null) {
            return new Action.STEP_OUT();
        }
        ReferenceType computedReferenceType = referenceType;
        List<Location> locations = computedReferenceType.allLineLocations();
        Iterable iterable = locations;
        boolean yielding$iv22 = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $receiver$iv) {
            if (yielding$iv22) {
                list$iv.add(item$iv);
                continue;
            }
            it2 = (Location)item$iv;
            if (Intrinsics.areEqual((Object)it2, (Object)location2) ^ true) continue;
            list$iv.add(item$iv);
            yielding$iv22 = true;
        }
        $receiver$iv = kotlin.collections.CollectionsKt.drop((Iterable)list$iv, (int)1);
        Iterable yielding$iv22 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it2 = (Location)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it2.method(), (Object)location2.method())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        boolean yielding$iv = false;
        list$iv = new ArrayList();
        for (Object item$iv : $receiver$iv) {
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            it2 = (Location)item$iv;
            if (it2.lineNumber() == location2.lineNumber()) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        List nextLineLocations = list$iv;
        $receiver$iv = inlineFunctions;
        if (!$receiver$iv.isEmpty()) {
            Action action2;
            XSourcePositionImpl xSourcePositionImpl = position2 = KotlinSteppingCommandProviderKt.getXPositionForStepOutFromInlineFunction(suspendContext, nextLineLocations, inlineFunctions);
            if (xSourcePositionImpl != null) {
                XSourcePositionImpl xSourcePositionImpl2;
                it = xSourcePositionImpl2 = xSourcePositionImpl;
                action2 = new Action.RUN_TO_CURSOR(it);
            } else {
                action2 = new Action.STEP_OVER();
            }
            return action2;
        }
        if (inlinedArgument != null) {
            Action action3;
            XSourcePositionImpl xSourcePositionImpl = position2 = KotlinSteppingCommandProviderKt.getXPositionForStepOutFromInlinedArgument(suspendContext, nextLineLocations, inlinedArgument);
            if (xSourcePositionImpl != null) {
                XSourcePositionImpl xSourcePositionImpl3;
                it = xSourcePositionImpl3 = xSourcePositionImpl;
                action3 = new Action.RUN_TO_CURSOR(it);
            } else {
                action3 = new Action.STEP_OVER();
            }
            return action3;
        }
        return new Action.STEP_OVER();
    }

    private static final XSourcePositionImpl getXPositionForStepOutFromInlineFunction(@NotNull SuspendContextImpl $receiver, List<? extends Location> locations, List<? extends KtNamedFunction> inlineFunctionsToSkip) {
        return KotlinSteppingCommandProviderKt.getNextPositionWithFilter($receiver, locations, (Function2<? super Integer, ? super PsiElement, Boolean>)((Function2)new Function2<Integer, PsiElement, Boolean>(inlineFunctionsToSkip){
            final /* synthetic */ List $inlineFunctionsToSkip;

            public final boolean invoke(int offset2, @NotNull PsiElement elementAt) {
                boolean bl;
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)elementAt, (String)"elementAt");
                    Iterable $receiver$iv = this.$inlineFunctionsToSkip;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            KtNamedFunction it = (KtNamedFunction)element$iv;
                            if (!it.getTextRange().contains(offset2)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return true;
                }
                return KotlinSteppingCommandProviderKt.access$getInlineArgumentIfAny(elementAt) != null;
            }
            {
                this.$inlineFunctionsToSkip = list2;
                super(2);
            }
        }));
    }

    private static final XSourcePositionImpl getXPositionForStepOutFromInlinedArgument(@NotNull SuspendContextImpl $receiver, List<? extends Location> locations, KtFunctionLiteral inlinedArgumentToSkip) {
        return KotlinSteppingCommandProviderKt.getNextPositionWithFilter($receiver, locations, (Function2<? super Integer, ? super PsiElement, Boolean>)((Function2)new Function2<Integer, PsiElement, Boolean>(inlinedArgumentToSkip){
            final /* synthetic */ KtFunctionLiteral $inlinedArgumentToSkip;

            public final boolean invoke(int offset2, @NotNull PsiElement $noName_1) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                return this.$inlinedArgumentToSkip.getTextRange().contains(offset2);
            }
            {
                this.$inlinedArgumentToSkip = ktFunctionLiteral;
                super(2);
            }
        }));
    }

    private static final XSourcePositionImpl getNextPositionWithFilter(@NotNull SuspendContextImpl $receiver, List<? extends Location> locations, Function2<? super Integer, ? super PsiElement, Boolean> skip2) {
        for (Location location2 : locations) {
            XSourcePositionImpl position2 = (XSourcePositionImpl)ApplicationUtilsKt.runReadAction((Function0)new Function0<XSourcePositionImpl>($receiver, location2, skip2){
                final /* synthetic */ SuspendContextImpl receiver$0;
                final /* synthetic */ Location $location;
                final /* synthetic */ Function2 $skip;

                @Nullable
                public final XSourcePositionImpl invoke() {
                    SourcePosition sourcePosition;
                    try {
                        sourcePosition = this.receiver$0.getDebugProcess().getPositionManager().getSourcePosition(this.$location);
                    }
                    catch (NoDataException e) {
                        sourcePosition = null;
                    }
                    SourcePosition sourcePosition2 = sourcePosition;
                    if (sourcePosition2 == null) {
                        return null;
                    }
                    SourcePosition sourcePosition3 = sourcePosition2;
                    PsiFile psiFile = sourcePosition3.getFile();
                    if (!(psiFile instanceof KtFile)) {
                        psiFile = null;
                    }
                    KtFile ktFile = (KtFile)psiFile;
                    if (ktFile == null) {
                        return null;
                    }
                    KtFile file2 = ktFile;
                    PsiElement psiElement2 = sourcePosition3.getElementAt();
                    if (psiElement2 == null) {
                        return null;
                    }
                    PsiElement elementAt = psiElement2;
                    int currentLine = this.$location.lineNumber() - 1;
                    Integer n = KotlinRefactoringUtilKt.getLineStartOffset((PsiFile)file2, currentLine);
                    if (n == null) {
                        return null;
                    }
                    int lineStartOffset = n;
                    if (((Boolean)this.$skip.invoke((Object)lineStartOffset, (Object)elementAt)).booleanValue()) {
                        return null;
                    }
                    return XSourcePositionImpl.createByElement((PsiElement)elementAt);
                }
                {
                    this.receiver$0 = suspendContextImpl;
                    this.$location = location2;
                    this.$skip = function2;
                    super(0);
                }
            });
            if (position2 == null) continue;
            return position2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<LocalVariable> getInlineRangeLocalVariables(@NotNull StackFrameProxyImpl stackFrame) {
        void var3_3;
        LocalVariableProxyImpl it;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)stackFrame, (String)"stackFrame");
        Iterable $receiver$iv = stackFrame.visibleVariables();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (LocalVariableProxyImpl)element$iv$iv;
            String name2 = it.name();
            if (!StringsKt.startsWith$default((String)name2, (String)"$i$f$", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (LocalVariableProxyImpl)item$iv$iv;
            Collection collection = destination$iv$iv;
            LocalVariable localVariable = it.getVariable();
            collection.add(localVariable);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final KtFunctionLiteral getInlineArgumentIfAny(PsiElement elementAt) {
        Object object;
        block5: {
            block4: {
                void $receiver$iv;
                object = elementAt;
                if (object == null) break block4;
                PsiElement psiElement2 = object;
                boolean strict$iv = false;
                object = (KtLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtLambdaExpression.class, (boolean)strict$iv);
                if (object != null) break block5;
            }
            return null;
        }
        Object functionLiteralExpression = object;
        BindingContext context = ResolutionUtils.analyze((KtElement)functionLiteralExpression, BodyResolveMode.PARTIAL);
        if (!InlineUtil.isInlinedArgument(((KtLambdaExpression)functionLiteralExpression).getFunctionLiteral(), context, false)) {
            return null;
        }
        return ((KtLambdaExpression)functionLiteralExpression).getFunctionLiteral();
    }

    private static final long findReturnFromDexBytecode(Method method) {
        List<Location> methodLocations = method.allLineLocations();
        if (methodLocations.isEmpty()) {
            return -1L;
        }
        long lastMethodCodeIndex = ((Location)kotlin.collections.CollectionsKt.last(methodLocations)).codeIndex();
        while (method.locationOfCodeIndex(lastMethodCodeIndex + 1L) != null) {
            long l = lastMethodCodeIndex;
            lastMethodCodeIndex = l + 1L;
        }
        long returnIndex = lastMethodCodeIndex + 1L;
        byte[] bytecode2 = method.bytecodes();
        int i = bytecode2.length;
        while (i >= 2) {
            byte instruction;
            block7: {
                block6: {
                    --returnIndex;
                    instruction = bytecode2[i -= 2];
                    if (instruction == DexBytecode.INSTANCE.getRETURN_VOID()) break block6;
                    if (instruction == DexBytecode.INSTANCE.getRETURN()) break block6;
                    if (instruction == DexBytecode.INSTANCE.getRETURN_WIDE()) break block6;
                    if (instruction != DexBytecode.INSTANCE.getRETURN_OBJECT()) break block7;
                }
                return returnIndex;
            }
            if (instruction == DexBytecode.INSTANCE.getMOVE()) continue;
            if (instruction == DexBytecode.INSTANCE.getGOTO()) continue;
            break;
        }
        return -1L;
    }

    @NotNull
    public static final /* synthetic */ List access$getInlineFunctionCallsIfAny(@NotNull SourcePosition sourcePosition) {
        return KotlinSteppingCommandProviderKt.getInlineFunctionCallsIfAny(sourcePosition);
    }

    @Nullable
    public static final /* synthetic */ List access$getInlineArgumentsCallsIfAny(@NotNull SourcePosition sourcePosition, @NotNull DeclarationDescriptor declarationDescriptor) {
        return KotlinSteppingCommandProviderKt.getInlineArgumentsCallsIfAny(sourcePosition, declarationDescriptor);
    }

    @NotNull
    public static final /* synthetic */ List access$getInlineFunctionsIfAny(@NotNull KtFile file2, int offset2) {
        return KotlinSteppingCommandProviderKt.getInlineFunctionsIfAny(file2, offset2);
    }

    @Nullable
    public static final /* synthetic */ KtFunctionLiteral access$getInlineArgumentIfAny(@Nullable PsiElement elementAt) {
        return KotlinSteppingCommandProviderKt.getInlineArgumentIfAny(elementAt);
    }

    @NotNull
    public static final /* synthetic */ List access$getInlineCallFunctionArgumentsIfAny(@NotNull SourcePosition sourcePosition) {
        return KotlinSteppingCommandProviderKt.getInlineCallFunctionArgumentsIfAny(sourcePosition);
    }
}

