/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.classFile;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.util.indexing.FileContent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.IDEKotlinBinaryClassCache;
import org.jetbrains.kotlin.idea.decompiler.classFile.AnnotationLoaderForClassFileStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.classFile.ClassFileDecompilerUtilKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.idea.decompiler.classFile.DirectoryBasedDataFinder;
import org.jetbrains.kotlin.idea.decompiler.classFile.KotlinClsStubBuilder$WhenMappings;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderComponents;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/classFile/KotlinClsStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "()V", "buildFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "content", "Lcom/intellij/util/indexing/FileContent;", "createStubBuilderComponents", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderComponents;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "fileContent", "", "doBuildFileStub", "Lorg/jetbrains/kotlin/psi/KtFile;", "getStubVersion", "", "Companion", "idea-analysis"})
public class KotlinClsStubBuilder
extends ClsStubBuilder {
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    public int getStubVersion() {
        return 81;
    }

    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content2) {
        VirtualFile file2;
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        VirtualFile virtualFile2 = file2 = content2.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
        if (ClassFileDecompilerUtilKt.isKotlinInternalCompiledFile(virtualFile2, content2.getContent())) {
            return null;
        }
        byte[] byArray = content2.getContent();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"content.content");
        return this.doBuildFileStub(file2, byArray);
    }

    /*
     * WARNING - void declaration
     */
    private final PsiFileStub<KtFile> doBuildFileStub(VirtualFile file2, byte[] fileContent) {
        PsiFileStub psiFileStub;
        KotlinJvmBinaryClass kotlinJvmBinaryClass = IDEKotlinBinaryClassCache.INSTANCE.getKotlinBinaryClass(file2, fileContent);
        if (kotlinJvmBinaryClass == null) {
            String string = "Can't find binary class for Kotlin file: " + file2;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KotlinJvmBinaryClass kotlinClass = kotlinJvmBinaryClass;
        KotlinClassHeader header = kotlinClass.getClassHeader();
        ClassId classId = kotlinClass.getClassId();
        FqName packageFqName = classId.getPackageFqName();
        if (!header.getMetadataVersion().isCompatible()) {
            return ClsStubBuildingKt.createIncompatibleAbiVersionFileStub();
        }
        FqName fqName2 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
        ClsStubBuilderComponents components = this.createStubBuilderComponents(file2, fqName2, fileContent);
        if (Intrinsics.areEqual((Object)((Object)header.getKind()), (Object)((Object)KotlinClassHeader.Kind.MULTIFILE_CLASS))) {
            List<KotlinJvmBinaryClass> partFiles = ClassFileDecompilerUtilKt.findMultifileClassParts(file2, classId, header);
            FqName fqName3 = classId.asSingleFqName();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"classId.asSingleFqName()");
            return ClsStubBuildingKt.createMultifileClassStub(header, partFiles, fqName3, components);
        }
        String[] annotationData = header.getData();
        if (annotationData == null) {
            Companion.getLOG().error("Corrupted kotlin header for file " + file2.getName());
            return null;
        }
        String[] strings = header.getStrings();
        if (strings == null) {
            Companion.getLOG().error("String table not found in file " + file2.getName());
            return null;
        }
        switch (KotlinClsStubBuilder$WhenMappings.$EnumSwitchMapping$0[header.getKind().ordinal()]) {
            case 1: {
                void nameResolver;
                if (classId.isLocal()) {
                    return null;
                }
                ClassData classData = JvmProtoBufUtil.readClassDataFrom(annotationData, strings);
                NameResolver nameResolver2 = classData.component1();
                ProtoBuf.Class classProto = classData.component2();
                ProtoBuf.TypeTable typeTable = classProto.getTypeTable();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"classProto.typeTable");
                ClsStubBuilderContext context = components.createContext((NameResolver)nameResolver, packageFqName, new TypeTable(typeTable));
                psiFileStub = ClsStubBuildingKt.createTopLevelClassStub(classId, classProto, new KotlinJvmBinarySourceElement(kotlinClass, null, false, 6, null), context, header.isScript());
                break;
            }
            case 2: {
                Object context = JvmProtoBufUtil.readPackageDataFrom(annotationData, strings);
                NameResolver nameResolver = ((PackageData)context).component1();
                ProtoBuf.Package packageProto = ((PackageData)context).component2();
                ProtoBuf.TypeTable typeTable = packageProto.getTypeTable();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"packageProto.typeTable");
                context = components.createContext(nameResolver, packageFqName, new TypeTable(typeTable));
                FqName fqName4 = classId.asSingleFqName();
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName4, (String)"classId.asSingleFqName()");
                psiFileStub = ClsStubBuildingKt.createFileFacadeStub(packageProto, fqName4, (ClsStubBuilderContext)context);
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Should have processed " + file2.getPath() + " with header " + header);
            }
        }
        return psiFileStub;
    }

    private final ClsStubBuilderComponents createStubBuilderComponents(VirtualFile file2, FqName packageFqName, byte[] fileContent) {
        VirtualFile virtualFile2 = file2.getParent();
        if (virtualFile2 == null) {
            Intrinsics.throwNpe();
        }
        DirectoryBasedClassFinder classFinder = new DirectoryBasedClassFinder(virtualFile2, packageFqName);
        Logger logger = Companion.getLOG();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
        DirectoryBasedDataFinder classDataFinder2 = new DirectoryBasedDataFinder(classFinder, logger);
        AnnotationLoaderForClassFileStubBuilder annotationLoader = new AnnotationLoaderForClassFileStubBuilder(classFinder, file2, fileContent);
        return new ClsStubBuilderComponents(classDataFinder2, annotationLoader, file2);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(KotlinClsStubBuilder.class);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/classFile/KotlinClsStubBuilder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "idea-analysis"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

