/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.ConstantConditionIfInspectionKt;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "RemoveFix", "SimplifyFix", "idea"})
public final class ConstantConditionIfInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public void visitIfExpression(@NotNull KtIfExpression expression2) {
                LocalQuickFix[] localQuickFixArray;
                void $receiver$iv;
                Object object;
                Collection collection;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitIfExpression(expression2);
                KtExpression ktExpression = expression2.getCondition();
                if (ktExpression == null) {
                    return;
                }
                KtExpression condition2 = ktExpression;
                BindingContext context = ResolutionUtils.analyze(condition2, BodyResolveMode.PARTIAL);
                Boolean bl = ConstantConditionIfInspectionKt.access$constantBooleanValue(condition2, context);
                if (bl == null) {
                    return;
                }
                boolean constantValue = bl;
                List fixes = new ArrayList<E>();
                if (ConstantConditionIfInspectionKt.access$branch(expression2, constantValue) != null) {
                    collection = fixes;
                    object = new SimplifyFix(constantValue, BindingContextUtilsKt.isUsedAsExpression(expression2, context));
                    collection.add(object);
                }
                if (!constantValue && expression2.getElse() == null) {
                    collection = fixes;
                    object = new RemoveFix();
                    collection.add(object);
                }
                collection = fixes;
                String string = "Condition is always '" + constantValue + '\'';
                PsiElement psiElement2 = (PsiElement)condition2;
                ProblemsHolder problemsHolder = this.$holder;
                void thisCollection$iv = $receiver$iv;
                LocalQuickFix[] localQuickFixArray2 = thisCollection$iv.toArray(new LocalQuickFix[thisCollection$iv.size()]);
                if (localQuickFixArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                LocalQuickFix[] localQuickFixArray3 = localQuickFixArray = localQuickFixArray2;
                problemsHolder.registerProblem(psiElement2, string, Arrays.copyOf(localQuickFixArray3, localQuickFixArray3.length));
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspection$SimplifyFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "conditionValue", "", "isUsedAsExpression", "(ZZ)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    private static final class SimplifyFix
    implements LocalQuickFix {
        private final boolean conditionValue;
        private final boolean isUsedAsExpression;

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return "Simplify expression";
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            boolean strict$iv = true;
            KtIfExpression ktIfExpression = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtIfExpression.class, (boolean)strict$iv);
            if (ktIfExpression == null) {
                return;
            }
            KtIfExpression ifExpression2 = ktIfExpression;
            KtExpression ktExpression = ConstantConditionIfInspectionKt.access$branch(ifExpression2, this.conditionValue);
            if (ktExpression == null || (ktExpression = IfThenUtilsKt.unwrapBlockOrParenthesis(ktExpression)) == null) {
                return;
            }
            KtExpression branch = ktExpression;
            ConstantConditionIfInspectionKt.replaceWithBranch(ifExpression2, branch, this.isUsedAsExpression);
        }

        public SimplifyFix(boolean conditionValue, boolean isUsedAsExpression) {
            this.conditionValue = conditionValue;
            this.isUsedAsExpression = isUsedAsExpression;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspection$RemoveFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    private static final class RemoveFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return "Delete expression";
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            boolean strict$iv = true;
            KtIfExpression ktIfExpression = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtIfExpression.class, (boolean)strict$iv);
            if (ktIfExpression == null) {
                return;
            }
            KtIfExpression ifExpression2 = ktIfExpression;
            ifExpression2.delete();
        }
    }
}

