/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.project;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.project.KotlinCodeBlockModificationListenerKt;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\nJ\u0006\u0010\u0015\u001a\u00020\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/project/KotlinCodeBlockModificationListener;", "", "modificationTracker", "Lcom/intellij/psi/util/PsiModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "treeAspect", "Lcom/intellij/pom/tree/TreeAspect;", "(Lcom/intellij/psi/util/PsiModificationTracker;Lcom/intellij/openapi/project/Project;Lcom/intellij/pom/tree/TreeAspect;)V", "lastAffectedModule", "Lcom/intellij/openapi/module/Module;", "lastAffectedModuleModCount", "", "modificationTrackerImpl", "Lcom/intellij/psi/impl/PsiModificationTrackerImpl;", "perModuleChangesHighwatermark", "Ljava/lang/Long;", "perModuleModCount", "", "getModificationCount", "module", "hasPerModuleModificationCounts", "", "Companion", "idea-analysis"})
public final class KotlinCodeBlockModificationListener {
    private final Map<Module, Long> perModuleModCount;
    private final PsiModificationTrackerImpl modificationTrackerImpl;
    private Module lastAffectedModule;
    private long lastAffectedModuleModCount;
    private Long perModuleChangesHighwatermark;
    private final TreeAspect treeAspect;
    private static final Class<? extends KtDeclaration>[] BLOCK_DECLARATION_TYPES;
    public static final Companion Companion;

    public final long getModificationCount(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Long l = this.perModuleModCount.get(module);
        if (l == null) {
            l = this.perModuleChangesHighwatermark;
        }
        return l != null ? l.longValue() : this.modificationTrackerImpl.getOutOfCodeBlockModificationCount();
    }

    public final boolean hasPerModuleModificationCounts() {
        return this.perModuleChangesHighwatermark != null;
    }

    public KotlinCodeBlockModificationListener(@NotNull PsiModificationTracker modificationTracker2, @NotNull Project project, @NotNull TreeAspect treeAspect) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)modificationTracker2, (String)"modificationTracker");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)treeAspect, (String)"treeAspect");
        this.treeAspect = treeAspect;
        KotlinCodeBlockModificationListener kotlinCodeBlockModificationListener = this;
        kotlinCodeBlockModificationListener.perModuleModCount = map2 = (Map)new LinkedHashMap();
        this.modificationTrackerImpl = (PsiModificationTrackerImpl)modificationTracker2;
        this.lastAffectedModuleModCount = -1L;
        PomModel model = PomManager.getModel((Project)project);
        final MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        model.addModelListener(new PomModelListener(){

            public boolean isAspectChangeInteresting(@NotNull PomModelAspect aspect) {
                Intrinsics.checkParameterIsNotNull((Object)aspect, (String)"aspect");
                return Intrinsics.areEqual((Object)aspect, (Object)treeAspect);
            }

            public void modelChanged(@NotNull PomModelEvent event) {
                Object[] objectArray;
                boolean bl;
                ASTNode[] changedElements;
                KtFile file2;
                block7: {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    TreeChangeEvent treeChangeEvent = (TreeChangeEvent)event.getChangeSet((PomModelAspect)treeAspect);
                    if (treeChangeEvent == null) {
                        return;
                    }
                    TreeChangeEvent changeSet = treeChangeEvent;
                    PsiFile psiFile = changeSet.getRootElement().getPsi().getContainingFile();
                    if (!(psiFile instanceof KtFile)) {
                        psiFile = null;
                    }
                    KtFile ktFile = (KtFile)psiFile;
                    if (ktFile == null) {
                        return;
                    }
                    file2 = ktFile;
                    changedElements = changeSet.getChangedElements();
                    Object[] $receiver$iv = changedElements;
                    for (int i = 0; i < $receiver$iv.length; ++i) {
                        Object element$iv = $receiver$iv[i];
                        ASTNode it = (ASTNode)element$iv;
                        PsiElement psiElement2 = it.getPsi();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"it.psi");
                        if (!(Companion.getInsideCodeBlockModificationScope(psiElement2) == null)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
                if (bl || file2 instanceof PsiCodeFragment && (objectArray = (Object[])changedElements).length == 0) {
                    messageBusConnection.deliverImmediately();
                    if (file2.isPhysical()) {
                        VirtualFile virtualFile2 = file2.getVirtualFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.virtualFile");
                        if (!Companion.isReplLine(virtualFile2)) {
                            lastAffectedModule = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)file2));
                            lastAffectedModuleModCount = modificationTrackerImpl.getOutOfCodeBlockModificationCount();
                            modificationTrackerImpl.incCounter();
                        }
                    }
                    Companion.incOutOfBlockModificationCount(file2);
                }
            }
        });
        messageBusConnection.subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){

            public final void modificationCountChanged() {
                long newModCount = modificationTrackerImpl.getOutOfCodeBlockModificationCount();
                Module affectedModule = lastAffectedModule;
                if (affectedModule != null && newModCount == lastAffectedModuleModCount + 1L) {
                    if (perModuleChangesHighwatermark == null) {
                        perModuleChangesHighwatermark = lastAffectedModuleModCount;
                    }
                    Map map2 = perModuleModCount;
                    Long l = newModCount;
                    map2.put(affectedModule, l);
                } else {
                    perModuleChangesHighwatermark = null;
                    perModuleModCount.clear();
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        Companion = new Companion(null);
        Object[] elements$iv = new Class[]{KtProperty.class, KtNamedFunction.class};
        BLOCK_DECLARATION_TYPES = (Class[])var0;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u001bH\u0002R$\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/project/KotlinCodeBlockModificationListener$Companion;", "", "()V", "BLOCK_DECLARATION_TYPES", "", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getBLOCK_DECLARATION_TYPES", "()[Ljava/lang/Class;", "[Ljava/lang/Class;", "getInsideCodeBlockModificationScope", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "Lcom/intellij/psi/PsiElement;", "getInstance", "Lorg/jetbrains/kotlin/idea/project/KotlinCodeBlockModificationListener;", "kotlin.jvm.PlatformType", "project", "Lcom/intellij/openapi/project/Project;", "incOutOfBlockModificationCount", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isBlockDeclaration", "", "declaration", "isReplLine", "Lcom/intellij/openapi/vfs/VirtualFile;", "idea-analysis"})
    public static final class Companion {
        private final boolean isReplLine(VirtualFile file2) {
            return Intrinsics.areEqual((Object)((Boolean)file2.getUserData(KotlinCodeBlockModificationListenerKt.getKOTLIN_CONSOLE_KEY())), (Object)true);
        }

        private final void incOutOfBlockModificationCount(KtFile file2) {
            Long l = (Long)file2.getUserData(KotlinCodeBlockModificationListenerKt.access$getFILE_OUT_OF_BLOCK_MODIFICATION_COUNT$p());
            if (l == null) {
                l = 0L;
            }
            Long count = l;
            file2.putUserData(KotlinCodeBlockModificationListenerKt.access$getFILE_OUT_OF_BLOCK_MODIFICATION_COUNT$p(), count + 1L);
        }

        @Nullable
        public final KtElement getInsideCodeBlockModificationScope(@NotNull PsiElement element3) {
            boolean bl;
            Object $i$a$1$let;
            PsiElement blockDeclaration;
            block14: {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                Object $receiver$iv = element3;
                KtLambdaExpression lambda2 = (KtLambdaExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)$receiver$iv, KtLambdaExpression.class);
                if (lambda2 instanceof KtLambdaExpression) {
                    $receiver$iv = (PsiElement)lambda2;
                    KtSuperTypeCallEntry ktSuperTypeCallEntry = (KtSuperTypeCallEntry)PsiTreeUtil.getTopmostParentOfType((PsiElement)$receiver$iv, KtSuperTypeCallEntry.class);
                    if (ktSuperTypeCallEntry != null) {
                        Object it = $receiver$iv = ktSuperTypeCallEntry;
                        return (KtElement)it;
                    }
                }
                Class<? extends KtDeclaration>[] classArray = this.getBLOCK_DECLARATION_TYPES();
                PsiElement psiElement2 = KtPsiUtil.getTopmostParentOfTypes(element3, Arrays.copyOf(classArray, classArray.length));
                if (psiElement2 == null) {
                    return null;
                }
                blockDeclaration = psiElement2;
                Sequence<PsiElement> $receiver$iv2 = PsiUtilsKt.getParents(blockDeclaration);
                $i$a$1$let = $receiver$iv2.iterator();
                while ($i$a$1$let.hasNext()) {
                    Object element$iv = $i$a$1$let.next();
                    PsiElement it = (PsiElement)element$iv;
                    if (!(!(it instanceof KtClassBody) && !(it instanceof KtClassOrObject) && !(it instanceof KtFile))) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
            if (bl) {
                return null;
            }
            PsiElement psiElement3 = blockDeclaration;
            if (psiElement3 instanceof KtNamedFunction) {
                Object it;
                if (((KtNamedFunction)blockDeclaration).hasBlockBody()) {
                    KtExpression ktExpression = ((KtNamedFunction)blockDeclaration).getBodyExpression();
                    return (KtElement)(ktExpression != null ? (PsiUtilsKt.isAncestor$default((PsiElement)(it = ($i$a$1$let = ktExpression)), element3, false, 2, null) ? $i$a$1$let : null) : null);
                }
                if (((KtNamedFunction)blockDeclaration).hasDeclaredReturnType()) {
                    KtExpression ktExpression = ((KtNamedFunction)blockDeclaration).getInitializer();
                    return (KtElement)(ktExpression != null ? (PsiUtilsKt.isAncestor$default((PsiElement)(it = ($i$a$1$let = ktExpression)), element3, false, 2, null) ? $i$a$1$let : null) : null);
                }
            } else if (psiElement3 instanceof KtProperty) {
                if (((KtProperty)blockDeclaration).getTypeReference() != null) {
                    for (KtPropertyAccessor accessor : ((KtProperty)blockDeclaration).getAccessors()) {
                        KtExpression ktExpression;
                        KtExpression it;
                        KtExpression ktExpression2;
                        KtExpression ktExpression3 = accessor.getInitializer();
                        if (ktExpression3 == null) {
                            ktExpression3 = ktExpression2 = accessor.getBodyExpression();
                        }
                        if (ktExpression3 == null || (ktExpression2 = PsiUtilsKt.isAncestor$default((PsiElement)(it = (ktExpression = ktExpression2)), element3, false, 2, null) ? ktExpression : null) == null) continue;
                        it = ktExpression = ktExpression2;
                        return it;
                    }
                }
            } else {
                throw (Throwable)new IllegalStateException();
            }
            return null;
        }

        public final boolean isBlockDeclaration(@NotNull KtDeclaration declaration2) {
            boolean bl;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                Object[] $receiver$iv = this.getBLOCK_DECLARATION_TYPES();
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    Class it = (Class)element$iv;
                    if (!it.isInstance(declaration2)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private final Class<? extends KtDeclaration>[] getBLOCK_DECLARATION_TYPES() {
            return BLOCK_DECLARATION_TYPES;
        }

        public final KotlinCodeBlockModificationListener getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return (KotlinCodeBlockModificationListener)project.getComponent(KotlinCodeBlockModificationListener.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

