/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.OperatorToFunctionIntention;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.ReplaceCallFixUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.ReplaceInfixOrOperatorCallFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceInfixOrOperatorCallFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "notNullNeeded", "", "(Lorg/jetbrains/kotlin/psi/KtExpression;Z)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startInWriteAction", "Companion", "idea"})
public final class ReplaceInfixOrOperatorCallFix
extends KotlinQuickFixAction<KtExpression> {
    private final boolean notNullNeeded;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return "Replace with safe (?.) call";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        block18: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KtExpression ktExpression = (KtExpression)this.getElement();
            if (ktExpression == null) {
                return;
            }
            KtExpression element3 = ktExpression;
            KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)file2, false, 2, null);
            String elvis2 = ReplaceCallFixUtilsKt.elvisOrEmpty(this.notNullNeeded);
            PsiElement replacement = null;
            KtExpression ktExpression2 = element3;
            if (ktExpression2 instanceof KtArrayAccessExpression) {
                KtBinaryExpression assignment;
                KtBinaryExpression ktBinaryExpression = assignment = KtPsiUtilKt.getAssignmentByLHS(element3);
                KtExpression right = ktBinaryExpression != null ? ktBinaryExpression.getRight() : null;
                KtExpression ktExpression3 = ((KtArrayAccessExpression)element3).getArrayExpression();
                if (ktExpression3 == null) {
                    return;
                }
                KtExpression arrayExpression = ktExpression3;
                if (assignment != null) {
                    if (right == null) {
                        return;
                    }
                    Object[] objectArray = new Object[3];
                    KtExpression ktExpression4 = arrayExpression;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"arrayExpression");
                    objectArray[0] = ktExpression4;
                    objectArray[1] = CollectionsKt.joinToString$default((Iterable)((KtArrayAccessExpression)element3).getIndexExpressions(), (CharSequence)", ", null, null, (int)0, null, (Function1)invoke.newExpression.1.INSTANCE, (int)30, null);
                    objectArray[2] = right;
                    KtExpression newExpression2 = CreateByPatternKt.createExpressionByPattern$default(psiFactory, "$0?.set($1, $2)", objectArray, false, 4, null);
                    assignment.replace((PsiElement)newExpression2);
                } else {
                    String string = "$0?.get($1)" + elvis2;
                    Object[] objectArray = new Object[2];
                    KtExpression ktExpression5 = arrayExpression;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression5, (String)"arrayExpression");
                    objectArray[0] = ktExpression5;
                    objectArray[1] = CollectionsKt.joinToString$default((Iterable)((KtArrayAccessExpression)element3).getIndexExpressions(), (CharSequence)", ", null, null, (int)0, null, (Function1)invoke.newExpression.2.INSTANCE, (int)30, null);
                    KtExpression newExpression3 = CreateByPatternKt.createExpressionByPattern$default(psiFactory, string, objectArray, false, 4, null);
                    replacement = ((KtArrayAccessExpression)element3).replace((PsiElement)newExpression3);
                }
            } else if (ktExpression2 instanceof KtCallExpression) {
                Object[] objectArray = new Object[2];
                KtExpression ktExpression6 = ((KtCallExpression)element3).getCalleeExpression();
                if (ktExpression6 == null) {
                    return;
                }
                objectArray[0] = ktExpression6;
                objectArray[1] = CollectionsKt.joinToString$default((Iterable)((KtCallExpression)element3).getValueArguments(), (CharSequence)", ", null, null, (int)0, null, (Function1)invoke.newExpression.3.INSTANCE, (int)30, null);
                KtExpression newExpression4 = CreateByPatternKt.createExpressionByPattern$default(psiFactory, "$0?.invoke($1)" + elvis2, objectArray, false, 4, null);
                replacement = ((KtCallExpression)element3).replace((PsiElement)newExpression4);
            } else if (ktExpression2 instanceof KtBinaryExpression) {
                PsiElement psiElement2;
                if (Intrinsics.areEqual((Object)((KtBinaryExpression)element3).getOperationToken(), (Object)((Object)KtTokens.IDENTIFIER))) {
                    String string = "$0?.$1($2)" + elvis2;
                    Object[] objectArray = new Object[3];
                    KtExpression ktExpression7 = ((KtBinaryExpression)element3).getLeft();
                    if (ktExpression7 == null) {
                        return;
                    }
                    objectArray[0] = ktExpression7;
                    KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)element3).getOperationReference();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"element.operationReference");
                    objectArray[1] = ktOperationReferenceExpression;
                    KtExpression ktExpression8 = ((KtBinaryExpression)element3).getRight();
                    if (ktExpression8 == null) {
                        return;
                    }
                    objectArray[2] = ktExpression8;
                    KtExpression newExpression5 = CreateByPatternKt.createExpressionByPattern$default(psiFactory, string, objectArray, false, 4, null);
                    psiElement2 = ((KtBinaryExpression)element3).replace((PsiElement)newExpression5);
                } else {
                    KtSimpleNameExpression nameExpression2 = (KtSimpleNameExpression)OperatorToFunctionIntention.Companion.convert(element3).getSecond();
                    PsiElement psiElement3 = nameExpression2.getParent();
                    if (psiElement3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
                    }
                    KtCallExpression callExpression2 = (KtCallExpression)psiElement3;
                    PsiElement psiElement4 = callExpression2.getParent();
                    if (psiElement4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
                    }
                    KtDotQualifiedExpression qualifiedExpression = (KtDotQualifiedExpression)psiElement4;
                    KtExpression safeExpression = CreateByPatternKt.createExpressionByPattern$default(psiFactory, "$0?.$1" + elvis2, new Object[]{qualifiedExpression.getReceiverExpression(), callExpression2}, false, 4, null);
                    psiElement2 = replacement = qualifiedExpression.replace((PsiElement)safeExpression);
                }
            }
            if (!this.notNullNeeded) break block18;
            PsiElement psiElement5 = replacement;
            if (psiElement5 != null) {
                ReplaceCallFixUtilsKt.moveCaretToEnd(psiElement5, editor, project);
            }
        }
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    public ReplaceInfixOrOperatorCallFix(@NotNull KtExpression element3, boolean notNullNeeded) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        super((PsiElement)element3);
        this.notNullNeeded = notNullNeeded;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceInfixOrOperatorCallFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            IntentionAction intentionAction;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement expression2 = diagnostic.getPsiElement();
            if (expression2 instanceof KtArrayAccessExpression && Intrinsics.areEqual(diagnostic.getFactory(), Errors.UNSAFE_IMPLICIT_INVOKE_CALL) ^ true) {
                if (((KtArrayAccessExpression)expression2).getArrayExpression() == null) {
                    return null;
                }
                return new ReplaceInfixOrOperatorCallFix((KtExpression)expression2, ReplaceCallFixUtilsKt.shouldHaveNotNullType((KtExpression)expression2));
            }
            PsiElement parent2 = expression2.getParent();
            PsiElement psiElement2 = parent2;
            if (psiElement2 instanceof KtBinaryExpression) {
                intentionAction = ((KtBinaryExpression)parent2).getLeft() == null || ((KtBinaryExpression)parent2).getRight() == null ? null : (Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getOperationToken(), (Object)((Object)KtTokens.EQ)) ? null : (CollectionsKt.contains((Iterable)((Iterable)OperatorConventions.COMPARISON_OPERATIONS), (Object)((KtBinaryExpression)parent2).getOperationToken()) ? null : new ReplaceInfixOrOperatorCallFix((KtExpression)parent2, ReplaceCallFixUtilsKt.shouldHaveNotNullType((KtExpression)parent2))));
            } else if (psiElement2 instanceof KtCallExpression) {
                ReplaceInfixOrOperatorCallFix replaceInfixOrOperatorCallFix;
                if (((KtCallExpression)parent2).getCalleeExpression() == null) {
                    replaceInfixOrOperatorCallFix = null;
                } else if (((KtCallExpression)parent2).getParent() instanceof KtQualifiedExpression) {
                    replaceInfixOrOperatorCallFix = null;
                } else {
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)parent2, ResolutionUtils.analyze$default((KtElement)parent2, null, 1, null));
                    replaceInfixOrOperatorCallFix = (resolvedCall2 != null ? ResolvedCallUtilKt.getImplicitReceiverValue(resolvedCall2) : null) != null ? null : new ReplaceInfixOrOperatorCallFix((KtExpression)parent2, ReplaceCallFixUtilsKt.shouldHaveNotNullType((KtExpression)parent2));
                }
                intentionAction = replaceInfixOrOperatorCallFix;
            } else {
                intentionAction = null;
            }
            return intentionAction;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

