/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinModuleFileType;
import org.jetbrains.kotlin.idea.decompiler.builtIns.KotlinBuiltInFileType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u0005*\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005\u001a\n\u0010\u000f\u001a\u00020\f*\u00020\u0005\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"kotlinBinaries", "", "Lcom/intellij/openapi/fileTypes/FileType;", "kotlin.jvm.PlatformType", "sourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/psi/PsiFileSystemItem;", "getSourceRoot", "(Lcom/intellij/psi/PsiFileSystemItem;)Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "isInSourceContentWithoutInjected", "", "Lcom/intellij/openapi/roots/FileIndex;", "file", "isKotlinBinary", "idea-analysis"})
public final class ProjectRootsUtilKt {
    private static final List<FileType> kotlinBinaries = CollectionsKt.listOf((Object[])new FileType[]{(FileType)JavaClassFileType.INSTANCE, KotlinBuiltInFileType.INSTANCE, KotlinModuleFileType.INSTANCE});

    public static final boolean isKotlinBinary(@NotNull VirtualFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return kotlinBinaries.contains($receiver.getFileType());
    }

    public static final boolean isInSourceContentWithoutInjected(@NotNull FileIndex $receiver, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return !(file2 instanceof VirtualFileWindow) && $receiver.isInSourceContent(file2);
    }

    @Nullable
    public static final VirtualFile getSourceRoot(@NotNull VirtualFile $receiver, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile($receiver);
    }

    @Nullable
    public static final VirtualFile getSourceRoot(@NotNull PsiFileSystemItem $receiver) {
        VirtualFile virtualFile2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        VirtualFile virtualFile3 = $receiver.getVirtualFile();
        if (virtualFile3 != null) {
            Project project = $receiver.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            virtualFile2 = ProjectRootsUtilKt.getSourceRoot(virtualFile3, project);
        } else {
            virtualFile2 = null;
        }
        return virtualFile2;
    }
}

