/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinJavaModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinJsModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeDetectionUtil;
import org.jetbrains.kotlin.idea.util.DumbUtilsKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.BinaryVersionedFile;
import org.jetbrains.kotlin.idea.versions.KotlinJsMetadataVersionIndex;
import org.jetbrains.kotlin.idea.versions.KotlinJvmMetadataVersionIndex;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt$WhenMappings;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.idea.vfilefinder.FileIndexesKt;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinJavaScriptMetaFileIndex;
import org.jetbrains.kotlin.load.kotlin.JvmMetadataVersion;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.deserialization.BinaryVersion;
import org.jetbrains.kotlin.utils.JsMetadataVersion;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\u009e\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0006\u0010\u001b\u001a\u00020\u0007\u001a\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d2\u0006\u0010 \u001a\u00020!\u001a\u001a\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u0007\u001a\u0018\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020*\u001a\u001a\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0-0,2\u0006\u0010/\u001a\u00020\u001f\u001a\u001a\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002010-0,2\u0006\u0010/\u001a\u00020\u001f\u001aA\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H30-0,\"\b\b\u0000\u00103*\u0002042\u0006\u0010/\u001a\u00020\u001f2\u0006\u00105\u001a\u0002H32\f\u00106\u001a\b\u0012\u0004\u0012\u0002H307H\u0002\u00a2\u0006\u0002\u00108\u001a\u0012\u00109\u001a\u0004\u0018\u00010:2\b\u0010;\u001a\u0004\u0018\u00010:\u001a\u0018\u0010<\u001a\u00020\u00072\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u0007\u001a\u000e\u0010=\u001a\u00020>2\u0006\u0010&\u001a\u00020\u0007\u001a\u0016\u0010?\u001a\u00020>2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020*\u001a\u000e\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u00020\u0007\u001a\u001a\u0010B\u001a\u0004\u0018\u00010:2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020:H\u0000\u001a\u0016\u0010F\u001a\u00020G2\u0006\u0010 \u001a\u00020!2\u0006\u0010H\u001a\u00020\u0007\u001a \u0010I\u001a\u00020G2\u0006\u0010 \u001a\u00020!2\u0006\u0010J\u001a\u00020\u001e2\u0006\u0010K\u001a\u00020LH\u0002\u001a\u001c\u0010M\u001a\u00020G2\u0006\u0010 \u001a\u00020!2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u001e0,\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u0014\u0010\n\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\"\u0014\u0010\f\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\"\u0014\u0010\u000e\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\"\u0014\u0010\u0010\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\t\"\u0014\u0010\u0012\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\t\"\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\"\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0018\u0010\t\u00a8\u0006O"}, d2={"KOTLIN_JS_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "MAVEN_COMMON_STDLIB_ID", "", "getMAVEN_COMMON_STDLIB_ID", "()Ljava/lang/String;", "MAVEN_JS_STDLIB_ID", "getMAVEN_JS_STDLIB_ID", "MAVEN_OLD_JS_STDLIB_ID", "getMAVEN_OLD_JS_STDLIB_ID", "MAVEN_STDLIB_ID", "getMAVEN_STDLIB_ID", "MAVEN_STDLIB_ID_JRE7", "getMAVEN_STDLIB_ID_JRE7", "MAVEN_STDLIB_ID_JRE8", "getMAVEN_STDLIB_ID_JRE8", "PLUGIN_VERSIONS_SEPARATORS", "", "[Ljava/lang/String;", "bundledRuntimeBuildNumber", "getBundledRuntimeBuildNumber", "bundledRuntimeBuildNumber$delegate", "Lkotlin/Lazy;", "bundledRuntimeVersion", "findAllUsedLibraries", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/roots/libraries/Library;", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "getDefaultJvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "version", "getKotlinJvmRuntimeMarkerClass", "Lcom/intellij/psi/PsiClass;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getLibraryRootsWithAbiIncompatibleForKotlinJs", "", "Lorg/jetbrains/kotlin/idea/versions/BinaryVersionedFile;", "Lorg/jetbrains/kotlin/utils/JsMetadataVersion;", "module", "getLibraryRootsWithAbiIncompatibleKotlinClasses", "Lorg/jetbrains/kotlin/load/kotlin/JvmMetadataVersion;", "getLibraryRootsWithAbiIncompatibleVersion", "T", "Lorg/jetbrains/kotlin/serialization/deserialization/BinaryVersion;", "supportedVersion", "index", "Lcom/intellij/util/indexing/ScalarIndexExtension;", "(Lcom/intellij/openapi/module/Module;Lorg/jetbrains/kotlin/serialization/deserialization/BinaryVersion;Lcom/intellij/util/indexing/ScalarIndexExtension;)Ljava/util/Collection;", "getLocalJar", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlinRuntimeJar", "getStdlibArtifactId", "hasJreSpecificRuntime", "", "hasKotlinJsKjsmFile", "pluginRuntimeVersion", "pluginVersion", "replaceFile", "updatedFile", "Ljava/io/File;", "jarFileToReplace", "showRuntimeJarNotFoundDialog", "", "jarName", "updateJar", "library", "libraryJarDescriptor", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "updateLibraries", "libraries", "idea"})
public final class KotlinRuntimeLibraryUtilKt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final Lazy bundledRuntimeBuildNumber$delegate;
    private static final String[] PLUGIN_VERSIONS_SEPARATORS;
    private static final FqName KOTLIN_JS_FQ_NAME;
    @NotNull
    private static final String MAVEN_STDLIB_ID = "kotlin-stdlib";
    @NotNull
    private static final String MAVEN_STDLIB_ID_JRE7 = "kotlin-stdlib-jre7";
    @NotNull
    private static final String MAVEN_STDLIB_ID_JRE8 = "kotlin-stdlib-jre8";
    @NotNull
    private static final String MAVEN_JS_STDLIB_ID = "kotlin-stdlib-js";
    @NotNull
    private static final String MAVEN_OLD_JS_STDLIB_ID = "kotlin-js-library";
    @NotNull
    private static final String MAVEN_COMMON_STDLIB_ID = "kotlin-stdlib-common";
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(KotlinRuntimeLibraryUtilKt.class, (String)"idea"), "bundledRuntimeBuildNumber", "getBundledRuntimeBuildNumber()Ljava/lang/String;"))};
        bundledRuntimeBuildNumber$delegate = LazyKt.lazy((Function0)bundledRuntimeBuildNumber.2.INSTANCE);
        Object[] elements$iv = new String[]{"Idea", "IJ", "release", "dev", "Studio"};
        PLUGIN_VERSIONS_SEPARATORS = (String[])var0;
        KOTLIN_JS_FQ_NAME = new FqName("kotlin.js");
        MAVEN_STDLIB_ID = MAVEN_STDLIB_ID;
        MAVEN_STDLIB_ID_JRE7 = MAVEN_STDLIB_ID_JRE7;
        MAVEN_STDLIB_ID_JRE8 = MAVEN_STDLIB_ID_JRE8;
        MAVEN_JS_STDLIB_ID = MAVEN_JS_STDLIB_ID;
        MAVEN_OLD_JS_STDLIB_ID = MAVEN_OLD_JS_STDLIB_ID;
        MAVEN_COMMON_STDLIB_ID = MAVEN_COMMON_STDLIB_ID;
        LOG = Logger.getInstance((String)"org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt");
    }

    @NotNull
    public static final Collection<BinaryVersionedFile<JvmMetadataVersion>> getLibraryRootsWithAbiIncompatibleKotlinClasses(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return KotlinRuntimeLibraryUtilKt.getLibraryRootsWithAbiIncompatibleVersion(module, (BinaryVersion)JvmMetadataVersion.INSTANCE, KotlinJvmMetadataVersionIndex.INSTANCE);
    }

    @NotNull
    public static final Collection<BinaryVersionedFile<JsMetadataVersion>> getLibraryRootsWithAbiIncompatibleForKotlinJs(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return KotlinRuntimeLibraryUtilKt.getLibraryRootsWithAbiIncompatibleVersion(module, (BinaryVersion)JsMetadataVersion.INSTANCE, KotlinJsMetadataVersionIndex.INSTANCE);
    }

    public static final void updateLibraries(@NotNull Project project, @NotNull Collection<? extends Library> libraries) {
        boolean bl;
        block13: {
            Module module;
            boolean bl2;
            Iterable $receiver$iv;
            block12: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull(libraries, (String)"libraries");
                $receiver$iv = ProjectStructureUtilKt.allModules(project);
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        module = (Module)element$iv;
                        if (!KotlinPluginUtil.isMavenModule(module)) continue;
                        bl2 = true;
                        break block12;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                Messages.showMessageDialog((Project)project, (String)"Automatic library version update for Maven projects is currently unsupported. Please update your pom.xml manually.", (String)"Update Kotlin Runtime Library", (Icon)Messages.getErrorIcon());
                return;
            }
            $receiver$iv = ProjectStructureUtilKt.allModules(project);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    module = (Module)element$iv;
                    if (!KotlinPluginUtil.isGradleModule(module)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            Messages.showMessageDialog((Project)project, (String)"Automatic library version update for Gradle projects is currently unsupported. Please update your build.gradle manually.", (String)"Update Kotlin Runtime Library", (Icon)Messages.getErrorIcon());
            return;
        }
        KotlinJavaModuleConfigurator kotlinJavaModuleConfigurator = (KotlinJavaModuleConfigurator)ConfigureKotlinInProjectUtilsKt.getConfiguratorByName(KotlinJavaModuleConfigurator.Companion.getNAME());
        if (kotlinJavaModuleConfigurator == null) {
            String string = "Configurator with given name doesn't exists: " + KotlinJavaModuleConfigurator.Companion.getNAME();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KotlinJavaModuleConfigurator kJvmConfigurator = kotlinJavaModuleConfigurator;
        KotlinJsModuleConfigurator kotlinJsModuleConfigurator = (KotlinJsModuleConfigurator)ConfigureKotlinInProjectUtilsKt.getConfiguratorByName("js");
        if (kotlinJsModuleConfigurator == null) {
            Object element$iv;
            element$iv = "Configurator with given name doesn't exists: js";
            throw (Throwable)new IllegalStateException(element$iv.toString());
        }
        KotlinJsModuleConfigurator kJsConfigurator = kotlinJsModuleConfigurator;
        NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project);
        Sdk sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        for (Library library2 : libraries) {
            List<LibraryJarDescriptor> libraryJarDescriptors = JavaRuntimeDetectionUtil.getJavaRuntimeVersion(library2) != null ? kJvmConfigurator.getLibraryJarDescriptors(sdk) : kJsConfigurator.getLibraryJarDescriptors(sdk);
            for (LibraryJarDescriptor libraryJarDescriptor : libraryJarDescriptors) {
                KotlinRuntimeLibraryUtilKt.updateJar(project, library2, libraryJarDescriptor);
            }
        }
        collector2.showNotification();
    }

    private static final void updateJar(Project project, Library library2, LibraryJarDescriptor libraryJarDescriptor) {
        VirtualFile jarFileToReplace;
        VirtualFile newVFile;
        VirtualFile fileToReplace = libraryJarDescriptor.findExistingJar(library2);
        if (fileToReplace == null && !libraryJarDescriptor.getShouldExist()) {
            return;
        }
        VirtualFile virtualFile2 = fileToReplace;
        String oldUrl = virtualFile2 != null ? virtualFile2.getUrl() : null;
        File jarPath = libraryJarDescriptor.getPathInPlugin();
        if (!jarPath.exists()) {
            KotlinRuntimeLibraryUtilKt.showRuntimeJarNotFoundDialog(project, libraryJarDescriptor.getJarName());
            return;
        }
        VirtualFile virtualFile3 = KotlinRuntimeLibraryUtilKt.getLocalJar(fileToReplace);
        if (virtualFile3 == null) {
            Intrinsics.throwNpe();
        }
        if ((newVFile = KotlinRuntimeLibraryUtilKt.replaceFile(jarPath, jarFileToReplace = virtualFile3)) != null) {
            Library.ModifiableModel model = library2.getModifiableModel();
            ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(oldUrl, model, libraryJarDescriptor, newVFile){
                final /* synthetic */ String $oldUrl;
                final /* synthetic */ Library.ModifiableModel $model;
                final /* synthetic */ LibraryJarDescriptor $libraryJarDescriptor;
                final /* synthetic */ VirtualFile $newVFile;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    try {
                        if (this.$oldUrl != null) {
                            this.$model.removeRoot(this.$oldUrl, this.$libraryJarDescriptor.getOrderRootType());
                        }
                        VirtualFile virtualFile2 = JarFileSystem.getInstance().getJarRootForLocalFile(this.$newVFile);
                        if (virtualFile2 == null) {
                            Intrinsics.throwNpe();
                        }
                        VirtualFile newRoot = virtualFile2;
                        this.$model.addRoot(newRoot, this.$libraryJarDescriptor.getOrderRootType());
                    }
                    finally {
                        this.$model.commit();
                    }
                }
                {
                    this.$oldUrl = string;
                    this.$model = modifiableModel;
                    this.$libraryJarDescriptor = libraryJarDescriptor;
                    this.$newVFile = virtualFile2;
                    super(0);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MultiMap<Library, Module> findAllUsedLibraries(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        MultiMap libraries = new MultiMap();
        Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
        for (int i = 0; i < moduleArray.length; ++i) {
            void $receiver$iv$iv;
            Object[] $receiver$iv;
            Module module = moduleArray[i];
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Object[] objectArray = $receiver$iv = (Object[])moduleRootManager.getOrderEntries();
            Collection destination$iv$iv = new ArrayList();
            for (int j = 0; j < ((void)$receiver$iv$iv).length; ++j) {
                void element$iv$iv = $receiver$iv$iv[j];
                if (!(element$iv$iv instanceof LibraryOrderEntry)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (LibraryOrderEntry entry : (List)destination$iv$iv) {
                Library library2;
                if (entry.getLibrary() == null) {
                    continue;
                }
                libraries.putValue((Object)library2, (Object)module);
            }
        }
        return libraries;
    }

    @NotNull
    public static final String bundledRuntimeVersion() {
        String string = KotlinRuntimeLibraryUtilKt.getBundledRuntimeBuildNumber();
        if (string == null) {
            String string2 = KotlinPluginUtil.getPluginVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"KotlinPluginUtil.getPluginVersion()");
            string = KotlinRuntimeLibraryUtilKt.pluginRuntimeVersion(string2);
        }
        return string;
    }

    private static final String getBundledRuntimeBuildNumber() {
        Lazy lazy = bundledRuntimeBuildNumber$delegate;
        Object var1_1 = null;
        KProperty kProperty = $$delegatedProperties[0];
        return (String)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String pluginRuntimeVersion(@NotNull String pluginVersion) {
        String string;
        int separator2;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)pluginVersion, (String)"pluginVersion");
        int placeToSplit = -1;
        String[] stringArray = PLUGIN_VERSIONS_SEPARATORS;
        for (n = 0; n < stringArray.length; ++n) {
            String separator2 = stringArray[n];
            int ideaPatternIndex = StringUtil.indexOf((CharSequence)pluginVersion, (CharSequence)separator2);
            if (ideaPatternIndex < 2 || !Character.isDigit(pluginVersion.charAt(ideaPatternIndex - 2))) continue;
            placeToSplit = ideaPatternIndex - 1;
            break;
        }
        if (placeToSplit == -1 && (separator2 = 1) <= (n = pluginVersion.length() - 1)) {
            while (true) {
                void i;
                char ch;
                if (Character.isLetter(ch = pluginVersion.charAt((int)i)) && pluginVersion.charAt((int)(i - true)) == '.') {
                    placeToSplit = i - true;
                    break;
                }
                if (i == n) break;
                ++i;
            }
        }
        if (placeToSplit != -1) {
            String string2 = pluginVersion;
            n = 0;
            String string3 = string2.substring(n, placeToSplit);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = pluginVersion;
        }
        return string;
    }

    @Nullable
    public static final VirtualFile getLocalJar(@Nullable VirtualFile kotlinRuntimeJar) {
        if (kotlinRuntimeJar == null) {
            return null;
        }
        VirtualFile localJarFile = JarFileSystem.getInstance().getVirtualFileForJar(kotlinRuntimeJar);
        if (localJarFile != null) {
            return localJarFile;
        }
        return kotlinRuntimeJar;
    }

    @Nullable
    public static final VirtualFile replaceFile(@NotNull File updatedFile, @NotNull VirtualFile jarFileToReplace) {
        File newFile;
        Intrinsics.checkParameterIsNotNull((Object)updatedFile, (String)"updatedFile");
        Intrinsics.checkParameterIsNotNull((Object)jarFileToReplace, (String)"jarFileToReplace");
        File jarIoFileToReplace = new File(jarFileToReplace.getPath());
        if (FileUtil.filesEqual((File)updatedFile, (File)jarIoFileToReplace)) {
            return null;
        }
        FileUtil.copy((File)updatedFile, (File)jarIoFileToReplace);
        if (Intrinsics.areEqual((Object)jarIoFileToReplace.getName(), (Object)updatedFile.getName()) ^ true && !(newFile = new File(jarIoFileToReplace.getParent(), updatedFile.getName())).exists()) {
            if (!jarIoFileToReplace.renameTo(newFile)) {
                LOG.info("Failed to rename " + jarIoFileToReplace.getPath() + " to " + newFile.getPath());
                return null;
            }
            VirtualFile newVFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(newFile);
            if (newVFile == null) {
                LOG.info("Failed to find " + newFile.getPath() + " in VFS");
                return null;
            }
            newVFile.refresh(false, true);
            return newVFile;
        }
        jarFileToReplace.refresh(false, true);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T extends BinaryVersion> Collection<BinaryVersionedFile<T>> getLibraryRootsWithAbiIncompatibleVersion(Module module, T supportedVersion, ScalarIndexExtension<T> index2) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        ID id = index2.getName();
        Set set2 = SetsKt.setOf((Object)module);
        List list2 = ModuleUtil.getAllDependentModules((Module)module);
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ModuleUtil.getAllDependentModules(module)");
        Set moduleWithAllDependencies = SetsKt.plus((Set)set2, (Iterable)list2);
        Iterable iterable = $receiver$iv = (Iterable)moduleWithAllDependencies;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            Module module2 = (Module)item$iv$iv;
            Collection collection = destination$iv$iv;
            GlobalSearchScope globalSearchScope = it.getModuleWithLibrariesScope();
            collection.add(globalSearchScope);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterable thisCollection$iv = $receiver$iv;
        GlobalSearchScope[] globalSearchScopeArray = thisCollection$iv.toArray(new GlobalSearchScope[thisCollection$iv.size()]);
        if (globalSearchScopeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        GlobalSearchScope moduleWithAllDependentLibraries = GlobalSearchScope.union((GlobalSearchScope[])globalSearchScopeArray);
        Collection allVersions = FileBasedIndex.getInstance().getAllKeys(id, module.getProject());
        Iterable $receiver$iv2 = allVersions;
        Iterable iterable2 = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            BinaryVersion p1 = (BinaryVersion)element$iv$iv;
            if (p1.isCompatible()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        HashSet badVersions = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv2));
        HashSet<BinaryVersionedFile<BinaryVersion>> badRoots = new HashSet<BinaryVersionedFile<BinaryVersion>>();
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)module.getProject());
        for (BinaryVersion version : badVersions) {
            Collection indexedFiles = FileBasedIndex.getInstance().getContainingFiles(id, (Object)version, moduleWithAllDependentLibraries);
            for (VirtualFile indexedFile : indexedFiles) {
                VirtualFile libraryRoot;
                if (fileIndex.getClassRootForFile(indexedFile) == null) {
                    String string = "Only library roots were requested, and only class files should be indexed with the " + id + " key. " + "File: " + indexedFile.getPath();
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                VirtualFile virtualFile2 = PathUtil.getLocalFile((VirtualFile)libraryRoot);
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"getLocalFile(libraryRoot)");
                badRoots.add(new BinaryVersionedFile<BinaryVersion>(virtualFile2, version, supportedVersion));
            }
        }
        return badRoots;
    }

    public static final void showRuntimeJarNotFoundDialog(@NotNull Project project, @NotNull String jarName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)jarName, (String)"jarName");
        Messages.showErrorDialog((Project)project, (String)(jarName + " is not found. Make sure plugin is properly installed."), (String)"No Runtime Found");
    }

    @Nullable
    public static final PsiClass getKotlinJvmRuntimeMarkerClass(@NotNull Project project, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        return (PsiClass)ApplicationUtilsKt.runReadAction((Function0)new Function0<PsiClass>(project, scope2){
            final /* synthetic */ Project $project;
            final /* synthetic */ GlobalSearchScope $scope;

            @Nullable
            public final PsiClass invoke() {
                return (PsiClass)DumbUtilsKt.runWithAlternativeResolveEnabled(this.$project, (Function0)new Function0<PsiClass>(this){
                    final /* synthetic */ getKotlinJvmRuntimeMarkerClass.1 this$0;

                    @Nullable
                    public final PsiClass invoke() {
                        return JavaPsiFacade.getInstance((Project)this.this$0.$project).findClass(KotlinBuiltIns.FQ_NAMES.unit.asString(), this.this$0.$scope);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.$project = project;
                this.$scope = globalSearchScope;
                super(0);
            }
        });
    }

    public static final boolean hasKotlinJsKjsmFile(@NotNull Project project, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(project, scope2){
            final /* synthetic */ Project $project;
            final /* synthetic */ GlobalSearchScope $scope;

            public final boolean invoke() {
                return (Boolean)DumbUtilsKt.runWithAlternativeResolveEnabled(this.$project, (Function0)new Function0<Boolean>(this){
                    final /* synthetic */ hasKotlinJsKjsmFile.1 this$0;

                    public final boolean invoke() {
                        return FileIndexesKt.hasSomethingInPackage(KotlinJavaScriptMetaFileIndex.INSTANCE, KotlinRuntimeLibraryUtilKt.access$getKOTLIN_JS_FQ_NAME$p(), this.this$0.$scope);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.$project = project;
                this.$scope = globalSearchScope;
                super(0);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final String getStdlibArtifactId(@Nullable Sdk sdk, @NotNull String version) {
        String string;
        JavaSdkVersion sdkVersion;
        JavaSdkVersion javaSdkVersion;
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        if (!KotlinRuntimeLibraryUtilKt.hasJreSpecificRuntime(version)) {
            return MAVEN_STDLIB_ID;
        }
        Sdk sdk2 = sdk;
        if (sdk2 != null) {
            Sdk sdk3;
            Sdk it = sdk3 = sdk2;
            javaSdkVersion = JavaSdk.getInstance().getVersion(it);
        } else {
            javaSdkVersion = null;
        }
        JavaSdkVersion javaSdkVersion2 = sdkVersion = javaSdkVersion;
        if (javaSdkVersion2 != null) {
            switch (KotlinRuntimeLibraryUtilKt$WhenMappings.$EnumSwitchMapping$0[javaSdkVersion2.ordinal()]) {
                case 1: 
                case 2: {
                    string = MAVEN_STDLIB_ID_JRE8;
                    return string;
                }
                case 3: {
                    string = MAVEN_STDLIB_ID_JRE7;
                    return string;
                }
            }
        }
        string = MAVEN_STDLIB_ID;
        return string;
    }

    @Nullable
    public static final JvmTarget getDefaultJvmTarget(@Nullable Sdk sdk, @NotNull String version) {
        JavaSdkVersion sdkVersion;
        JavaSdkVersion javaSdkVersion;
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        if (!KotlinRuntimeLibraryUtilKt.hasJreSpecificRuntime(version)) {
            return null;
        }
        Sdk sdk2 = sdk;
        if (sdk2 != null) {
            Sdk sdk3;
            Sdk it = sdk3 = sdk2;
            javaSdkVersion = JavaSdk.getInstance().getVersion(it);
        } else {
            javaSdkVersion = sdkVersion = null;
        }
        if (sdkVersion != null && sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) {
            return JvmTarget.JVM_1_8;
        }
        return null;
    }

    public static final boolean hasJreSpecificRuntime(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return VersionComparatorUtil.compare((String)version, (String)"1.1.0") >= 0 || ConfigureKotlinInProjectUtilsKt.isSnapshot(version) || Intrinsics.areEqual((Object)version, (Object)"default_version");
    }

    @NotNull
    public static final String getMAVEN_STDLIB_ID() {
        return MAVEN_STDLIB_ID;
    }

    @NotNull
    public static final String getMAVEN_STDLIB_ID_JRE7() {
        return MAVEN_STDLIB_ID_JRE7;
    }

    @NotNull
    public static final String getMAVEN_STDLIB_ID_JRE8() {
        return MAVEN_STDLIB_ID_JRE8;
    }

    @NotNull
    public static final String getMAVEN_JS_STDLIB_ID() {
        return MAVEN_JS_STDLIB_ID;
    }

    @NotNull
    public static final String getMAVEN_OLD_JS_STDLIB_ID() {
        return MAVEN_OLD_JS_STDLIB_ID;
    }

    @NotNull
    public static final String getMAVEN_COMMON_STDLIB_ID() {
        return MAVEN_COMMON_STDLIB_ID;
    }

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    @NotNull
    public static final /* synthetic */ FqName access$getKOTLIN_JS_FQ_NAME$p() {
        return KOTLIN_JS_FQ_NAME;
    }
}

