/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.JsPrecedenceVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;

public class JsConstructExpressionVisitor
extends RecursiveJsVisitor {
    private boolean containsInvocation;

    public static boolean exec(JsExpression expression2) {
        if (JsPrecedenceVisitor.exec(expression2) < 15) {
            return true;
        }
        JsConstructExpressionVisitor visitor2 = new JsConstructExpressionVisitor();
        visitor2.accept(expression2);
        return visitor2.containsInvocation;
    }

    private JsConstructExpressionVisitor() {
    }

    @Override
    public void visitArrayAccess(@NotNull JsArrayAccess x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsConstructExpressionVisitor", "visitArrayAccess"));
        }
        this.accept(x.getArrayExpression());
    }

    @Override
    public void visitArray(@NotNull JsArrayLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsConstructExpressionVisitor", "visitArray"));
        }
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsConstructExpressionVisitor", "visitFunction"));
        }
    }

    @Override
    public void visitInvocation(@NotNull JsInvocation invocation) {
        if (invocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invocation", "org/jetbrains/kotlin/js/backend/JsConstructExpressionVisitor", "visitInvocation"));
        }
        this.containsInvocation = true;
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        if (nameRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameRef", "org/jetbrains/kotlin/js/backend/JsConstructExpressionVisitor", "visitNameRef"));
        }
        if (!nameRef.isLeaf()) {
            this.accept(nameRef.getQualifier());
        }
    }

    @Override
    public void visitNew(@NotNull JsNew x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsConstructExpressionVisitor", "visitNew"));
        }
    }

    @Override
    public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsConstructExpressionVisitor", "visitObjectLiteral"));
        }
    }

    @Override
    public <T extends JsNode> void accept(T node) {
        JsExpression expression2;
        int precedence;
        if (node instanceof JsExpression && (precedence = JsPrecedenceVisitor.exec(expression2 = (JsExpression)node)) < 15) {
            return;
        }
        super.accept(node);
    }
}

