/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsDynamicCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkSpreadOperator", "reportInOperation", "reportedOn", "", "element", "js.frontend"})
public final class JsDynamicCallChecker
implements CallChecker {
    public static final JsDynamicCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        IElementType iElementType;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object callee = resolvedCall2.getResultingDescriptor();
        if (!DynamicCallsKt.isDynamic((DeclarationDescriptor)callee)) {
            this.checkSpreadOperator(resolvedCall2, context);
            return;
        }
        KtElement element3 = resolvedCall2.getCall().getCallElement();
        KtElement ktElement = element3;
        if (ktElement instanceof KtArrayAccessExpression) {
            if (((KtArrayAccessExpression)element3).getIndexExpressions().size() > 1) {
                context.getTrace().report(ErrorsJs.WRONG_OPERATION_WITH_DYNAMIC.on(reportOn, "indexed access with more than one index"));
            }
        } else if (ktElement instanceof KtWhenConditionInRange) {
            this.reportInOperation(context, reportOn);
        } else if (ktElement instanceof KtBinaryExpression) {
            IElementType token = ((KtBinaryExpression)element3).getOperationToken();
            iElementType = token;
            if (CollectionsKt.contains((Iterable)((Iterable)OperatorConventions.IN_OPERATIONS), (Object)iElementType)) {
                this.reportInOperation(context, reportOn);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.RANGE))) {
                context.getTrace().report(ErrorsJs.WRONG_OPERATION_WITH_DYNAMIC.on(reportOn, "`..` operation"));
            }
        } else if (ktElement instanceof KtDestructuringDeclarationEntry) {
            PsiElement psiElement2 = ((KtDestructuringDeclarationEntry)element3).getNode().getTreeParent().getPsi();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.node.treeParent.psi");
            if (!this.reportedOn(context, psiElement2)) {
                context.getTrace().report(ErrorsJs.WRONG_OPERATION_WITH_DYNAMIC.on(((KtDestructuringDeclarationEntry)element3).getParent(), "destructuring declaration"));
            }
        }
        for (ValueArgument valueArgument : resolvedCall2.getCall().getValueArguments()) {
            if (valueArgument.getSpreadElement() == null) continue;
            IElementType it = iElementType;
            context.getTrace().report(ErrorsJs.SPREAD_OPERATOR_IN_DYNAMIC_CALL.on((PsiElement)it));
        }
    }

    private final void checkSpreadOperator(ResolvedCall<?> resolvedCall2, CallCheckerContext context) {
        for (ValueArgument valueArgument : resolvedCall2.getCall().getValueArguments()) {
            KtExpression argExpression;
            if (valueArgument.getArgumentExpression() == null) {
                continue;
            }
            KotlinType kotlinType = context.getTrace().getBindingContext().getType(argExpression);
            if (kotlinType == null) continue;
            if (!DynamicTypesKt.isDynamic(kotlinType)) continue;
            if (valueArgument.getSpreadElement() == null) continue;
            context.getTrace().report(ErrorsJs.WRONG_OPERATION_WITH_DYNAMIC.on((PsiElement)valueArgument.asElement(), "spread operator"));
        }
    }

    private final void reportInOperation(CallCheckerContext context, PsiElement reportOn) {
        context.getTrace().report(ErrorsJs.WRONG_OPERATION_WITH_DYNAMIC.on(reportOn, "`in` operation"));
    }

    private final boolean reportedOn(CallCheckerContext context, PsiElement element3) {
        boolean bl;
        block3: {
            Iterable $receiver$iv = context.getTrace().getBindingContext().getDiagnostics().forElement(element3);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    if (!Intrinsics.areEqual(it.getFactory(), ErrorsJs.WRONG_OPERATION_WITH_DYNAMIC)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private JsDynamicCallChecker() {
        INSTANCE = this;
    }

    static {
        new JsDynamicCallChecker();
    }
}

