/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.kotlin.JvmMetadataVersion;
import org.jetbrains.kotlin.load.kotlin.PackageParts;
import org.jetbrains.kotlin.protobuf.ProtocolStringList;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.serialization.jvm.JvmPackageTable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \r2\u00020\u0001:\u0001\rB#\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0004J\b\u0010\f\u001a\u00020\u0004H\u0016R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;", "", "packageFqName2Parts", "", "", "Lorg/jetbrains/kotlin/load/kotlin/PackageParts;", "debugName", "(Ljava/util/Map;Ljava/lang/String;)V", "getPackageFqName2Parts", "()Ljava/util/Map;", "findPackageParts", "packageFqName", "toString", "Companion", "descriptor.loader.java"})
public final class ModuleMapping {
    @NotNull
    private final Map<String, PackageParts> packageFqName2Parts;
    private final String debugName;
    @JvmField
    @NotNull
    public static final String MAPPING_FILE_EXT = "kotlin_module";
    @JvmField
    @NotNull
    public static final ModuleMapping EMPTY;
    @JvmField
    @NotNull
    public static final ModuleMapping CORRUPTED;
    public static final Companion Companion;

    @Nullable
    public final PackageParts findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        return this.packageFqName2Parts.get(packageFqName);
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    @NotNull
    public final Map<String, PackageParts> getPackageFqName2Parts() {
        return this.packageFqName2Parts;
    }

    private ModuleMapping(Map<String, PackageParts> packageFqName2Parts, String debugName) {
        this.packageFqName2Parts = packageFqName2Parts;
        this.debugName = debugName;
    }

    static {
        Companion = new Companion(null);
        MAPPING_FILE_EXT = MAPPING_FILE_EXT;
        EMPTY = new ModuleMapping(MapsKt.emptyMap(), "EMPTY");
        CORRUPTED = new ModuleMapping(MapsKt.emptyMap(), "CORRUPTED");
    }

    public /* synthetic */ ModuleMapping(@NotNull Map packageFqName2Parts, @NotNull String debugName, DefaultConstructorMarker $constructor_marker) {
        this(packageFqName2Parts, debugName);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping$Companion;", "", "()V", "CORRUPTED", "Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;", "EMPTY", "MAPPING_FILE_EXT", "", "create", "bytes", "", "debugName", "configuration", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;", "descriptor.loader.java"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping create(@Nullable byte[] bytes2, @NotNull String debugName, @NotNull DeserializationConfiguration configuration2) {
            int[] size$iv22;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)debugName, (String)"debugName");
            Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
            if (bytes2 == null) {
                return EMPTY;
            }
            DataInputStream stream2 = new DataInputStream(new ByteArrayInputStream(bytes2));
            try {
                int size$iv22 = stream2.readInt();
                int[] result$iv = new int[size$iv22];
                int n = 0;
                int n2 = result$iv.length;
                while (n < n2) {
                    int n3;
                    void i$iv;
                    void var10_14 = i$iv;
                    void var22_17 = i$iv++;
                    object = result$iv;
                    object[var22_17] = n3 = stream2.readInt();
                }
                size$iv22 = result$iv;
            }
            catch (IOException e) {
                return CORRUPTED;
            }
            int[] versionNumber = size$iv22;
            JvmMetadataVersion version = new JvmMetadataVersion(Arrays.copyOf(versionNumber, versionNumber.length));
            if (configuration2.getSkipMetadataVersionCheck() || version.isCompatible()) {
                PackageParts packageParts;
                PackageParts answer$iv;
                Object value$iv;
                Object $receiver$iv;
                Object key$iv;
                JvmPackageTable.PackageTable packageTable = JvmPackageTable.PackageTable.parseFrom(stream2);
                if (packageTable == null) {
                    return EMPTY;
                }
                JvmPackageTable.PackageTable table = packageTable;
                LinkedHashMap result2 = new LinkedHashMap();
                for (JvmPackageTable.PackageParts proto : table.getPackagePartsList()) {
                    Object object2;
                    Map $i$f$IntArray = result2;
                    String string = proto.getPackageFqName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"proto.packageFqName");
                    key$iv = string;
                    value$iv = $receiver$iv.get(key$iv);
                    if (value$iv == null) {
                        String string2 = proto.getPackageFqName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"proto.packageFqName");
                        answer$iv = new PackageParts(string2);
                        $receiver$iv.put(key$iv, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    packageParts = (PackageParts)object2;
                    key$iv = CollectionsKt.withIndex((Iterable)proto.getClassNameList()).iterator();
                    while (key$iv.hasNext()) {
                        String string3;
                        $receiver$iv = (IndexedValue)key$iv.next();
                        int index2 = $receiver$iv.component1();
                        String partShortName = (String)$receiver$iv.component2();
                        Integer n = (Integer)CollectionsKt.getOrNull(proto.getMultifileFacadeIdList(), (int)index2);
                        Integer multifileFacadeId = n != null ? Integer.valueOf(n - 1) : null;
                        Object object3 = packageParts;
                        String string4 = partShortName;
                        String string5 = string4;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"partShortName");
                        if (multifileFacadeId != null) {
                            Integer n4;
                            ProtocolStringList protocolStringList = proto.getMultifileFacadeNameList();
                            String string6 = string5;
                            object = object3;
                            int p1 = ((Number)n4).intValue();
                            String string7 = (String)CollectionsKt.getOrNull((List)protocolStringList, (int)p1);
                            object3 = object;
                            string5 = string6;
                            string3 = string7;
                        } else {
                            string3 = null;
                        }
                        ((PackageParts)object3).addPart(string5, string3);
                    }
                }
                for (JvmPackageTable.PackageParts proto : table.getMetadataPartsList()) {
                    Object object4;
                    $receiver$iv = result2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)proto.getPackageFqName(), (String)"proto.packageFqName");
                    value$iv = $receiver$iv.get(key$iv);
                    if (value$iv == null) {
                        String string = proto.getPackageFqName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"proto.packageFqName");
                        answer$iv = new PackageParts(string);
                        $receiver$iv.put(key$iv, answer$iv);
                        object4 = answer$iv;
                    } else {
                        object4 = value$iv;
                    }
                    packageParts = (PackageParts)object4;
                    $receiver$iv = proto.getClassNameList();
                    Iterator iterator2 = $receiver$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv = iterator2.next();
                        String p1 = (String)element$iv;
                        packageParts.addMetadataPart(p1);
                    }
                }
                return new ModuleMapping(result2, debugName, null);
            }
            return EMPTY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

