/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.SimpleDeclarationChecker;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u00020\u0004*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/InlineParameterChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/SimpleDeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "reportIncorrectInline", "Lorg/jetbrains/kotlin/psi/KtParameter;", "modifierToken", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "frontend"})
public final class InlineParameterChecker
implements SimpleDeclarationChecker {
    public static final InlineParameterChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        if (declaration2 instanceof KtFunction) {
            boolean inline = declaration2.hasModifier(KtTokens.INLINE_KEYWORD);
            for (KtParameter parameter : ((KtFunction)declaration2).getValueParameters()) {
                VariableDescriptor parameterDescriptor = (VariableDescriptor)bindingContext2.get(BindingContext.VALUE_PARAMETER, parameter);
                if (!inline || parameterDescriptor != null && !FunctionTypesKt.isBuiltinFunctionalType(parameterDescriptor.getType())) {
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.NOINLINE_KEYWORD;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.NOINLINE_KEYWORD");
                    this.reportIncorrectInline(parameter, ktModifierKeywordToken, diagnosticHolder);
                    KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.CROSSINLINE_KEYWORD;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken2), (String)"KtTokens.CROSSINLINE_KEYWORD");
                    this.reportIncorrectInline(parameter, ktModifierKeywordToken2, diagnosticHolder);
                }
                if (!inline || parameter.hasModifier(KtTokens.NOINLINE_KEYWORD)) continue;
                Annotated annotated = parameterDescriptor;
                if (annotated == null || (annotated = annotated.getType()) == null) continue;
                if (!FunctionTypesKt.isSuspendFunctionType((KotlinType)annotated)) continue;
                diagnosticHolder.report(Errors.INLINE_SUSPEND_FUNCTION_TYPE_UNSUPPORTED.on((KtParameter)((PsiElement)parameter)));
            }
        }
    }

    private final void reportIncorrectInline(@NotNull KtParameter $receiver, KtModifierKeywordToken modifierToken, DiagnosticSink diagnosticHolder) {
        block0: {
            PsiElement psiElement2;
            PsiElement modifier;
            KtModifierList ktModifierList = $receiver.getModifierList();
            PsiElement psiElement3 = modifier = ktModifierList != null ? ktModifierList.getModifier(modifierToken) : null;
            if (psiElement3 == null) break block0;
            PsiElement it = psiElement2 = psiElement3;
            diagnosticHolder.report(Errors.ILLEGAL_INLINE_PARAMETER_MODIFIER.on(modifier, modifierToken));
        }
    }

    private InlineParameterChecker() {
        INSTANCE = this;
    }

    static {
        new InlineParameterChecker();
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        SimpleDeclarationChecker.DefaultImpls.check(this, declaration2, descriptor2, diagnosticHolder, bindingContext2, languageVersionSettings);
    }
}

