/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.RotatedLabel;
import com.android.tools.adtui.common.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.Range;
import com.intellij.ui.components.JBLabel;
import gnu.trove.TFloatArrayList;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AxisComponent
extends AnimatedComponent {
    private static final BasicStroke DEFAULT_AXIS_STROKE = new BasicStroke(1.0f);
    private static final int MARKER_LABEL_OFFSET_PX = 3;
    private static final int MAXIMUM_LABEL_WIDTH = 50;
    @NotNull
    private final Range myRange;
    @Nullable
    private Range myGlobalRange;
    @NotNull
    private BaseAxisFormatter myFormatter;
    @NotNull
    private final AxisOrientation myOrientation;
    @Nullable
    private JLabel myLabel;
    @NotNull
    private final FontMetrics myMetrics;
    private final int myStartMargin;
    private final int myEndMargin;
    private final int myMajorMarkerLength;
    private final int myMinorMarkerLength;
    private final boolean myShowMin;
    private final boolean myShowMax;
    private final boolean myShowUnitAtMax;
    private boolean myShowAxisLine;
    private AxisComponent myParentAxis;
    private boolean myClampToMajorTicks;
    private double myCurrentMaxValueRelative;
    private double myCurrentMinValueRelative;
    private int myAxisLength;
    private float myMajorInterval;
    private float myMinorInterval;
    private float myMinorScale;
    private float myMajorNumTicksTarget;
    private double myFirstMarkerValue;
    private final TFloatArrayList myMajorMarkerPositions;
    private final TFloatArrayList myMinorMarkerPositions;
    @NotNull
    private final List<String> myMarkerLabels;
    private String myMaxLabel;
    private String myMinLabel;
    private final double myOffset;
    private boolean myFirstUpdate;

    private AxisComponent(@NotNull Builder builder) {
        if (builder == null) {
            AxisComponent.$$$reportNull$$$0(0);
        }
        this.myFirstUpdate = true;
        this.myRange = builder.myRange;
        this.myGlobalRange = builder.myGlobalRange;
        this.myOrientation = builder.myOrientation;
        this.myShowMin = builder.myShowMin;
        this.myShowMax = builder.myShowMax;
        this.myShowUnitAtMax = builder.myShowUnitAtMax;
        this.myShowAxisLine = builder.myShowAxisLine;
        this.myFormatter = builder.myFormatter;
        this.myMajorMarkerPositions = new TFloatArrayList();
        this.myMinorMarkerPositions = new TFloatArrayList();
        this.myMarkerLabels = new ArrayList<String>();
        this.myClampToMajorTicks = builder.myClampToMajorTicks;
        this.myParentAxis = builder.myParentAxis;
        this.myOffset = builder.myOffset;
        this.myMajorMarkerLength = builder.myMajorMarkerLength;
        this.myMinorMarkerLength = builder.myMinorMarkerLength;
        this.myStartMargin = builder.myStartMargin;
        this.myEndMargin = builder.myEndMargin;
        this.myMetrics = this.getFontMetrics((Font)AdtUiUtils.DEFAULT_FONT);
        if (builder.myLabel.length() > 0) {
            switch (this.myOrientation) {
                case LEFT: 
                case RIGHT: {
                    this.myLabel = new RotatedLabel(builder.myLabel);
                    this.myLabel.setSize(this.myMetrics.getHeight(), this.myMetrics.stringWidth(builder.myLabel));
                    break;
                }
                default: {
                    this.myLabel = new JBLabel(builder.myLabel);
                    this.myLabel.setSize(this.myMetrics.stringWidth(builder.myLabel), this.myMetrics.getHeight());
                }
            }
            this.myLabel.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        }
    }

    @Nullable
    public String getLabel() {
        return this.myLabel == null ? null : this.myLabel.getText();
    }

    @NotNull
    public Range getRange() {
        Range range = this.myRange;
        if (range == null) {
            AxisComponent.$$$reportNull$$$0(1);
        }
        return range;
    }

    @Nullable
    public Range getGlobalRange() {
        return this.myGlobalRange;
    }

    public boolean getShowMin() {
        return this.myShowMin;
    }

    public boolean getShowMax() {
        return this.myShowMax;
    }

    public boolean getShowAxisLine() {
        return this.myShowAxisLine;
    }

    public void setClampToMajorTicks(boolean clamp) {
        this.myClampToMajorTicks = clamp;
    }

    public boolean getClampToMajorTicks() {
        return this.myClampToMajorTicks;
    }

    public void setAxisFormatter(BaseAxisFormatter formatter) {
        this.myFormatter = formatter;
    }

    @NotNull
    public BaseAxisFormatter getAxisFormatter() {
        BaseAxisFormatter baseAxisFormatter = this.myFormatter;
        if (baseAxisFormatter == null) {
            AxisComponent.$$$reportNull$$$0(2);
        }
        return baseAxisFormatter;
    }

    public void setParentAxis(AxisComponent parent) {
        this.myParentAxis = parent;
    }

    @Nullable
    public AxisComponent getParentAxis() {
        return this.myParentAxis;
    }

    @NotNull
    public AxisOrientation getOrientation() {
        AxisOrientation axisOrientation = this.myOrientation;
        if (axisOrientation == null) {
            AxisComponent.$$$reportNull$$$0(3);
        }
        return axisOrientation;
    }

    @NotNull
    public TFloatArrayList getMajorMarkerPositions() {
        TFloatArrayList tFloatArrayList = this.myMajorMarkerPositions;
        if (tFloatArrayList == null) {
            AxisComponent.$$$reportNull$$$0(4);
        }
        return tFloatArrayList;
    }

    public float getPositionAtValue(double value) {
        float offset = (float)((double)this.myMinorScale * (value - this.myOffset - this.myCurrentMinValueRelative) / (double)this.myMinorInterval);
        float ret = 0.0f;
        switch (this.myOrientation) {
            case LEFT: 
            case RIGHT: {
                ret = 1.0f - offset;
                break;
            }
            case TOP: 
            case BOTTOM: {
                ret = offset;
            }
        }
        return ret * (float)this.myAxisLength;
    }

    public double getValueAtPosition(int position) {
        float offset = 0.0f;
        switch (this.myOrientation) {
            case LEFT: 
            case RIGHT: {
                offset = this.myAxisLength - position;
                break;
            }
            case TOP: 
            case BOTTOM: {
                offset = position;
            }
        }
        float normalizedOffset = offset / (float)this.myAxisLength;
        return this.myOffset + this.myCurrentMinValueRelative + (double)(this.myMinorInterval * normalizedOffset / this.myMinorScale);
    }

    @Override
    protected void updateData() {
        double clampedMaxTarget;
        long majorInterval;
        double maxTarget = this.myRange.getMax() - this.myOffset;
        double rangeTarget = this.myRange.getLength();
        if (this.myParentAxis == null) {
            majorInterval = this.myFormatter.getMajorInterval(rangeTarget);
            this.myMajorNumTicksTarget = this.myClampToMajorTicks ? (float)Math.ceil(maxTarget / (double)majorInterval) : (float)(maxTarget / (double)majorInterval);
            clampedMaxTarget = this.myMajorNumTicksTarget * (float)majorInterval;
        } else {
            majorInterval = this.myFormatter.getInterval(rangeTarget, (int)Math.floor(this.myParentAxis.myMajorNumTicksTarget));
            clampedMaxTarget = this.myParentAxis.myMajorNumTicksTarget * (float)majorInterval;
        }
        float fraction = this.myFirstUpdate ? 1.0f : 0.99f;
        this.myRange.setMax(Choreographer.lerp(this.myRange.getMax(), clampedMaxTarget += this.myOffset, fraction, this.mFrameLength, (float)(clampedMaxTarget * (double)0.001f)));
        this.myFirstUpdate = false;
    }

    @Override
    public void postAnimate() {
        this.myMarkerLabels.clear();
        this.myMajorMarkerPositions.reset();
        this.myMinorMarkerPositions.reset();
        this.myCurrentMinValueRelative = this.myRange.getMin() - this.myOffset;
        this.myCurrentMaxValueRelative = this.myRange.getMax() - this.myOffset;
        double range = this.myRange.getLength();
        double labelRange = this.myGlobalRange == null ? range : this.myGlobalRange.getLength();
        this.myMajorInterval = this.myFormatter.getMajorInterval(range);
        this.myMinorInterval = this.myFormatter.getMinorInterval(this.myMajorInterval);
        this.myMinorScale = (float)((double)this.myMinorInterval / range);
        this.myFirstMarkerValue = Math.floor(this.myCurrentMinValueRelative / (double)this.myMajorInterval) * (double)this.myMajorInterval;
        float firstMarkerOffset = (float)((double)this.myMinorScale * (this.myFirstMarkerValue - this.myCurrentMinValueRelative) / (double)this.myMinorInterval);
        int numMarkers = (int)Math.floor((this.myCurrentMaxValueRelative - this.myFirstMarkerValue) / (double)this.myMinorInterval) + 1;
        int numMinorPerMajor = (int)(this.myMajorInterval / this.myMinorInterval);
        for (int i = 0; i < numMarkers; ++i) {
            float markerOffset;
            double markerValue = this.myFirstMarkerValue + (double)((float)i * this.myMinorInterval);
            if (markerValue < 0.0 || (markerOffset = firstMarkerOffset + (float)i * this.myMinorScale) < 0.0f || markerOffset > 1.0f) continue;
            if (i % numMinorPerMajor == 0) {
                this.myMajorMarkerPositions.add(markerOffset);
                this.myMarkerLabels.add(this.myFormatter.getFormattedString(labelRange, markerValue, !this.myShowUnitAtMax));
                continue;
            }
            this.myMinorMarkerPositions.add(markerOffset);
        }
        if (this.myShowMin) {
            this.myMinLabel = this.myFormatter.getFormattedString(labelRange, this.myCurrentMinValueRelative, !this.myShowUnitAtMax);
        }
        if (this.myShowMax) {
            this.myMaxLabel = this.myFormatter.getFormattedString(labelRange, this.myCurrentMaxValueRelative, true);
        }
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        Point startPoint = new Point();
        Point endPoint = new Point();
        Point labelPoint = new Point();
        switch (this.myOrientation) {
            case LEFT: {
                startPoint.x = endPoint.x = dim.width - 1;
                startPoint.y = dim.height - this.myStartMargin - 1;
                endPoint.y = this.myEndMargin;
                this.myAxisLength = startPoint.y - endPoint.y;
                labelPoint.x = 0;
                labelPoint.y = endPoint.y;
                break;
            }
            case BOTTOM: {
                startPoint.x = this.myStartMargin;
                endPoint.x = dim.width - this.myEndMargin - 1;
                endPoint.y = 0;
                startPoint.y = 0;
                this.myAxisLength = endPoint.x - startPoint.x;
                labelPoint.x = startPoint.x;
                labelPoint.y = this.getHeight() - (this.myMetrics.getMaxAscent() + this.myMetrics.getMaxDescent());
                break;
            }
            case RIGHT: {
                endPoint.x = 0;
                startPoint.x = 0;
                startPoint.y = dim.height - this.myStartMargin - 1;
                endPoint.y = this.myEndMargin;
                this.myAxisLength = startPoint.y - endPoint.y;
                labelPoint.x = this.getWidth() - this.myMetrics.getMaxAdvance();
                labelPoint.y = endPoint.y;
                break;
            }
            case TOP: {
                startPoint.x = this.myStartMargin;
                endPoint.x = dim.width - this.myEndMargin - 1;
                startPoint.y = endPoint.y = dim.height - 1;
                this.myAxisLength = endPoint.x - startPoint.x;
                labelPoint.x = 0;
                labelPoint.y = 0;
            }
        }
        if (this.myAxisLength > 0) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(AdtUiUtils.DEFAULT_BORDER_COLOR);
            g.setStroke(DEFAULT_AXIS_STROKE);
            if (this.myShowAxisLine) {
                g.drawLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
            }
            this.drawMarkers(g, startPoint);
            if (this.myLabel != null) {
                AffineTransform initialTransform = g.getTransform();
                g.translate(labelPoint.x, labelPoint.y);
                this.myLabel.paint(g);
                g.setTransform(initialTransform);
            }
        }
    }

    private void drawMarkers(Graphics2D g2d, Point origin) {
        float scaledPosition;
        int i;
        g2d.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        if (this.myShowMin && this.myMinLabel != null) {
            this.drawMarkerLabel(g2d, 0.0f, origin, this.myMinLabel, true);
        }
        if (this.myShowMax && this.myMaxLabel != null) {
            this.drawMarkerLabel(g2d, this.myAxisLength, origin, this.myMaxLabel, true);
        }
        Line2D.Float line = new Line2D.Float();
        for (i = 0; i < this.myMinorMarkerPositions.size(); ++i) {
            scaledPosition = this.myMinorMarkerPositions.get(i) * (float)this.myAxisLength;
            this.drawMarkerLine(g2d, line, scaledPosition, origin, this.myMinorMarkerLength);
        }
        for (i = 0; i < this.myMajorMarkerPositions.size(); ++i) {
            scaledPosition = this.myMajorMarkerPositions.get(i) * (float)this.myAxisLength;
            this.drawMarkerLine(g2d, line, scaledPosition, origin, this.myMajorMarkerLength);
            this.drawMarkerLabel(g2d, scaledPosition, origin, this.myMarkerLabels.get(i), false);
        }
    }

    private void drawMarkerLine(Graphics2D g2d, Line2D.Float line, float markerOffset, Point origin, int markerLength) {
        float markerStartX = 0.0f;
        float markerStartY = 0.0f;
        float markerEndX = 0.0f;
        float markerEndY = 0.0f;
        switch (this.myOrientation) {
            case LEFT: {
                markerStartX = origin.x - markerLength;
                markerStartY = markerEndY = (float)origin.y - markerOffset;
                markerEndX = origin.x;
                break;
            }
            case RIGHT: {
                markerStartX = 0.0f;
                markerStartY = markerEndY = (float)origin.y - markerOffset;
                markerEndX = markerLength;
                break;
            }
            case TOP: {
                markerStartX = markerEndX = (float)origin.x + markerOffset;
                markerStartY = origin.y - markerLength;
                markerEndY = origin.y;
                break;
            }
            case BOTTOM: {
                markerStartX = markerEndX = (float)origin.x + markerOffset;
                markerStartY = 0.0f;
                markerEndY = markerLength;
            }
        }
        line.setLine(markerStartX, markerStartY, markerEndX, markerEndY);
        g2d.draw(line);
    }

    private void drawMarkerLabel(Graphics2D g2d, float markerOffset, Point origin, String value, boolean alwaysRender) {
        float reserved;
        float labelY;
        float labelX;
        int stringAscent = this.myMetrics.getAscent();
        int stringLength = this.myMetrics.stringWidth(value);
        switch (this.myOrientation) {
            case LEFT: {
                labelX = origin.x - (this.myMajorMarkerLength + stringLength + 3);
                labelY = (float)origin.y - markerOffset + (float)stringAscent * 0.5f;
                reserved = stringAscent;
                break;
            }
            case RIGHT: {
                labelX = this.myMajorMarkerLength + 3;
                labelY = (float)origin.y - markerOffset + (float)stringAscent * 0.5f;
                reserved = stringAscent;
                break;
            }
            case TOP: {
                labelX = (float)origin.x + markerOffset + 3.0f;
                labelY = origin.y - this.myMinorMarkerLength;
                reserved = stringLength;
                break;
            }
            case BOTTOM: {
                labelX = (float)origin.x + markerOffset + 3.0f;
                labelY = this.myMinorMarkerLength + stringAscent;
                reserved = stringLength;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected orientation: " + (Object)((Object)this.myOrientation)));
            }
        }
        if (alwaysRender || markerOffset - reserved > 0.0f && markerOffset + reserved < (float)this.myAxisLength) {
            g2d.setColor(AdtUiUtils.DEFAULT_FONT_COLOR);
            g2d.drawString(value, labelX, labelY);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int width = Math.max(this.myMajorMarkerLength, this.myMinorMarkerLength) + 3 + 50;
        int height = 1;
        return this.myOrientation == AxisOrientation.LEFT || this.myOrientation == AxisOrientation.RIGHT ? new Dimension(width, height) : new Dimension(height, width);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/AxisComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/AxisComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAxisFormatter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrientation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorMarkerPositions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private static final int DEFAULT_MAJOR_MARKER_LENGTH = 10;
        private static final int DEFAULT_MINOR_MARKER_LENGTH = 4;
        @NotNull
        private final Range myRange;
        @NotNull
        private final BaseAxisFormatter myFormatter;
        @NotNull
        private final AxisOrientation myOrientation;
        private Range myGlobalRange;
        private int myMajorMarkerLength;
        private int myMinorMarkerLength;
        private int myStartMargin;
        private int myEndMargin;
        private boolean myShowMin;
        private boolean myShowMax;
        private boolean myShowUnitAtMax;
        private boolean myShowAxisLine;
        private boolean myClampToMajorTicks;
        private double myOffset;
        @NotNull
        private String myLabel;
        @Nullable
        private AxisComponent myParentAxis;

        public Builder(@NotNull Range range, @NotNull BaseAxisFormatter formatter, @NotNull AxisOrientation orientation) {
            if (range == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (formatter == null) {
                Builder.$$$reportNull$$$0(1);
            }
            if (orientation == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myMajorMarkerLength = 10;
            this.myMinorMarkerLength = 4;
            this.myShowAxisLine = true;
            this.myClampToMajorTicks = false;
            this.myOffset = 0.0;
            this.myLabel = "";
            this.myRange = range;
            this.myFormatter = formatter;
            this.myOrientation = orientation;
        }

        public Builder setGlobalRange(@NotNull Range globalRange) {
            if (globalRange == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myGlobalRange = globalRange;
            return this;
        }

        public Builder setLabel(@NotNull String label) {
            if (label == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myLabel = label;
            return this;
        }

        public Builder setParentAxis(@NotNull AxisComponent parent) {
            if (parent == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myParentAxis = parent;
            return this;
        }

        public Builder setMarkerLengths(int majorMarker, int minorMarker) {
            this.myMajorMarkerLength = majorMarker;
            this.myMinorMarkerLength = minorMarker;
            return this;
        }

        public Builder setMargins(int startMargin, int endMargin) {
            this.myStartMargin = startMargin;
            this.myEndMargin = endMargin;
            return this;
        }

        public Builder setOffset(double offset) {
            this.myOffset = offset;
            return this;
        }

        public Builder showMin(boolean showMin) {
            this.myShowMin = showMin;
            return this;
        }

        public Builder showMax(boolean showMax) {
            this.myShowMax = showMax;
            return this;
        }

        public Builder showUnitAtMax(boolean showUnitAtMax) {
            this.myShowUnitAtMax = showUnitAtMax;
            return this;
        }

        public Builder showAxisLine(boolean showAxisLine) {
            this.myShowAxisLine = showAxisLine;
            return this;
        }

        public Builder clampToMajorTicks(boolean clampToMajorTicks) {
            this.myClampToMajorTicks = clampToMajorTicks;
            return this;
        }

        public AxisComponent build() {
            return new AxisComponent(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orientation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "globalRange";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/AxisComponent$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setGlobalRange";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setLabel";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setParentAxis";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum AxisOrientation {
        LEFT,
        BOTTOM,
        RIGHT,
        TOP;

    }
}

