/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.hchart;

import com.android.tools.adtui.common.AdtUiUtils;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public abstract class HRenderer<T> {
    protected static final JBColor fillVendorColor = new JBColor(new Color(146, 215, 248), new Color(146, 215, 248));
    protected static final JBColor bordVendorColor = new JBColor(new Color(115, 190, 233), new Color(115, 190, 233));
    protected static final JBColor fillPlatformColor = new JBColor(new Color(190, 225, 154), new Color(190, 225, 154));
    protected static final JBColor bordPlatformColor = new JBColor(new Color(159, 208, 110), new Color(159, 208, 110));
    protected static final JBColor fillAppColor = new JBColor(new Color(245, 192, 118), new Color(245, 192, 118));
    protected static final JBColor bordAppColor = new JBColor(new Color(235, 163, 63), new Color(235, 163, 63));
    protected Rectangle2D.Float mRect = new Rectangle2D.Float();
    Font mFont;

    public void setFont(Font font) {
        this.mFont = font;
    }

    public void render(Graphics2D g, T node, Rectangle2D drawingArea) {
        this.mRect.x = (float)drawingArea.getX();
        this.mRect.y = (float)drawingArea.getY();
        this.mRect.width = (float)drawingArea.getWidth();
        this.mRect.height = (float)drawingArea.getHeight();
        Color fillColor = this.getFillColor(node);
        g.setPaint(fillColor);
        g.fill(this.mRect);
        Color bordColor = this.getBordColor(node);
        g.setPaint(bordColor);
        g.draw(this.mRect);
        FontMetrics fontMetrics = g.getFontMetrics(this.mFont);
        String text = this.generateFittingText(node, drawingArea, fontMetrics);
        int textWidth = fontMetrics.stringWidth(text);
        long middle = (long)drawingArea.getCenterX();
        long textPositionX = middle - (long)(textWidth / 2);
        int textPositionY = (int)(drawingArea.getY() + (double)fontMetrics.getAscent());
        Font prevFont = g.getFont();
        g.setFont(this.mFont);
        g.setPaint(AdtUiUtils.DEFAULT_FONT_COLOR);
        g.drawString(text, (float)textPositionX, (float)textPositionY);
        g.setFont(prevFont);
    }

    protected abstract String generateFittingText(T var1, Rectangle2D var2, FontMetrics var3);

    protected abstract Color getFillColor(T var1);

    protected abstract Color getBordColor(T var1);
}

