/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.annotations.DataProvider;

public class DuplicatedDataProviderNamesInspection
extends BaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(DuplicatedDataProviderNamesInspection.class);
    private static final String NAME_ATTRIBUTE = "name";

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            DuplicatedDataProviderNamesInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DuplicatedDataProviderNamesInspection.$$$reportNull$$$0(1);
        }
        String dataProviderFqn = DataProvider.class.getCanonicalName();
        MultiMap dataProvidersByName = new MultiMap();
        for (HierarchicalMethodSignature signature : aClass.getVisibleSignatures()) {
            PsiMethod method = signature.getMethod();
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{dataProviderFqn});
            if (annotation == null) continue;
            PsiAnnotationMemberValue value = annotation.findAttributeValue(NAME_ATTRIBUTE);
            LOG.assertTrue(value != null);
            String dataProviderName = PsiTreeUtil.isAncestor((PsiElement)annotation, (PsiElement)value, (boolean)false) ? AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)NAME_ATTRIBUTE) : method.getName();
            if (dataProviderName == null) continue;
            dataProvidersByName.putValue((Object)dataProviderName, (Object)method);
        }
        SmartList descriptors = new SmartList();
        for (Map.Entry entry : dataProvidersByName.entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            for (PsiMethod method : (Collection)entry.getValue()) {
                if (method.getContainingClass() != aClass) continue;
                String description = String.format("Data provider with name '%s' already exists in context", entry.getKey());
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{dataProviderFqn});
                LOG.assertTrue(annotation != null);
                PsiAnnotationMemberValue nameElement = annotation.findAttributeValue(NAME_ATTRIBUTE);
                LOG.assertTrue(nameElement != null);
                PsiAnnotationMemberValue problemElement = PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)nameElement, (boolean)false) ? nameElement : method.getNameIdentifier();
                LOG.assertTrue(problemElement != null);
                descriptors.add(manager.createProblemDescriptor((PsiElement)problemElement, description, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.ERROR));
            }
        }
        return descriptors.isEmpty() ? null : descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/theoryinpractice/testng/inspection/DuplicatedDataProviderNamesInspection";
        objectArray[2] = "checkClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

