/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.util;

import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceMessages;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.xml.ElementPresentationManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UnitSettingMapConfigurable<F extends PersistenceFacet, T>
implements Configurable {
    protected final F myFacet;
    protected final TableView<Info<T>> myView;
    private final JPanel myPanel;

    public UnitSettingMapConfigurable(F facet) {
        this.myFacet = facet;
        final DefaultTableCellRenderer unitRenderer = new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object value) {
                Info info = (Info)value;
                this.setIcon(info.unitIcon);
                this.setText(info.unitName);
            }
        };
        ListTableModel tableModel = new ListTableModel(new ColumnInfo[]{new ColumnInfo<Info, Info>(TypePresentationService.getService().getTypePresentableName(this.myFacet.getPersistenceUnitClass())){

            public TableCellRenderer getRenderer(Info info) {
                return unitRenderer;
            }

            public boolean isCellEditable(Info info) {
                return false;
            }

            public Info valueOf(Info info) {
                return info;
            }
        }, new ColumnInfo<Info<T>, T>(this.getValueColumnName()){

            public T valueOf(Info<T> info) {
                return info.value;
            }

            public boolean isCellEditable(Info info) {
                return true;
            }

            public TableCellRenderer getRenderer(Info info) {
                return UnitSettingMapConfigurable.this.getComboBoxTableRenderer();
            }

            public TableCellEditor getEditor(Info info) {
                return UnitSettingMapConfigurable.this.getComboBoxTableRenderer();
            }

            public void setValue(Info<T> info, T value) {
                info.value = value;
            }
        }});
        tableModel.setSortable(true);
        this.myView = new TableView(tableModel);
        this.myView.setSelectionMode(0);
        this.myView.setExpandableItemsEnabled(false);
        this.myPanel = new JPanel(new BorderLayout());
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myView);
        this.initDecorator(decorator);
        this.myPanel.add((Component)decorator.createPanel(), "Center");
    }

    protected void initDecorator(ToolbarDecorator decorator) {
        decorator.disableAddAction();
        decorator.disableRemoveAction();
        decorator.disableUpDownActions();
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    @NotNull
    protected abstract ComboBoxTableRenderer<T> getComboBoxTableRenderer();

    @NotNull
    protected abstract String getValueColumnName();

    @Nullable
    protected abstract T getSettingValue(PersistencePackage var1);

    protected abstract void setSettingValue(PersistencePackage var1, T var2);

    private void reinitInfos() {
        int[] anonymousCounter = new int[]{0};
        List infos = ContainerUtil.mapNotNull((Collection)this.myFacet.getPersistenceUnits(), unit -> {
            String unitName = (String)unit.getName().getValue();
            if (StringUtil.isEmpty((String)unitName)) {
                PsiFile file = unit.getContainingFile();
                String fileName = file != null ? file.getName() : "<nowhere>";
                Object[] objectArray = new Object[2];
                anonymousCounter[0] = anonymousCounter[0] + 1;
                objectArray[0] = anonymousCounter[0];
                objectArray[1] = fileName;
                unitName = PersistenceMessages.message((String)"anonymous.unit.title", (Object[])objectArray);
            }
            return new Info<T>((PersistencePackage)unit, unitName, this.getSettingValue((PersistencePackage)unit));
        });
        this.myView.getListTableModel().setItems(infos);
    }

    public void apply() throws ConfigurationException {
        for (Info info : this.myView.getListTableModel().getItems()) {
            if (!info.unit.isValid()) continue;
            this.setSettingValue(info.unit, info.value);
        }
        this.reinitInfos();
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        for (Info info : this.myView.getListTableModel().getItems()) {
            if (info.value == this.getSettingValue(info.unit)) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.reinitInfos();
    }

    public void disposeUIResources() {
    }

    protected T getSelectedValue() {
        Info info = (Info)this.myView.getSelectedObject();
        return info == null ? null : (T)info.value;
    }

    private static class Info<T> {
        final PersistencePackage unit;
        final String unitName;
        final Icon unitIcon;
        T value;

        public Info(PersistencePackage unit, String unitName, T value) {
            this.unit = unit;
            this.unitIcon = ElementPresentationManager.getIcon((Object)unit);
            this.unitName = unitName;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Info info = (Info)o;
            if (this.value != null ? !this.value.equals(info.value) : info.value != null) {
                return false;
            }
            if (!this.unit.equals(info.unit)) {
                return false;
            }
            return this.unitName.equals(info.unitName);
        }

        public int hashCode() {
            int result = this.unit.hashCode();
            result = 31 * result + this.unitName.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }
}

