/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.css.descriptor.CssContextType;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssFileType
extends LanguageFileType {
    @NonNls
    public static final String DEFAULT_EXTENSION = "css";
    public static final LanguageFileType INSTANCE = new CssFileType();
    @NonNls
    private static final String DESCRIPTION = "Cascading style sheet";

    public CssFileType() {
        super((Language)CSSLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        if ("CSS" == null) {
            CssFileType.$$$reportNull$$$0(0);
        }
        return "CSS";
    }

    @NotNull
    public String getDescription() {
        if (DESCRIPTION == null) {
            CssFileType.$$$reportNull$$$0(1);
        }
        return DESCRIPTION;
    }

    @NotNull
    public String getDefaultExtension() {
        if (DEFAULT_EXTENSION == null) {
            CssFileType.$$$reportNull$$$0(2);
        }
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Css;
    }

    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        Charset charset;
        if (file == null) {
            CssFileType.$$$reportNull$$$0(3);
        }
        if (content == null) {
            CssFileType.$$$reportNull$$$0(4);
        }
        return (charset = CssFileType.getCharsetFromCssContent(content)) != null ? charset.name() : null;
    }

    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file, @NotNull CharSequence content) {
        if (content == null) {
            CssFileType.$$$reportNull$$$0(5);
        }
        return CssFileType.getCharsetFromCssContent(content);
    }

    public static Charset getCharsetFromCssContent(byte[] content) {
        String strContent;
        Charset fromBOM = CharsetToolkit.guessFromBOM((byte[])content);
        if (fromBOM != null) {
            return fromBOM;
        }
        try {
            strContent = new String(content, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return CssFileType.getCharsetFromCssContent(strContent);
    }

    @Nullable
    public static Charset getCharsetFromCssContent(@NotNull CharSequence content) {
        if (content == null) {
            CssFileType.$$$reportNull$$$0(6);
        }
        int charsetKeywordLength = CssContextType.CHARSET.toString().length();
        if (StringUtil.startsWith((CharSequence)content, (CharSequence)CssContextType.CHARSET.toString()) && content.length() > charsetKeywordLength) {
            int i;
            char ch = content.charAt(i);
            for (i = charsetKeywordLength; i < content.length() && Character.isWhitespace(ch = content.charAt(i)); ++i) {
            }
            if (ch != '\"') {
                return null;
            }
            if (++i >= content.length()) {
                return null;
            }
            ch = content.charAt(i);
            String name = "";
            while (i < content.length() && !Character.isWhitespace(ch) && ch != '\"') {
                name = name + ch;
                if (++i + 1 >= content.length()) continue;
                ch = content.charAt(i);
            }
            if (ch != '\"') {
                return null;
            }
            return CharsetToolkit.forName((String)name);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/CssFileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExtension";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/CssFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCharset";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractCharsetFromFileContent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCharsetFromCssContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

