/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.jvm.JNILibLoaderBase;
import com.jogamp.common.os.DynamicLibraryBundleInfo;
import com.jogamp.common.os.DynamicLinker;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.util.RunnableExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class DynamicLibraryBundle
implements DynamicLookupHelper {
    private final DynamicLibraryBundleInfo info;
    protected final List<NativeLibrary> nativeLibraries;
    private final DynamicLinker dynLinkGlobal;
    private final List<List<String>> toolLibNames;
    private final List<String> glueLibNames;
    private final boolean[] toolLibLoaded;
    private int toolLibLoadedNumber;
    private final boolean[] glueLibLoaded;
    private int glueLibLoadedNumber;
    private long toolGetProcAddressHandle;
    private boolean toolGetProcAddressComplete;
    private HashSet<String> toolGetProcAddressFuncNameSet;
    private final List<String> toolGetProcAddressFuncNameList;

    public static RunnableExecutor getDefaultRunnableExecutor() {
        return RunnableExecutor.currentThreadExecutor;
    }

    /*
     * WARNING - void declaration
     */
    public DynamicLibraryBundle(DynamicLibraryBundleInfo dynamicLibraryBundleInfo) {
        void string4;
        void object;
        if (null == dynamicLibraryBundleInfo) {
            throw new RuntimeException("Null DynamicLibraryBundleInfo");
        }
        this.info = dynamicLibraryBundleInfo;
        if (DEBUG) {
            String string = String.valueOf(Thread.currentThread().getName());
            String string2 = String.valueOf(dynamicLibraryBundleInfo.getClass().getName());
            System.err.println(new StringBuilder(41 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" - DynamicLibraryBundle.init start with: ").append(string2).toString());
        }
        this.nativeLibraries = new ArrayList<NativeLibrary>();
        this.toolLibNames = dynamicLibraryBundleInfo.getToolLibNames();
        this.glueLibNames = dynamicLibraryBundleInfo.getGlueLibNames();
        this.toolLibLoaded = new boolean[this.toolLibNames.size()];
        if (DEBUG) {
            if (this.toolLibNames.size() == 0) {
                System.err.println("No Tool native library names given");
            }
            if (this.glueLibNames.size() == 0) {
                System.err.println("No Glue native library names given");
            }
        }
        int n = this.toolLibNames.size() - 1;
        while (object >= 0) {
            this.toolLibLoaded[object] = false;
            --object;
        }
        this.glueLibLoaded = new boolean[this.glueLibNames.size()];
        int n3 = this.glueLibNames.size() - 1;
        while (string4 >= 0) {
            this.glueLibLoaded[string4] = false;
            --string4;
        }
        final DynamicLinker[] bl2 = new DynamicLinker[]{null};
        dynamicLibraryBundleInfo.getLibLoaderExecutor().invoke(true, new Runnable(){

            @Override
            public void run() {
                bl2[0] = DynamicLibraryBundle.this.loadLibraries();
            }
        });
        this.dynLinkGlobal = bl2[0];
        this.toolGetProcAddressFuncNameList = dynamicLibraryBundleInfo.getToolGetProcAddressFuncNameList();
        if (null != this.toolGetProcAddressFuncNameList) {
            this.toolGetProcAddressFuncNameSet = new HashSet<String>(this.toolGetProcAddressFuncNameList);
            this.toolGetProcAddressHandle = this.getToolGetProcAddressHandle();
            this.toolGetProcAddressComplete = 0L != this.toolGetProcAddressHandle;
        } else {
            this.toolGetProcAddressFuncNameSet = new HashSet();
            this.toolGetProcAddressHandle = 0L;
            this.toolGetProcAddressComplete = true;
        }
        if (DEBUG) {
            String string = String.valueOf(dynamicLibraryBundleInfo.getClass().getName());
            System.err.println(string.length() != 0 ? "DynamicLibraryBundle.init Summary: ".concat(string) : new String("DynamicLibraryBundle.init Summary: "));
            String string3 = String.valueOf(this.toolGetProcAddressFuncNameList);
            int n2 = this.toolGetProcAddressComplete;
            String string5 = String.valueOf(Long.toHexString(this.toolGetProcAddressHandle));
            System.err.println(new StringBuilder(58 + String.valueOf(string3).length() + String.valueOf(string5).length()).append("     toolGetProcAddressFuncNameList: ").append(string3).append(", complete: ").append(n2 != 0).append(", 0x").append(string5).toString());
            String string6 = String.valueOf(this.toolLibNames);
            System.err.println(new StringBuilder(22 + String.valueOf(string6).length()).append("     Tool Lib Names : ").append(string6).toString());
            int n4 = this.getToolLibLoadedNumber();
            n2 = this.getToolLibNumber();
            string5 = String.valueOf(Arrays.toString(this.toolLibLoaded));
            boolean bl = this.isToolLibComplete();
            System.err.println(new StringBuilder(62 + String.valueOf(string5).length()).append("     Tool Lib Loaded: ").append(n4).append("/").append(n2).append(" ").append(string5).append(", complete ").append(bl).toString());
            String string7 = String.valueOf(this.glueLibNames);
            System.err.println(new StringBuilder(22 + String.valueOf(string7).length()).append("     Glue Lib Names : ").append(string7).toString());
            int n5 = this.getGlueLibLoadedNumber();
            n2 = this.getGlueLibNumber();
            string5 = String.valueOf(Arrays.toString(this.glueLibLoaded));
            bl = this.isGlueLibComplete();
            System.err.println(new StringBuilder(62 + String.valueOf(string5).length()).append("     Glue Lib Loaded: ").append(n5).append("/").append(n2).append(" ").append(string5).append(", complete ").append(bl).toString());
            boolean bl3 = this.isLibComplete();
            System.err.println(new StringBuilder(24).append("     All Complete: ").append(bl3).toString());
            String string8 = String.valueOf(dynamicLibraryBundleInfo.getLibLoaderExecutor().getClass().getName());
            System.err.println(string8.length() != 0 ? "     LibLoaderExecutor: ".concat(string8) : new String("     LibLoaderExecutor: "));
        }
    }

    public final void destroy() {
        String string;
        if (DEBUG) {
            String string2 = String.valueOf(Thread.currentThread().getName());
            string = String.valueOf(this.info.getClass().getName());
            System.err.println(new StringBuilder(41 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(" - DynamicLibraryBundle.destroy() START: ").append(string).toString());
        }
        this.toolGetProcAddressFuncNameSet = null;
        this.toolGetProcAddressHandle = 0L;
        this.toolGetProcAddressComplete = false;
        for (int i = 0; i < this.nativeLibraries.size(); ++i) {
            this.nativeLibraries.get(i).close();
        }
        this.nativeLibraries.clear();
        this.toolLibNames.clear();
        this.glueLibNames.clear();
        if (DEBUG) {
            String string3 = String.valueOf(Thread.currentThread().getName());
            string = String.valueOf(this.info.getClass().getName());
            System.err.println(new StringBuilder(39 + String.valueOf(string3).length() + String.valueOf(string).length()).append(string3).append(" - DynamicLibraryBundle.destroy() END: ").append(string).toString());
        }
    }

    public final boolean isLibComplete() {
        return this.isToolLibComplete() && this.isGlueLibComplete();
    }

    public final int getToolLibNumber() {
        return this.toolLibNames.size();
    }

    public final int getToolLibLoadedNumber() {
        return this.toolLibLoadedNumber;
    }

    public final boolean isToolLibComplete() {
        int n = this.getToolLibNumber();
        return this.toolGetProcAddressComplete && (0 == n || null != this.dynLinkGlobal) && n == this.getToolLibLoadedNumber();
    }

    public final boolean isToolLibLoaded() {
        return 0 < this.toolLibLoadedNumber;
    }

    public final boolean isToolLibLoaded(int n) {
        if (0 <= n && n < this.toolLibLoaded.length) {
            return this.toolLibLoaded[n];
        }
        return false;
    }

    public final int getGlueLibNumber() {
        return this.glueLibNames.size();
    }

    public final int getGlueLibLoadedNumber() {
        return this.glueLibLoadedNumber;
    }

    public final boolean isGlueLibComplete() {
        return 0 == this.getGlueLibNumber() || this.isGlueLibLoaded(this.getGlueLibNumber() - 1);
    }

    public final boolean isGlueLibLoaded(int n) {
        if (0 <= n && n < this.glueLibLoaded.length) {
            return this.glueLibLoaded[n];
        }
        return false;
    }

    public final DynamicLibraryBundleInfo getBundleInfo() {
        return this.info;
    }

    protected final long getToolGetProcAddressHandle() throws SecurityException {
        if (!this.isToolLibLoaded()) {
            return 0L;
        }
        long l = 0L;
        for (int i = 0; i < this.toolGetProcAddressFuncNameList.size(); ++i) {
            String string = this.toolGetProcAddressFuncNameList.get(i);
            l = this.dynamicLookupFunctionOnLibs(string);
            if (!DEBUG) continue;
            String string2 = String.valueOf(Long.toHexString(l));
            System.err.println(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string2).length()).append("getToolGetProcAddressHandle: ").append(string).append(" -> 0x").append(string2).toString());
        }
        return l;
    }

    protected static final NativeLibrary loadFirstAvailable(List<String> list, ClassLoader classLoader, boolean bl) throws SecurityException {
        for (int i = 0; i < list.size(); ++i) {
            NativeLibrary nativeLibrary = NativeLibrary.open(list.get(i), classLoader, bl);
            if (nativeLibrary == null) continue;
            return nativeLibrary;
        }
        return null;
    }

    final DynamicLinker loadLibraries() throws SecurityException {
        List<String> list;
        int n;
        this.toolLibLoadedNumber = 0;
        ClassLoader classLoader = this.info.getClass().getClassLoader();
        NativeLibrary nativeLibrary = null;
        DynamicLinker dynamicLinker = null;
        for (n = 0; n < this.toolLibNames.size(); ++n) {
            String string;
            list = this.toolLibNames.get(n);
            if (null == list || list.size() <= 0) continue;
            nativeLibrary = DynamicLibraryBundle.loadFirstAvailable(list, classLoader, this.info.shallLinkGlobal());
            if (null == nativeLibrary) {
                if (!DEBUG) continue;
                string = String.valueOf(list);
                System.err.println(new StringBuilder(36 + String.valueOf(string).length()).append("Unable to load any Tool library of: ").append(string).toString());
                continue;
            }
            if (null == dynamicLinker) {
                dynamicLinker = nativeLibrary.getDynamicLinker();
            }
            this.nativeLibraries.add(nativeLibrary);
            this.toolLibLoaded[n] = true;
            ++this.toolLibLoadedNumber;
            if (!DEBUG) continue;
            string = String.valueOf(nativeLibrary);
            System.err.println(new StringBuilder(21 + String.valueOf(string).length()).append("Loaded Tool library: ").append(string).toString());
        }
        if (this.toolLibNames.size() > 0 && !this.isToolLibLoaded()) {
            if (DEBUG) {
                System.err.println("No Tool libraries loaded");
            }
            return dynamicLinker;
        }
        this.glueLibLoadedNumber = 0;
        for (n = 0; n < this.glueLibNames.size(); ++n) {
            boolean bl;
            block9: {
                list = this.glueLibNames.get(n);
                try {
                    bl = GlueJNILibLoader.loadLibrary((String)((Object)list), true, classLoader);
                    if (DEBUG && !bl) {
                        String string = String.valueOf(list);
                        System.err.println(string.length() != 0 ? "Info: Could not load JNI/Glue library: ".concat(string) : new String("Info: Could not load JNI/Glue library: "));
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    bl = false;
                    if (!DEBUG) break block9;
                    String string = String.valueOf(list);
                    System.err.println(string.length() != 0 ? "Unable to load JNI/Glue library: ".concat(string) : new String("Unable to load JNI/Glue library: "));
                    unsatisfiedLinkError.printStackTrace();
                }
            }
            this.glueLibLoaded[n] = bl;
            if (!bl) continue;
            ++this.glueLibLoadedNumber;
        }
        return dynamicLinker;
    }

    private final long dynamicLookupFunctionOnLibs(String string) throws SecurityException {
        if (!this.isToolLibLoaded() || null == string) {
            if (DEBUG_LOOKUP && !this.isToolLibLoaded()) {
                System.err.println(new StringBuilder(61 + String.valueOf(string).length()).append("Lookup-Native: <").append(string).append("> ** FAILED ** Tool native library not loaded").toString());
            }
            return 0L;
        }
        long l = 0L;
        NativeLibrary nativeLibrary = null;
        if (this.info.shallLookupGlobal()) {
            l = this.dynLinkGlobal.lookupSymbolGlobal(string);
        }
        for (int i = 0; 0L == l && i < this.nativeLibraries.size(); ++i) {
            nativeLibrary = this.nativeLibraries.get(i);
            l = nativeLibrary.dynamicLookupFunction(string);
        }
        if (DEBUG_LOOKUP) {
            String string2;
            String string3 = string2 = null == nativeLibrary ? "GLOBAL" : nativeLibrary.toString();
            if (0L != l) {
                String string4 = String.valueOf(Long.toHexString(l));
                System.err.println(new StringBuilder(28 + String.valueOf(string).length() + String.valueOf(string4).length() + String.valueOf(string2).length()).append("Lookup-Native: <").append(string).append("> 0x").append(string4).append(" in lib ").append(string2).toString());
            } else {
                String string5 = String.valueOf(this.nativeLibraries);
                System.err.println(new StringBuilder(39 + String.valueOf(string).length() + String.valueOf(string5).length()).append("Lookup-Native: <").append(string).append("> ** FAILED ** in libs ").append(string5).toString());
            }
        }
        return l;
    }

    private final long toolDynamicLookupFunction(String string) {
        if (0L != this.toolGetProcAddressHandle) {
            long l = this.info.toolGetProcAddress(this.toolGetProcAddressHandle, string);
            if (DEBUG_LOOKUP && 0L != l) {
                String string2 = String.valueOf(Long.toHexString(l));
                String string3 = String.valueOf(Long.toHexString(this.toolGetProcAddressHandle));
                System.err.println(new StringBuilder(31 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Lookup-Tool: <").append(string).append("> 0x").append(string2).append(", via tool 0x").append(string3).toString());
            }
            return l;
        }
        return 0L;
    }

    @Override
    public final void claimAllLinkPermission() throws SecurityException {
        for (int i = 0; i < this.nativeLibraries.size(); ++i) {
            this.nativeLibraries.get(i).claimAllLinkPermission();
        }
    }

    @Override
    public final void releaseAllLinkPermission() throws SecurityException {
        for (int i = 0; i < this.nativeLibraries.size(); ++i) {
            this.nativeLibraries.get(i).releaseAllLinkPermission();
        }
    }

    @Override
    public final long dynamicLookupFunction(String string) throws SecurityException {
        if (!this.isToolLibLoaded() || null == string) {
            if (DEBUG_LOOKUP && !this.isToolLibLoaded()) {
                System.err.println(new StringBuilder(54 + String.valueOf(string).length()).append("Lookup: <").append(string).append("> ** FAILED ** Tool native library not loaded").toString());
            }
            return 0L;
        }
        if (this.toolGetProcAddressFuncNameSet.contains(string)) {
            return this.toolGetProcAddressHandle;
        }
        long l = 0L;
        boolean bl = this.info.useToolGetProcAdressFirst(string);
        if (bl) {
            l = this.toolDynamicLookupFunction(string);
        }
        if (0L == l) {
            l = this.dynamicLookupFunctionOnLibs(string);
        }
        if (0L == l && !bl) {
            l = this.toolDynamicLookupFunction(string);
        }
        return l;
    }

    @Override
    public final boolean isFunctionAvailable(String string) throws SecurityException {
        return 0L != this.dynamicLookupFunction(string);
    }

    static final class GlueJNILibLoader
    extends JNILibLoaderBase {
        GlueJNILibLoader() {
        }

        protected static synchronized boolean loadLibrary(String string, boolean bl, ClassLoader classLoader) {
            return JNILibLoaderBase.loadLibrary(string, bl, classLoader);
        }
    }
}

