/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ArrayHashSet<E>
implements Cloneable,
Collection<E>,
List<E> {
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final HashMap<E, E> map;
    private final ArrayList<E> data;
    private final boolean supportNullValue;

    public ArrayHashSet() {
        this(true, 16, 0.75f);
    }

    public ArrayHashSet(int n) {
        this(true, n, 0.75f);
    }

    public ArrayHashSet(int n, float f) {
        this(true, n, f);
    }

    public ArrayHashSet(boolean bl, int n, float f) {
        this.map = new HashMap(n, f);
        this.data = new ArrayList(n);
        this.supportNullValue = bl;
    }

    public ArrayHashSet(ArrayHashSet<E> arrayHashSet) {
        this.map = new HashMap<E, E>(arrayHashSet.map);
        this.data = new ArrayList<E>(arrayHashSet.data);
        this.supportNullValue = arrayHashSet.supportNullValue;
    }

    public final boolean supportsNullValue() {
        return this.supportNullValue;
    }

    public final Object clone() {
        return new ArrayHashSet<E>(this);
    }

    public final ArrayList<E> getData() {
        return this.data;
    }

    public final HashMap<E, E> getMap() {
        return this.map;
    }

    public final String toString() {
        return this.data.toString();
    }

    @Override
    public final void clear() {
        this.data.clear();
        this.map.clear();
    }

    @Override
    public final boolean add(E e) throws NullPointerException {
        if (!this.supportNullValue) {
            ArrayHashSet.checkNull(e);
        }
        if (!this.map.containsKey(e)) {
            if (null != this.map.put(e, e)) {
                String string = String.valueOf(e);
                throw new InternalError(new StringBuilder(38 + String.valueOf(string).length()).append("Already existing, but checked before: ").append(string).toString());
            }
            if (!this.data.add(e)) {
                String string = String.valueOf(e);
                throw new InternalError(new StringBuilder(22 + String.valueOf(string).length()).append("Couldn't add element: ").append(string).toString());
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean remove(Object object) throws NullPointerException {
        if (this.supportNullValue) {
            if (this.map.containsKey(object)) {
                this.map.remove(object);
                if (!this.data.remove(object)) {
                    String string = String.valueOf(object);
                    throw new InternalError(new StringBuilder(37 + String.valueOf(string).length()).append("Couldn't remove prev mapped element: ").append(string).toString());
                }
                return true;
            }
        } else {
            ArrayHashSet.checkNull(object);
            if (null != this.map.remove(object)) {
                if (!this.data.remove(object)) {
                    String string = String.valueOf(object);
                    throw new InternalError(new StringBuilder(37 + String.valueOf(string).length()).append("Couldn't remove prev mapped element: ").append(string).toString());
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        for (E e : collection) {
            bl |= this.add(e);
        }
        return bl;
    }

    @Override
    public final boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public final boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.remove(obj);
        }
        return bl;
    }

    @Override
    public final boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            if (collection.contains(obj)) continue;
            bl |= this.remove(obj);
        }
        return bl;
    }

    @Override
    public final boolean equals(Object object) {
        if (!(object instanceof ArrayHashSet)) {
            return false;
        }
        return this.data.equals(((ArrayHashSet)object).data);
    }

    @Override
    public final int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public final Iterator<E> iterator() {
        return this.data.iterator();
    }

    @Override
    public final int size() {
        return this.data.size();
    }

    @Override
    public final Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public final <T> T[] toArray(T[] TArray) {
        return this.data.toArray(TArray);
    }

    @Override
    public final E get(int n) {
        return this.data.get(n);
    }

    @Override
    public final int indexOf(Object object) {
        return this.data.indexOf(object);
    }

    @Override
    public final void add(int n, E e) throws IllegalArgumentException, NullPointerException {
        if (!this.supportNullValue) {
            ArrayHashSet.checkNull(e);
        }
        if (this.map.containsKey(e)) {
            String string = String.valueOf(e);
            throw new IllegalArgumentException(new StringBuilder(29 + String.valueOf(string).length()).append("Element ").append(string).append(" is already contained").toString());
        }
        if (null != this.map.put(e, e)) {
            String string = String.valueOf(e);
            throw new InternalError(new StringBuilder(38 + String.valueOf(string).length()).append("Already existing, but checked before: ").append(string).toString());
        }
        this.data.add(n, e);
    }

    @Override
    public final boolean addAll(int n, Collection<? extends E> collection) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final E set(int n, E e) {
        E e2 = this.remove(n);
        if (null != e2) {
            this.add(n, e);
        }
        return e2;
    }

    @Override
    public final E remove(int n) {
        E e = this.get(n);
        if (null != e && this.remove(e)) {
            return e;
        }
        return null;
    }

    @Override
    public final int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    @Override
    public final ListIterator<E> listIterator() {
        return this.data.listIterator();
    }

    @Override
    public final ListIterator<E> listIterator(int n) {
        return this.data.listIterator(n);
    }

    @Override
    public final List<E> subList(int n, int n2) {
        return this.data.subList(n, n2);
    }

    public final ArrayList<E> toArrayList() {
        return new ArrayList<E>(this.data);
    }

    public final E get(Object object) {
        return this.map.get(object);
    }

    public final E getOrAdd(E e) throws NullPointerException {
        Object object;
        if (this.supportNullValue) {
            if (this.map.containsKey(e)) {
                return this.map.get(e);
            }
        } else {
            ArrayHashSet.checkNull(e);
            object = this.map.get(e);
            if (null != object) {
                return object;
            }
        }
        if (!this.add(e)) {
            object = String.valueOf(e);
            throw new InternalError(new StringBuilder(43 + String.valueOf(object).length()).append("Element not mapped, but contained in list: ").append((String)object).toString());
        }
        return e;
    }

    public final boolean containsSafe(Object object) {
        return this.data.contains(object);
    }

    private static final void checkNull(Object object) throws NullPointerException {
        if (null == object) {
            throw new NullPointerException("Null element not supported");
        }
    }
}

