/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp.el.typeHandler;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public abstract class ELTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        if (c == '}' && this.isElContainerFile(ELTypedHandler.getOriginalFile(file)) && ELTypedHandler.handleELClosingBrace(editor, file, project)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    protected abstract boolean isElContainerFile(PsiFile var1);

    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            ELTypedHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ELTypedHandler.$$$reportNull$$$0(1);
        }
        if (c == '{' && this.isElContainerFile(ELTypedHandler.getOriginalFile(file))) {
            return this.handleELOpeningBrace(editor, file, project);
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static PsiFile getOriginalFile(PsiFile file) {
        return file.getOriginalFile();
    }

    private TypedHandlerDelegate.Result handleELOpeningBrace(Editor editor, PsiFile file, Project project) {
        CharSequence charSequence;
        int index;
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementAt = file.findElementAt(offset - 1);
        if (elementAt != null && (index = offset - 2) >= 0 && (charSequence = editor.getDocument().getCharsSequence()).length() > index && this.isElStarted(charSequence.charAt(index)) && this.isElAcceptedForElement(elementAt)) {
            editor.getDocument().insertString(offset, (CharSequence)"}");
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    protected boolean isElAcceptedForElement(PsiElement elementAt) {
        return true;
    }

    protected boolean isElStarted(char c) {
        return c == '$' || c == '#';
    }

    private static boolean handleELClosingBrace(Editor editor, PsiFile file, Project project) {
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementAt = file.findElementAt(offset);
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)elementAt, ELExpressionHolder.class);
        if (parent != null && elementAt.getText().equals("}")) {
            editor.getCaretModel().moveToOffset(offset + 1);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/source/jsp/el/typeHandler/ELTypedHandler";
        objectArray[2] = "charTyped";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

